/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  procatr.h
 * @brief %jp{ץåƥͭ°(SH2 processor)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__arch__proc__sh__sh2__procatr_h__
#define _KERNEL__arch__proc__sh__sh2__procatr_h__


/* %jp{ץåƥΤ륤󥯥롼ɥѥ} */
#define _KERNEL_PROCATR_INC_PATH			"sh/sh2"


/* %jp{ץåƥ˰¸°} */
#define _KERNEL_PROCATR_CTX_STK				FALSE		/**< %jp{ƥ˥åΰλ꤬ɬפ} */
#define _KERNEL_PROCATR_CTX_STKSZ			FALSE		/**< %jp{ƥ˥åλ꤬ɬפ} */
#define _KERNEL_PROCATR_CTX_ISP				TRUE		/**< %jp{ƥ˽åݥͤɬפ} */
#define _KERNEL_PROCATR_CTX_DEL				FALSE		/**< %jp{̥ƥȤΥƥȺɬפ} */
#define _KERNEL_PROCATR_CTX_RST				TRUE		/**< %jp{ƥȤΥꥹȤǽ} */

#define _KERNEL_PROCATR_TMIN_STKSZ			(4*16)		/**< %jp{ɬפʥå(byteñ)} */

#define _KERNEL_PROCATR_SPT_SMP				FALSE		/**< %jp{SMPбƤ뤫} */
#define _KERNEL_PROCATR_SPT_MULTINT			TRUE		/**< %jp{¿ųߤбƤ뤫} */

#define _KERNEL_PROCATR_TMIN_INHNO			64			/**< %jp{ߥϥɥֹκǾ} */
#define _KERNEL_PROCATR_TMAX_INHNO			255			/**< %jp{ߥϥɥֹκ} */

#define _KERNEL_PROCATR_TMIN_EXCNO			4			/**< %jp{CPU㳰ϥɥֹκǾ} */
#define _KERNEL_PROCATR_TMAX_EXCNO			63			/**< %jp{CPU㳰ϥɥֹκ} */

#define _KERNEL_PROCATR_EXCSTK_NUM			0			/**< %jp{CPU㳰ѥåϲɬפ} */
#define _KERNEL_PROCATR_INTSTK_NUM			1			/**< %jp{ߥåϲɬפ} */

#define _KERNEL_PROCATR_SIGNED_INT			0			/**< %jp{̵Τɤ餬դ(դ:1, ̵:-1, Ʊ:0)} */
#define _KERNEL_PROCATR_TBIT_INT			32			/**< %jp{ץå˺ŬΥӥåȿ} */
#define _KERNEL_PROCATR_TBIT_PTR			32			/**< %jp{ݥ󥿤Υӥåȿ} */
#define _KERNEL_PROCATR_MEM_ALIGN			8			/**< %jp{ŬڤʥΥ饤(byteñ)} */
#define _KERNEL_PROCATR_STK_ALIGN			4			/**< %jp{ŬڤʥåΥ饤(byteñ)} */
#define _KERNEL_PROCATR_ALLOW_UNALIGN		FALSE		/**< %jp{󥢥饤󥢥ϲǽ} */


#endif	/* _KERNEL__arch__proc__sh__sh2__procatr_h__ */


/* end of file */
