/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  itron.h
 * @brief %en{uITRON4.0 standard header file}%jp{ITRON4.0Ѥɸإåե}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef _KERNEL__itron_h__
#define _KERNEL__itron_h__



/* ------------------------------------ */
/*             Constants                */
/* ------------------------------------ */

/* %jp{}%en{General Constants} */
#ifndef NULL
#ifdef __cplusplus
#define NULL					0						/**< %jp{̵ݥ}%en{Invalid pointer} */
#else
#define NULL					((void *)0)				/**< %jp{̵ݥ}%en{Invalid pointer} */
#endif
#endif


#define TRUE					1						/**< %jp{}%en{True} */
#define FALSE					0						/**< %jp{}%en{Flase} */
#define E_OK					0						/**< %jp{ｪλ}%en{Normal completion} */


/* %jp{֥°}%en{Object Attributes} */
#define TA_NULL					0						/**< %jp{֥°ꤷʤ}%en{Object attribute unspecified} */
#define TA_HLNG					0x00					/**< %jp{ѤΥ󥿡եǽñ̤ư}%en{Start a processing unit through a high-level language interface} */
#define TA_ASM					0x01					/**< %jp{֥ѤΥ󥿡եǽñ̤ư}%en{Start a processing unit through an assembly language interface} */

#define TA_TFIFO				0x00					/**< %jp{ԤFIFO}%en{Task wait queue is in FIFO order} */
#define TA_TPRI					0x01					/**< %jp{Ԥ򥿥ͥٽ}%en{Task wait queue is in task priority order} */

#define TA_MFIFO				0x00					/**< %jp{åԤFIFO}%en{Message queue is in FIFO order} */
#define TA_MPRI					0x02					/**< %jp{åԤåͥٽ}%en{Message queue is in message priority order} */

#define TA_ACT					0x02					/**< %jp{ư줿֤}%en{Task is activated after the creation} */
#define TA_RSTR					0x04					/**< %jp{󥿥}%en{Restricted task} */

#define TA_WSGL					0x00					/**< %jp{٥ȥե饰ʣΥԤĤȤʤ}%en{Only one task is allowed to be in the waiting state for the eventflag} */
#define TA_WMUL					0x02					/**< %jp{٥ȥե饰ʣΥԤĤȤ}%en{Multiple tasks are allowed to be in the waiting state for the eventflag} */
#define TA_CLR					0x04					/**< %jp{Ԥ˥٥ȥե饰򥯥ꥢ}%en{Eventflag's bit pattern is cleared when a task is released from the waiting state for that eventflag} */

#define TA_INHERIT				0x02					/**< %jp{ߥ塼ƥåͥٷѾץȥ򥵥ݡ}%en{Mutex uses the priority inheritance protocol} */
#define TA_CEILING				0x03					/**< %jp{ߥ塼ƥåͥپ¥ץȥ򥵥ݡ}%en{Mutex uses the priority ceiling protocol} */

#define TA_STA					0x02					/**< %jp{ϥɥưƤ֤}%en{Cyclic handler is in an operational state after the creation} */
#define TA_PHS					0x04					/**< %jp{ϥɥΰ¸}%en{Cyclic handler is activated preserving the activation phase} */


/* %jp{ॢȻ} */
#define TMO_POL					0						/**< %jp{ݡ}%en{Polling} */
#define TMO_FEVR				(-1)					/**< %jp{ʵԤ}%en{Waiting forever} */
#define TMO_NBLK				(-2)					/**< %jp{Υ֥å}%en{Non-blocking} */


/* %jp{ӥư⡼}%en{Service Call Operational Mode} */
#define TWF_ANDW				0x00					/**< %jp{٥ȥե饰ANDԤ}%en{AND waiting condition for eventflag} */
#define TWF_ORW					0x01					/**< %jp{٥ȥե饰ORԤ}%en{OR waiting condition for eventflag} */


/* %jp{֥Ȥξ}%en{Object State} */
#define TTS_RUN					0x01					/**< %jp{¹Ծ}%en{RUNNING state} */
#define TTS_RDY					0x02					/**< %jp{¹Բǽ}%en{READY state} */
#define TTS_WAI					0x04					/**< %jp{Ԥ}%en{WAITING state} */
#define TTS_SUS					0x08					/**< %jp{Ԥ}%en{SUSPENDED state} */
#define TTS_WAS					0x0c					/**< %jp{Ԥ}%en{WAITING-SUSPENDED state} */
#define TTS_DMT					0x10					/**< %jp{ٻ߾}%en{DORMANT state} */

#define TTW_SLP					0x0001					/**< %jp{Ԥ}%en{} */
#define TTW_DLY					0x0002					/**< %jp{ַвԤ}%en{} */
#define TTW_SEM					0x0004					/**< %jp{ޥե񸻤γԤ}%en{} */
#define TTW_FLG					0x0008					/**< %jp{٥ȥե饰Ԥ}%en{} */
#define TTW_SDTQ				0x0010					/**< %jp{ǡ塼ؤԤ}%en{} */
#define TTW_RDTQ				0x0020					/**< %jp{ǡ塼μԤ}%en{} */
#define TTW_MBX					0x0040					/**< %jp{᡼ܥåμԤ}%en{} */
#define TTW_MTX					0x0080					/**< %jp{ߥ塼ƥåΥåԤ}%en{} */
#define TTW_SMBF				0x0100					/**< %jp{åХåեؤԤ}%en{} */
#define TTW_RMBF				0x0200					/**< %jp{åХåեμԤ}%en{} */
#define TTW_CAL					0x0400					/**< %jp{ǥ֤θƤӽФԤ}%en{} */
#define TTW_ACP					0x0800					/**< %jp{ǥ֤μԤ}%en{} */
#define TTW_RDV					0x1000					/**< %jp{ǥ֤νλԤ}%en{} */
#define TTW_MPF					0x2000					/**< %jp{Ĺ֥åγԤ}%en{} */
#define TTW_MPL					0x4000					/**< %jp{Ĺ֥åγԤ}%en{} */

#define TTEX_ENA				0x00					/**< %jp{㳰ľ}%en{} */
#define TTEX_DIS				0x01					/**< %jp{㳰ػ߾}%en{} */

#define TCYC_STP				0x00					/**< %jp{ϥɥ餬ưƤʤ}%en{} */
#define TCYC_STA				0x01					/**< %jp{ϥɥ餬ưƤ}%en{} */

#define TALM_STP				0x00					/**< %jp{顼ϥɥ餬ưƤʤ}%en{} */
#define TALM_STA				0x00					/**< %jp{顼ϥɥ餬ưƤ} */

#define TOVR_STP				0x00					/**< %jp{¥ץå֤ꤵƤʤ}%en{} */
#define TOVR_STA				0x01					/**< %jp{¥ץå֤ꤵƤ}%en{} */

/* %jp{¾}%en{Other constants} */
#define TSK_SELF				0						/**< %jp{}%en{} */
#define TSK_NONE				0						/**< %jp{륿̵}%en{} */

#define TPRI_SELF				0						/**< %jp{Υ١ͥ٤λ}%en{} */
#define TPRI_INI				0						/**< %jp{εưͥ٤λ}%en{} */


/* %jp{顼}%en{Error code} */
#define E_SYS					(-5)					/**< %jp{ƥ२顼}%en{System error} */
#define E_NOSPT					(-9)					/**< %jp{̤ݡȵǽ}%en{Unsupported function} */
#define E_RSFN					(-10)					/**< %jp{ͽǽ}%en{Reserved function code} */
#define E_RSATR					(-11)					/**< %jp{ͽ°}%en{Reserved attribute} */
#define E_PAR					(-17)					/**< %jp{ѥ᡼顼}%en{Parameter error} */
#define E_ID					(-18)					/**< %jp{IDֹ}%en{Invalid ID number} */
#define E_CTX					(-25)					/**< %jp{ƥȥ顼}%en{Context error} */
#define E_MACV					(-26)					/**< %jp{ꥢȿ}%en{} */
#define E_OACV					(-27)					/**< %jp{֥ȥȿ}%en{} */
#define E_ILUSE					(-28)					/**< %jp{ӥ}%en{} */
#define E_NOMEM					(-33)					/**< %jp{­}%en{} */
#define E_NOID					(-34)					/**< %jp{IDֹ­}%en{} */
#define E_OBJ					(-41)					/**< %jp{֥Ⱦ֥顼}%en{} */
#define E_NOEXS					(-42)					/**< %jp{֥̤}%en{} */
#define E_QOVR					(-43)					/**< %jp{塼󥰥Сե}%en{} */
#define E_RLWAI					(-49)					/**< %jp{Ԥ֤ζ}%en{} */
#define E_TMOUT					(-50)					/**< %jp{ݡ󥰼Ԥޤϥॢ}%en{} */
#define E_DLT					(-51)					/**< %jp{Ԥ֥Ȥκ}%en{} */
#define E_CLS					(-52)					/**< %jp{Ԥ֥ȤξѲ}%en{} */
#define E_WBLK					(-57)					/**< %jp{Υ֥å󥰼դ}%en{} */
#define E_BOVR					(-58)					/**< %jp{ХåեСե}%en{} */



#define TMIN_TPRI				1
#define TMIN_MPRI				1




/* ------------------------------------ */
/*     Include configulation file       */
/* ------------------------------------ */

#include "core/basetyp.h"
#include "config/cfgsys.h"
#include "parser/parssys.h"




/* ------------------------------------ */
/*             Data type                */
/* ------------------------------------ */

/* %jp{ץߥƥַ} */
typedef _KERNEL_T_B				B;						/**< %jp{դ 8ӥå}%en{Signed  8-bit integer} */
typedef _KERNEL_T_H				H;						/**< %jp{դ16ӥå}%en{Signed 16-bit integer} */
typedef _KERNEL_T_W				W;						/**< %jp{դ32ӥå}%en{Signed 32-bit integer} */
#if _KERNEL_ENABLE64
typedef _KERNEL_T_D				D;						/**< %jp{դ64ӥå}%en{Signed 64-bit integer} */
#endif

typedef _KERNEL_T_UB			UB;						/**< %jp{̵ 8ӥå}%en{Unsigned  8-bit integer} */
typedef _KERNEL_T_UH			UH;						/**< %jp{̵16ӥå}%en{Unsigned 16-bit integer} */
typedef _KERNEL_T_UW			UW;						/**< %jp{̵32ӥå}%en{Unsigned 32-bit integer} */
#if _KERNEL_ENABLE64
typedef _KERNEL_T_UD			UD;						/**< %jp{դ64ӥå}%en{Signed 64-bit integer} */
#endif

typedef B						VB;						/**< %jp{ǡפޤʤ 8ӥåȤ}%en{ 8-bit value with unknown data type} */
typedef H						VH;						/**< %jp{ǡפޤʤ16ӥåȤ}%en{16-bit value with unknown data type} */
typedef W						VW;						/**< %jp{ǡפޤʤ32ӥåȤ}%en{32-bit value with unknown data type} */
#if _KERNEL_ENABLE64
typedef D						VD;						/**< %jp{ǡפޤʤ64ӥåȤ}%en{64-bit value with unknown data type} */
#endif



/* %jp{INT} */
#if _KERNEL_TBIT_INT == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		INT;					/**< %jp{ץå˼ʥդ}%en{Signed integer for the processor} */
#define _KERNEL_TMIN_INT		_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_INT		_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_INT == 8			/* 8-bit */

typedef _KERNEL_T_B				INT;					/**< %jp{ץå˼ʥդ}%en{Signed integer for the processor} */
#define _KERNEL_TMIN_INT		_KERNEL_TMIN_B
#define _KERNEL_TMAX_INT		_KERNEL_TMAX_B

#elif _KERNEL_TBIT_INT == 16			/* 16-bit */

typedef _KERNEL_T_H				INT;					/**< %jp{ץå˼ʥդ}%en{Signed integer for the processor} */
#define _KERNEL_TMIN_INT		_KERNEL_TMIN_H
#define _KERNEL_TMAX_INT		_KERNEL_TMAX_H

#elif _KERNEL_TBIT_INT == 32			/* 32-bit */

typedef _KERNEL_T_W				INT;					/**< %jp{ץå˼ʥդ}%en{Signed integer for the processor} */
#define _KERNEL_TMIN_INT		_KERNEL_TMIN_W
#define _KERNEL_TMAX_INT		_KERNEL_TMAX_W

#elif _KERNEL_TBIT_INT == 64			/* 64-bit */

typedef _KERNEL_T_D				INT;					/**< %jp{ץå˼ʥդ}%en{Signed integer for the processor} */
#define _KERNEL_TMIN_INT		_KERNEL_TMIN_D
#define _KERNEL_TMAX_INT		_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_INT

#endif



/* %jp{UINT} */
#if _KERNEL_TBIT_UINT == _KERNEL_TBIT_PROC_UINT

typedef _KERNEL_T_PROC_UINT		UINT;					/**< %jp{ץå˼ʥդ}%en{Unsigned integer for the processor}  */
#define _KERNEL_TMIN_UINT		_KERNEL_TMIN_PROC_UINT
#define _KERNEL_TMAX_UINT		_KERNEL_TMAX_PROC_UINT

#elif _KERNEL_TBIT_UINT == 8			/* 8-bit */

typedef _KERNEL_T_UB			UINT;					/**< %jp{ץå˼ʥդ}%en{Unsigned integer for the processor}  */
#define _KERNEL_TMIN_UINT		_KERNEL_TMIN_UB
#define _KERNEL_TMAX_UINT		_KERNEL_TMAX_UB

#elif _KERNEL_TBIT_UINT == 16		/* 16-bit */

typedef _KERNEL_T_UH			UINT;					/**< %jp{ץå˼ʥդ}%en{Unsigned integer for the processor} */
#define _KERNEL_TMIN_UINT		_KERNEL_TMIN_UH
#define _KERNEL_TMAX_UINT		_KERNEL_TMAX_UH

#elif _KERNEL_TBIT_UINT == 32		/* 32-bit */

typedef _KERNEL_T_UW			UINT;					/**< %jp{ץå˼ʥդ}%en{Unsigned integer for the processor} */
#define _KERNEL_TMIN_UINT		_KERNEL_TMIN_UW
#define _KERNEL_TMAX_UINT		_KERNEL_TMAX_UW

#elif _KERNEL_TBIT_UINT == 64		/* 64-bit */

typedef _KERNEL_T_UD			UINT;					/**< %jp{ץå˼ʥդ}%en{Unsigned integer for the processor} */
#define _KERNEL_TMIN_UINT		_KERNEL_TMIN_UD
#define _KERNEL_TMAX_UINT		_KERNEL_TMAX_UD

#else								/* error */

#error Illegal value : _KERNEL_TBIT_UINT

#endif



/* %jp{ݥ󥿷} */
typedef _KERNEL_T_VP			VP;						/**< %jp{ǡפޤʤΤؤΥݥ}%en{Pointer to an unknown data type} */



/* %jp{ؿݥ󥿷} */
typedef void					(*FP)();				/**< %jp{ץεư(ݥ)}%en{Processing unit start address(pointer to a function)} */
#define _KERNEL_TBIT_FP			_KERNEL_TBIT_VP



/* %jp{ݥ󥿤ǼǤ} */
#if _KERNEL_VP_INT_PTR		/* %jp{VP_INTݥ󥿷ˤʤ} */

typedef _KERNEL_T_VP			VP_INT;					/**< %jp{ǡפޤʤΤؤΥݥ󥿤ޤϥץå˼ʥդ}%en{Pointer to an unknown data type, or a signed integer for the processor} */
#define _KERNEL_TBIT_VP_INT		_KERNEL_TBIT_VP

#else						/* %jp{VP_INTˤʤ} */

#if (_KERNEL_TMIN_INTPTR >= _KERNEL_TMIN_INT) && (_KERNEL_TMAX_INTPTR <= _KERNEL_TMAX_INT)
typedef INT						VP_INT;					/**< %jp{ǡפޤʤΤؤΥݥ󥿤ޤϥץå˼ʥդ}%en{Pointer to an unknown data type, or a signed integer for the processor} */
#define _KERNEL_TMIN_VP_INT		_KERNEL_TMIN_INT
#define _KERNEL_TMAX_VP_INT		_KERNEL_TMAX_INT
#define _KERNEL_TBIT_VP_INT		_KERNEL_TBIT_INT
#else
typedef _KERNEL_T_INTPTR		VP_INT;					/**< %jp{ǡפޤʤΤؤΥݥ󥿤ޤϥץå˼ʥդ}%en{Pointer to an unknown data type, or a signed integer for the processor} */
#define _KERNEL_TMIN_VP_INT		_KERNEL_TMIN_INTPTR
#define _KERNEL_TMAX_VP_INT		_KERNEL_TMAX_INTPTR
#define _KERNEL_TBIT_VP_INT		_KERNEL_TBIT_INTPTR
#endif

#endif



/* %jp{BOOL} */
#if _KERNEL_TBIT_BOOL == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		BOOL;					/**< %jp{}%en{Boolean value(TRUE or FALSE)} */
#define _KERNEL_TMIN_BOOL		_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_BOOL		_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_BOOL == 8			/* 8-bit */

typedef _KERNEL_T_B				BOOL;					/**< %jp{}%en{Boolean value(TRUE or FALSE)} */
#define _KERNEL_TMIN_BOOL		_KERNEL_TMIN_B
#define _KERNEL_TMAX_BOOL		_KERNEL_TMAX_B

#elif _KERNEL_TBIT_BOOL == 16		/* 16-bit */

typedef _KERNEL_T_H				BOOL;					/**< %jp{}%en{Boolean value(TRUE or FALSE)} */
#define _KERNEL_TMIN_BOOL		_KERNEL_TMIN_H
#define _KERNEL_TMAX_BOOL		_KERNEL_TMAX_H

#elif _KERNEL_TBIT_BOOL == 32		/* 32-bit */

typedef _KERNEL_T_W				BOOL;					/**< %jp{}%en{Boolean value(TRUE or FALSE)} */
#define _KERNEL_TMIN_BOOL		_KERNEL_TMIN_W
#define _KERNEL_TMAX_BOOL		_KERNEL_TMAX_W

#elif _KERNEL_TBIT_BOOL == 64		/* 64-bit */

typedef _KERNEL_T_D				BOOL;					/**< %jp{}%en{Boolean value(TRUE or FALSE)} */
#define _KERNEL_TMIN_BOOL		_KERNEL_TMIN_D
#define _KERNEL_TMAX_BOOL		_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_BOOL

#endif



/* %jp{ǽɤ}%en{Function code} */
#if _KERNEL_TBIT_FN == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		FN;						/**< %jp{ǽ}%en{Function code(signed integer)} */
#define _KERNEL_TMIN_FN			_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_FN			_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_FN == 8				/* 8-bit */

typedef _KERNEL_T_B				FN;						/**< %jp{ǽ}%en{Function code(signed integer)} */
#define _KERNEL_TMIN_FN			_KERNEL_TMIN_B
#define _KERNEL_TMAX_FN			_KERNEL_TMAX_B

#elif _KERNEL_TBIT_FN == 16			/* 16-bit */

typedef _KERNEL_T_H				FN;						/**< %jp{ǽ}%en{Function code(signed integer)} */
#define _KERNEL_TMIN_FN			_KERNEL_TMIN_H
#define _KERNEL_TMAX_FN			_KERNEL_TMAX_H

#elif _KERNEL_TBIT_FN == 32			/* 32-bit */

typedef _KERNEL_T_W				FN;						/**< %jp{ǽ}%en{Function code(signed integer)} */
#define _KERNEL_TMIN_FN			_KERNEL_TMIN_W
#define _KERNEL_TMAX_FN			_KERNEL_TMAX_W

#elif _KERNEL_TBIT_FN == 64			/* 64-bit */

typedef _KERNEL_T_D				FN;						/**< %jp{ǽ}%en{Function code(signed integer)} */
#define _KERNEL_TMIN_FN			_KERNEL_TMIN_D
#define _KERNEL_TMAX_FN			_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_CFG_TBIT_FN

#endif



/* %jp{顼}%en{Error code(signed integer)} */
#if _KERNEL_TBIT_ER == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		ER;						/**< %jp{顼}%en{Error code(signed integer)} */
#define _KERNEL_TMIN_ER			_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_ER			_KERNEL_TMAX_PROC_INT


#elif _KERNEL_TBIT_ER == 8			/* 8-bit */

typedef _KERNEL_T_B				ER;						/**< %jp{顼}%en{Error code(signed integer)} */
#define _KERNEL_TMIN_ER			_KERNEL_TMIN_B
#define _KERNEL_TMAX_ER			_KERNEL_TMAX_B

#elif _KERNEL_TBIT_ER == 16			/* 16-bit */

typedef _KERNEL_T_H				ER;						/**< %jp{顼}%en{Error code(signed integer)} */
#define _KERNEL_TMIN_ER			_KERNEL_TMIN_H
#define _KERNEL_TMAX_ER			_KERNEL_TMAX_H

#elif _KERNEL_TBIT_ER == 32			/* 32-bit */

typedef _KERNEL_T_W				ER;						/**< %jp{顼}%en{Error code(signed integer)} */
#define _KERNEL_TMIN_ER			_KERNEL_TMIN_W
#define _KERNEL_TMAX_ER			_KERNEL_TMAX_W

#elif _KERNEL_TBIT_ER == 64			/* 64-bit */

typedef _KERNEL_T_D				ER;						/**< %jp{顼}%en{Error code(signed integer)} */
#define _KERNEL_TMIN_ER			_KERNEL_TMIN_D
#define _KERNEL_TMAX_ER			_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_ER

#endif



/* %jp{֥IDֹ}%en{Object ID number(signed integer)} */
#if _KERNEL_TBIT_ID == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		ID;						/**< %jp{֥IDֹ}%en{Object ID number(signed integer)} */
#define _KERNEL_TMIN_ID			_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_ID			_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_ID == 8			/* 8-bit */

typedef _KERNEL_T_B				ID;						/**< %jp{֥IDֹ}%en{Object ID number(signed integer)} */
#define _KERNEL_TMIN_ID			_KERNEL_TMIN_B
#define _KERNEL_TMAX_ID			_KERNEL_TMAX_B

#elif _KERNEL_TBIT_ID == 16			/* 16-bit */

typedef _KERNEL_T_H				ID;						/**< %jp{֥IDֹ}%en{Object ID number(signed integer)} */
#define _KERNEL_TMIN_ID			_KERNEL_TMIN_H
#define _KERNEL_TMAX_ID			_KERNEL_TMAX_H

#elif _KERNEL_TBIT_ID == 32			/* 32-bit */

typedef _KERNEL_T_W				ID;						/**< %jp{֥IDֹ}%en{Object ID number(signed integer)} */
#define _KERNEL_TMIN_ID			_KERNEL_TMIN_W
#define _KERNEL_TMAX_ID			_KERNEL_TMAX_W

#elif _KERNEL_TBIT_ID == 64			/* 8-bit */

typedef _KERNEL_T_D				ID;						/**< %jp{֥IDֹ}%en{Object ID number(signed integer)} */
#define _KERNEL_TMIN_ID			_KERNEL_TMIN_D
#define _KERNEL_TMAX_ID			_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_ID

#endif



/* %jp{֥°}%en{Object attribute(unsigned integer)} */
#if _KERNEL_TBIT_ATR == _KERNEL_TBIT_PROC_UINT

typedef _KERNEL_T_PROC_UINT		ATR;					/**< %jp{֥Ⱦ}%en{Object state(unsigned integer)} */			
#define _KERNEL_TMIN_ATR		_KERNEL_TMIN_PROC_UINT
#define _KERNEL_TMAX_ATR		_KERNEL_TMAX_PROC_UINT

#elif _KERNEL_TBIT_ATR == 8			/* 8-bit */

typedef _KERNEL_T_UB			ATR;					/**< %jp{֥°}%en{Object attribute(unsigned integer)} */
#define _KERNEL_TMIN_ATR		_KERNEL_TMIN_UB
#define _KERNEL_TMAX_ATR		_KERNEL_TMAX_UB

#elif _KERNEL_TBIT_ATR == 16		/* 16-bit */

typedef _KERNEL_T_UH			ATR;					/**< %jp{֥°}%en{Object attribute(unsigned integer)} */
#define _KERNEL_TMIN_ATR		_KERNEL_TMIN_UH
#define _KERNEL_TMAX_ATR		_KERNEL_TMAX_UH

#elif _KERNEL_TBIT_ATR == 32		/* 32-bit */

typedef _KERNEL_T_UW			ATR;					/**< %jp{֥°}%en{Object attribute(unsigned integer)} */
#define _KERNEL_TMIN_ATR		_KERNEL_TMIN_UW
#define _KERNEL_TMAX_ATR		_KERNEL_TMAX_UW

#elif _KERNEL_TBIT_ATR == 64		/* 64-bit */

typedef _KERNEL_T_UD			ATR;					/**< %jp{֥°}%en{Object attribute(unsigned integer)} */
#define _KERNEL_TMIN_ATR		_KERNEL_TMIN_UD
#define _KERNEL_TMAX_ATR		_KERNEL_TMAX_UD

#else								/* error */

#error Illegal value : _KERNEL_TBIT_ATR

#endif



/* %jp{֥Ⱦ}%en{Object state(unsigned integer)} */
#if _KERNEL_TBIT_STAT == _KERNEL_TBIT_PROC_UINT

typedef _KERNEL_T_PROC_UINT		STAT;					/**< %jp{֥Ⱦ}%en{Object state(unsigned integer)} */			
#define _KERNEL_TMIN_STAT		_KERNEL_TMIN_PROC_UINT
#define _KERNEL_TMAX_STAT		_KERNEL_TMAX_PROC_UINT

#elif _KERNEL_TBIT_STAT == 8		/* 8-bit */

typedef _KERNEL_T_UB			STAT;					/**< %jp{֥Ⱦ}%en{Object state(unsigned integer)} */			
#define _KERNEL_TMIN_STAT		_KERNEL_TMIN_UB
#define _KERNEL_TMAX_STAT		_KERNEL_TMAX_UB

#elif _KERNEL_TBIT_STAT == 16		/* 16-bit */

typedef _KERNEL_T_UH			STAT;					/**< %jp{֥Ⱦ}%en{Object state(unsigned integer)} */
#define _KERNEL_TMIN_STAT		_KERNEL_TMIN_UH
#define _KERNEL_TMAX_STAT		_KERNEL_TMAX_UH

#elif _KERNEL_TBIT_STAT == 32		/* 32-bit */

typedef _KERNEL_T_UW			STAT;					/**< %jp{֥Ⱦ}%en{Object state(unsigned integer)} */
#define _KERNEL_TMIN_STAT		_KERNEL_TMIN_UW
#define _KERNEL_TMAX_STAT		_KERNEL_TMAX_UW

#elif _KERNEL_TBIT_STAT == 64		/* 8-bit */

typedef _KERNEL_T_UD			STAT;					/**< %jp{֥Ⱦ}%en{Object state(unsigned integer)} */
#define _KERNEL_TMIN_STAT		_KERNEL_TMIN_UD
#define _KERNEL_TMAX_STAT		_KERNEL_TMAX_UD

#else								/* error */

#error Illegal value : _KERNEL_CFG_TBIT_STAT

#endif



/* %jp{ӥư⡼}%en{Service call operational mode(unsigned integer)} */
#if _KERNEL_TBIT_MODE == _KERNEL_TBIT_PROC_UINT

typedef _KERNEL_T_PROC_UINT		MODE;					/**< %jp{ӥư⡼}%en{Service call operational mode(unsigned integer)} */
#define _KERNEL_TMIN_MODE		_KERNEL_TMIN_PROC_UINT
#define _KERNEL_TMAX_MODE		_KERNEL_TMAX_PROC_UINT

#elif _KERNEL_TBIT_MODE == 8		/* 8-bit */

typedef _KERNEL_T_UB			MODE;					/**< %jp{ӥư⡼}%en{Service call operational mode(unsigned integer)} */
#define _KERNEL_TMIN_MODE		_KERNEL_TMIN_UB
#define _KERNEL_TMAX_MODE		_KERNEL_TMAX_UB

#elif _KERNEL_TBIT_MODE == 16		/* 16-bit */

typedef _KERNEL_T_UH			MODE;					/**< %jp{ӥư⡼}%en{Service call operational mode(unsigned integer)} */
#define _KERNEL_TMIN_MODE		_KERNEL_TMIN_UH
#define _KERNEL_TMAX_MODE		_KERNEL_TMAX_UH

#elif _KERNEL_TBIT_MODE == 32		/* 32-bit */

typedef _KERNEL_T_UW			MODE;					/**< %jp{ӥư⡼}%en{Service call operational mode(unsigned integer)} */
#define _KERNEL_TMIN_MODE		_KERNEL_TMIN_UW
#define _KERNEL_TMAX_MODE		_KERNEL_TMAX_UW

#elif _KERNEL_TBIT_MODE == 64		/* 8-bit */

typedef _KERNEL_T_UD			MODE;					/**< %jp{ӥư⡼}%en{Service call operational mode(unsigned integer)} */
#define _KERNEL_TMIN_MODE		_KERNEL_TMIN_UD
#define _KERNEL_TMAX_MODE		_KERNEL_TMAX_UD

#else								/* error */

#error Illegal value : _KERNEL_TBIT_MODE

#endif



/* %jp{ͥ}%en{Priority(signed integer)} */
#if _KERNEL_TBIT_PRI == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		PRI;					/**< %jp{ͥ(դ)}%en{Priority(signed integer)} */
#define _KERNEL_TMIN_PRI		_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_PRI		_KERNEL_TMAX_PROC_INT

#elif _KERNEL_CFG_TBIT_PRI == 8		/* 8-bit */

typedef _KERNEL_T_B				PRI;					/**< %jp{ͥ(դ)}%en{Priority(signed integer)} */
#define _KERNEL_TMIN_PRI		_KERNEL_TMIN_B
#define _KERNEL_TMAX_PRI		_KERNEL_TMAX_B

#elif _KERNEL_CFG_TBIT_PRI == 16	/* 16-bit */

typedef _KERNEL_T_H				PRI;					/**< %jp{ͥ(դ)}%en{Priority(signed integer)} */
#define _KERNEL_TMIN_PRI		_KERNEL_TMIN_H
#define _KERNEL_TMAX_PRI		_KERNEL_TMAX_H

#elif _KERNEL_CFG_TBIT_PRI == 32	/* 32-bit */

typedef _KERNEL_T_W				PRI;					/**< %jp{ͥ(դ)}%en{Priority(signed integer)} */
#define _KERNEL_TMIN_PRI		_KERNEL_TMIN_W
#define _KERNEL_TMAX_PRI		_KERNEL_TMAX_W

#elif _KERNEL_CFG_TBIT_PRI == 64	/* 8-bit */

typedef _KERNEL_T_D				PRI;					/**< %jp{ͥ(դ)}%en{Priority(signed integer)} */
#define _KERNEL_TMIN_PRI		_KERNEL_TMIN_D
#define _KERNEL_TMAX_PRI		_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_PRI

#endif



/* %jp{ΰΥ(̵)}%en{Memory area size(unsigned integer)} */
#if _KERNEL_TBIT_SIZE == _KERNEL_TBIT_PROC_UINT

typedef _KERNEL_T_PROC_UINT		SIZE;					/**< %jp{ΰΥ(̵)}%en{Memory area size(unsigned integer)} */
#define _KERNEL_TMIN_SIZE		_KERNEL_TMIN_PROC_UINT
#define _KERNEL_TMAX_SIZE		_KERNEL_TMAX_PROC_UINT

#elif _KERNEL_TBIT_SIZE == 8		/* 8-bit */

typedef _KERNEL_T_UB			SIZE;					/**< %jp{ΰΥ(̵)}%en{Memory area size(unsigned integer)} */		
#define _KERNEL_TMIN_SIZE		_KERNEL_TMIN_UB
#define _KERNEL_TMAX_SIZE		_KERNEL_TMAX_UB

#elif _KERNEL_TBIT_SIZE == 16		/* 16-bit */

typedef _KERNEL_T_UH			SIZE;					/**< %jp{ΰΥ(̵)}%en{Memory area size(unsigned integer)} */
#define _KERNEL_TMIN_SIZE		_KERNEL_TMIN_UH
#define _KERNEL_TMAX_SIZE		_KERNEL_TMAX_UH

#elif _KERNEL_TBIT_SIZE == 32		/* 32-bit */

typedef _KERNEL_T_UW			SIZE;					/**< %jp{ΰΥ(̵)}%en{Memory area size(unsigned integer)} */
#define _KERNEL_TMIN_SIZE		_KERNEL_TMIN_UW
#define _KERNEL_TMAX_SIZE		_KERNEL_TMAX_UW

#elif _KERNEL_TBIT_SIZE == 64		/* 8-bit */

typedef _KERNEL_T_UD			SIZE;					/**< %jp{ΰΥ(̵)}%en{Memory area size(unsigned integer)} */
#define _KERNEL_TMIN_SIZE		_KERNEL_TMIN_UD
#define _KERNEL_TMAX_SIZE		_KERNEL_TMAX_UD

#else								/* error */

#error Illegal value : _KERNEL_TBIT_SIZE

#endif



/* %jp{ॢ}%en{Timeout} */
#if _KERNEL_TBIT_TMO == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		TMO;					/**< %jp{ॢ}%en{Timeout} */
#define _KERNEL_TMIN_TMO		_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_TMO		_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_TMO == 8			/* 8-bit */

typedef _KERNEL_T_B				TMO;					/**< %jp{ॢ}%en{Timeout} */
#define _KERNEL_TMIN_TMO		_KERNEL_TMIN_B
#define _KERNEL_TMAX_TMO		_KERNEL_TMAX_B

#elif _KERNEL_TBIT_TMO == 16		/* 16-bit */

typedef _KERNEL_T_H				TMO;					/**< %jp{ॢ}%en{Timeout} */
#define _KERNEL_TMIN_TMO		_KERNEL_TMIN_H
#define _KERNEL_TMAX_TMO		_KERNEL_TMAX_H

#elif _KERNEL_TBIT_TMO == 32			/* 32-bit */

typedef _KERNEL_T_W				TMO;					/**< %jp{ॢ}%en{Timeout} */
#define _KERNEL_TMIN_TMO		_KERNEL_TMIN_W
#define _KERNEL_TMAX_TMO		_KERNEL_TMAX_W

#elif _KERNEL_TBIT_TMO == 64			/* 8-bit */

typedef _KERNEL_T_D				TMO;					/**< %jp{ॢ}%en{Timeout} */
#define _KERNEL_TMIN_TMO		_KERNEL_TMIN_D
#define _KERNEL_TMAX_TMO		_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_TMO

#endif



/* %jp{л(̵, ñ̤ϼ)}%en{Relative time(unsigned integer, unit of time is implementation-defined)} */
#if _KERNEL_TBIT_RELTIM == _KERNEL_TBIT_PROC_UINT

typedef _KERNEL_T_PROC_UINT		RELTIM;					/**< %jp{л(̵, ñ̤ϼ)}%en{Relative time(unsigned integer, unit of time is implementation-defined)} */
#define _KERNEL_TMIN_RELTIM		_KERNEL_TMIN_PROC_UINT
#define _KERNEL_TMAX_RELTIM		_KERNEL_TMAX_PROC_UINT

#elif _KERNEL_TBIT_RELTIM == 8		/* 8-bit */

typedef _KERNEL_T_UB			RELTIM;					/**< %jp{л(̵, ñ̤ϼ)}%en{Relative time(unsigned integer, unit of time is implementation-defined)} */		
#define _KERNEL_TMIN_RELTIM		_KERNEL_TMIN_UB
#define _KERNEL_TMAX_RELTIM		_KERNEL_TMAX_UB

#elif _KERNEL_TBIT_RELTIM == 16		/* 16-bit */

typedef _KERNEL_T_UH			RELTIM;					/**< %jp{л(̵, ñ̤ϼ)}%en{Relative time(unsigned integer, unit of time is implementation-defined)} */
#define _KERNEL_TMIN_RELTIM		_KERNEL_TMIN_UH
#define _KERNEL_TMAX_RELTIM		_KERNEL_TMAX_UH

#elif _KERNEL_TBIT_RELTIM == 32		/* 32-bit */

typedef _KERNEL_T_UW			RELTIM;					/**< %jp{л(̵, ñ̤ϼ)}%en{Relative time(unsigned integer, unit of time is implementation-defined)} */
#define _KERNEL_TMIN_RELTIM		_KERNEL_TMIN_UW
#define _KERNEL_TMAX_RELTIM		_KERNEL_TMAX_UW

#elif _KERNEL_TBIT_RELTIM == 64		/* 8-bit */

typedef _KERNEL_T_UD			RELTIM;					/**< %jp{л(̵, ñ̤ϼ)}%en{Relative time(unsigned integer, unit of time is implementation-defined)} */
#define _KERNEL_TMIN_RELTIM		_KERNEL_TMIN_UD
#define _KERNEL_TMAX_RELTIM		_KERNEL_TMAX_UD

#else								/* error */

#error Illegal value : _KERNEL_TBIT_RELTIM

#endif



/* %jp{ƥ(̵, ñ̤ϼ)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
#if _KERNEL_SYSTIM_STRUCT

#if _KERNEL_TBIT_SYSTIM == 16		/* 16-bit */

/** %jp{ƥ(̵, ñ̤ϼ)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
typedef struct t_systim
{
	UH ltime;				/**< %jp{ 16bit}%en{lower 16bit} */
} SYSTIM;

#define _KERNEL_SYSTIM_ADD(t, n)	do { (t)->ltime += n; } while(0)

#elif _KERNEL_TBIT_SYSTIM == 32		/* 32-bit */

/** %jp{ƥ(̵, ñ̤ϼ)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
typedef struct t_systim
{
	UW ltime;				/**< %jp{ 32bit}%en{lower 32bit} */
} SYSTIM;

#define _KERNEL_SYSTIM_ADD(t, n)	do { (t)->ltime += n; } while(0)

#elif _KERNEL_CFG_TBIT_SYSTIM == 48	/* 48-bit */

/** %jp{ƥ(̵, ñ̤ϼ)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
typedef struct t_systim		
{
	UW ltime;				/**< %jp{ 32bit}%en{lower 32bit} */
	UH utime;				/**< %jp{ 16bit}%en{upper 16bit} */
} SYSTIM;


#define _KERNEL_SYSTIM_ADD(t, n)	do { if ( (t)->ltime + (n) < (t)->ltime ) { (t)->utime++; } (t)->ltime += (n); } while(0)

#elif _KERNEL_TBIT_SYSTIM == 64		/* 64-bit */

/** %jp{ƥ(̵, ñ̤ϼ)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
typedef struct t_systim
{
	UW ltime;				/**< %en{lower}%jp{ 32bit} */
	UW utime;				/**< %en{upper}%jp{ 32bit} */
} SYSTIM;

#define _KERNEL_SYSTIM_ADD(t, n)	do { if ( (t)->ltime + (n) < (t)->ltime ) { (t)->utime++; } (t)->ltime += (n); } while(0)

#elif _KERNEL_TBIT_SYSTIM == 96		/* 96-bit */

/** %jp{ƥ(̵, ñ̤ϼ)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
typedef struct t_systim
{
	UD ltime;				/**< %en{lower}%jp{ 64bit} */
	UW utime;				/**< %en{upper}%jp{ 32bit} */
} SYSTIM;

#define _KERNEL_SYSTIM_ADD(t, n)	do { if ( (t)->ltime + (n) < (t)->ltime ) { (t)->utime++; } (t)->ltime += (n); } while(0)

#elif _KERNEL_TBIT_SYSTIM == 128	/* 128-bit */

/** %jp{ƥ(̵, ñ̤ϼ)}%en{System time(unsigned integer, unit of time is implementation-defined)} */
typedef struct t_systim
{
	UD ltime;				/**< %en{lower}%jp{ 64bit} */
	UD utime;				/**< %en{upper}%jp{ 32bit} */
} SYSTIM;

#define _KERNEL_SYSTIM_ADD(t, n)	do { if ( (t)->ltime + (n) < (t)->ltime ) { (t)->utime++; } (t)->ltime += (n); } while(0)

#else

#error Illegal value : _KERNEL_TBIT_SYSTIM

#endif

#else

#if _KERNEL_CFG_TBIT_SYSTIM == _KERNEL_TBIT_PROC_UINT		/* default */

typedef _KERNEL_T_PROC_UINT		SYSTIM;					/**< %jp{ƥ(̵, ñ̤ϼ)}%en{System time(unsigned integer, unit of time is implementation-defined)} */

#elif _KERNEL_TBIT_SYSTIM == 16	/* 16-bit */

typedef _KERNEL_T_UH			SYSTIM;					/**< %jp{ƥ(̵, ñ̤ϼ)}%en{System time(unsigned integer, unit of time is implementation-defined)} */

#elif _KERNEL_TBIT_SYSTIM == 32	/* 32-bit */

typedef _KERNEL_T_UW			SYSTIM;					/**< %jp{ƥ(̵, ñ̤ϼ)}%en{System time(unsigned integer, unit of time is implementation-defined)} */

#elif _KERNEL_TBIT_SYSTIM == 64	/* 64-bit */

typedef _KERNEL_T_UD			SYSTIM;					/**< %jp{ƥ(̵, ñ̤ϼ)}%en{System time(unsigned integer, unit of time is implementation-defined)} */

#else							/* error */

#error Illegal value : _KERNEL_TBIT_SYSTIM

#endif

#define _KERNEL_SYSTIM_ADD(t, n)	do { *(t) += n; } while(0)

#endif



/* %jp{顼ɤޤϿ}%en{Error code or a boolean value} */
#if _KERNEL_TBIT_ER_BOOL == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		ER_BOOL;				/**< %jp{顼ɤޤϿ}%en{Error code or a boolean value} */
#define _KERNEL_TMIN_ER_BOOL	_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_ER_BOOL	_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_ER_BOOL == 8		/* 8-bit */

typedef _KERNEL_T_B				ER_BOOL;				/**< %jp{顼ɤޤϿ}%en{Error code or a boolean value} */
#define _KERNEL_TMIN_ER_BOOL	_KERNEL_TMIN_B
#define _KERNEL_TMAX_ER_BOOL	_KERNEL_TMAX_B

#elif _KERNEL_TBIT_ER_BOOL == 16	/* 16-bit */

typedef _KERNEL_T_H				ER_BOOL;				/**< %jp{顼ɤޤϿ}%en{Error code or a boolean value} */
#define _KERNEL_TMIN_ER_BOOL	_KERNEL_TMIN_H
#define _KERNEL_TMAX_ER_BOOL	_KERNEL_TMAX_H

#elif _KERNEL_TBIT_ER_BOOL == 32	/* 32-bit */

typedef _KERNEL_T_W				ER_BOOL;				/**< %jp{顼ɤޤϿ}%en{Error code or a boolean value} */
#define _KERNEL_TMIN_ER_BOOL	_KERNEL_TMIN_W
#define _KERNEL_TMAX_ER_BOOL	_KERNEL_TMAX_W

#elif _KERNEL_TBIT_ER_BOOL == 64	/* 8-bit */

typedef _KERNEL_T_D				ER_BOOL;				/**< %jp{顼ɤޤϿ}%en{Error code or a boolean value} */
#define _KERNEL_TMIN_ER_BOOL	_KERNEL_TMIN_D
#define _KERNEL_TMAX_ER_BOOL	_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_ER_BOOL

#endif



/* %jp{顼ɤޤIDֹ}%en{Error code or an object ID number} */
#if _KERNEL_TBIT_ER_ID == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		ER_ID;					/**< %jp{顼ɤޤIDֹ}%en{Error code or an object ID number} */
#define _KERNEL_TMIN_ER_ID		_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_ER_ID		_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_ER_ID == 8		/* 8-bit */

typedef _KERNEL_T_B				ER_ID;					/**< %jp{顼ɤޤIDֹ}%en{Error code or an object ID number} */
#define _KERNEL_TMIN_ER_ID		_KERNEL_TMIN_B
#define _KERNEL_TMAX_ER_ID		_KERNEL_TMAX_B

#elif _KERNEL_TBIT_ER_ID == 16		/* 16-bit */

typedef _KERNEL_T_H				ER_ID;					/**< %jp{顼ɤޤIDֹ}%en{Error code or an object ID number} */
#define _KERNEL_TMIN_ER_ID		_KERNEL_TMIN_H
#define _KERNEL_TMAX_ER_ID		_KERNEL_TMAX_H

#elif _KERNEL_TBIT_ER_ID == 32		/* 32-bit */

typedef _KERNEL_T_W				ER_ID;					/**< %jp{顼ɤޤIDֹ}%en{Error code or an object ID number} */
#define _KERNEL_TMIN_ER_ID		_KERNEL_TMIN_W
#define _KERNEL_TMAX_ER_ID		_KERNEL_TMAX_W

#elif _KERNEL_TBIT_ER_ID == 64		/* 8-bit */

typedef _KERNEL_T_D				ER_ID;					/**< %jp{顼ɤޤIDֹ}%en{Error code or an object ID number} */
#define _KERNEL_TMIN_ER_ID		_KERNEL_TMIN_D
#define _KERNEL_TMAX_ER_ID		_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_ER_ID

#endif



/* %jp{顼ɤޤ̵(̵ͭӥåȿUINT1ӥåû)}%en{Error code or an unsigned integer} */
#if _KERNEL_TBIT_ER_UINT == _KERNEL_TBIT_PROC_INT

typedef _KERNEL_T_PROC_INT		ER_UINT;				/**< %jp{顼ɤޤ̵(̵ͭӥåȿUINT1ӥåû)}%en{Error code or an unsigned integer} */
#define _KERNEL_TMIN_ER_UINT	_KERNEL_TMIN_PROC_INT
#define _KERNEL_TMAX_ER_UINT	_KERNEL_TMAX_PROC_INT

#elif _KERNEL_TBIT_ER_UINT == 8		/* 8-bit */

typedef _KERNEL_T_B				ER_UINT;				/**< %jp{顼ɤޤ̵(̵ͭӥåȿUINT1ӥåû)}%en{Error code or an unsigned integer} */
#define _KERNEL_TMIN_ER_UINT	_KERNEL_TMIN_B
#define _KERNEL_TMAX_ER_UINT	_KERNEL_TMAX_B

#elif _KERNEL_TBIT_ER_UINT == 16	/* 16-bit */

typedef _KERNEL_T_H				ER_UINT;				/**< %jp{顼ɤޤ̵(̵ͭӥåȿUINT1ӥåû)}%en{Error code or an unsigned integer} */
#define _KERNEL_TMIN_ER_UINT	_KERNEL_TMIN_H
#define _KERNEL_TMAX_ER_UINT	_KERNEL_TMAX_H

#elif _KERNEL_TBIT_ER_UINT == 32	/* 32-bit */

typedef _KERNEL_T_W				ER_UINT;				/**< %jp{顼ɤޤ̵(̵ͭӥåȿUINT1ӥåû)}%en{Error code or an unsigned integer} */
#define _KERNEL_TMIN_ER_UINT	_KERNEL_TMIN_W
#define _KERNEL_TMAX_ER_UINT	_KERNEL_TMAX_W

#elif _KERNEL_TBIT_ER_UINT == 64	/* 8-bit */

typedef _KERNEL_T_D				ER_UINT;				/**< %jp{顼ɤޤ̵(̵ͭӥåȿUINT1ӥåû)}%en{Error code or an unsigned integer} */
#define _KERNEL_TMIN_ER_UINT	_KERNEL_TMIN_D
#define _KERNEL_TMAX_ER_UINT	_KERNEL_TMAX_D

#else								/* error */

#error Illegal value : _KERNEL_TBIT_ER_UINT

#endif



/* ʲޤϿԤ̤б */

typedef UH						TEXPTN;		/**< %jp{㳰װΥѥ(̵)}%en{Bit pattern for the task exception code(unsigned integer)} */
typedef UH						FLGPTN;		/**< %jp{ե饰ѥ(̵)}%en{Bit pattern of eventflag(unsigned integer)} */

/** %jp{ե饰ѥ(̵)}%en{Message header for a mailbox} */
typedef struct t_msg
{
	struct t_msg	*pk_next;
} T_MSG;

typedef struct t_msg_pri
{
	T_MSG			msgque;
	PRI 			msgpri;
} T_MSG_PRI;


typedef UINT					RDVPTN;
typedef INT						RDVNO;
typedef INT						OVRTIM;

typedef INT						INHNO;		/**< %jp{ߥϥɥֹ}%en{} */
typedef INT						INTNO;		/**< %jp{ֹ}%en{} */

typedef INT						EXCNO;		/**< %jp{CPU㳰ϥɥֹ}%en{} */



/* ------------------------------------ */
/*         macro definition             */
/* ------------------------------------ */

/* %jp{顼ʬޥ} */
#define	ERCD(mercd, sercd)		(((mercd) & 0xff) | ((sercd) << 8))		/**< %jp{顼ɤᥤ󥨥顼ɤФ} */
#define	MERCD(ercd)				((ER)((B)(ercd)))						/**< %jp{顼ɤᥤ󥨥顼ɤФ} */
#define	SERCD(ercd)				((ercd) >> 8)							/**< %jp{顼ɤ饵֥顼ɤФ} */



#endif /* _KERNEL__itron_h__ */


/* end of file */

