/**
 *  Hyper Operating System V4 Advance
 *
 * @file  dtqobj.h
 * @brief %jp{ǡ塼ȤΥإåե}%en{Data queue object heder file}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef _KERNEL__object__dtqobj_h__
#define _KERNEL__object__dtqobj_h__



/* ------------------------------------------ */
/*  Primitive type definition                 */
/* ------------------------------------------ */

/* %jp{ǡ塼Ѥη} */
#if _KERNEL_DTQCB_BITFIELD		/* %jp{DTQCB˥ӥåȥեɤѤ} */

#if _KERNEL_OPT_SIGNED_INT && !_KERNEL_OPT_CB_SIZE	/* %jp{ͥξ1bit䤷դȤ} */
typedef signed int						_KERNEL_DTQ_T_DTQCNT;			/**< %jp{ǡ塼󥿤黻Ȥη} */
typedef signed int						_KERNEL_DTQCB_T_DTQCNT;			/**< %jp{ǡ塼󥿤DTQCB˳ǼȤη} */
#define _KERNEL_DTQCB_TBITDEF_DTQCNT	: (_KERNEL_DTQ_TBIT_DTQCNT+1)	/**< %jp{ǡ塼󥿤Υӥåȥե} */
#else
typedef unsigned int					_KERNEL_DTQ_T_DTQCNT;			/**< %jp{ǡ塼󥿤黻Ȥη} */
typedef unsigned int					_KERNEL_DTQCB_T_DTQCNT;			/**< %jp{ǡ塼󥿤DTQCB˳ǼȤη} */
#define _KERNEL_DTQCB_TBITDEF_DTQCNT	: _KERNEL_DTQ_TBIT_DTQCNT		/**< %jp{ǡ塼󥿤Υӥåȥե} */
#endif

#else							/* %jp{DTQCB˥ӥåȥեɤѤʤ} */

#if (_KERNEL_DTQ_TMAX_DTQCNT <= _KERNEL_TMAX_B) && _KERNEL_OPT_SIGNED_INT
typedef _KERNEL_T_FAST_B				_KERNEL_DTQ_T_DTQCNT;			/**< %jp{ǡ塼󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_B				_KERNEL_DTQCB_T_DTQCNT;			/**< %jp{ǡ塼󥿤DTQCB˳ǼȤη} */
#elif (_KERNEL_DTQ_TMAX_DTQCNT <= _KERNEL_TMAX_UB) && !(_KERNEL_OPT_SIGNED_INT && !_KERNEL_OPT_CB_SIZE)
typedef _KERNEL_T_FAST_UB				_KERNEL_DTQ_T_DTQCNT;			/**< %jp{ǡ塼󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_UB				_KERNEL_DTQCB_T_DTQCNT;			/**< %jp{ǡ塼󥿤DTQCB˳ǼȤη} */
#elif (_KERNEL_DTQ_TMAX_DTQCNT <= _KERNEL_TMAX_H) && _KERNEL_OPT_SIGNED_INT
typedef _KERNEL_T_FAST_H				_KERNEL_DTQ_T_DTQCNT;			/**< %jp{ǡ塼󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_H				_KERNEL_DTQCB_T_DTQCNT;			/**< %jp{ǡ塼󥿤DTQCB˳ǼȤη} */
#elif (_KERNEL_DTQ_TMAX_DTQCNT <= _KERNEL_TMAX_UH) && !(_KERNEL_OPT_SIGNED_INT && !_KERNEL_OPT_CB_SIZE)
typedef _KERNEL_T_FAST_UH				_KERNEL_DTQ_T_DTQCNT;			/**< %jp{ǡ塼󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_UH				_KERNEL_DTQCB_T_DTQCNT;			/**< %jp{ǡ塼󥿤DTQCB˳ǼȤη} */
#elif (_KERNEL_DTQ_TMAX_DTQCNT <= _KERNEL_TMAX_W) && _KERNEL_OPT_SIGNED_INT
typedef _KERNEL_T_FAST_W				_KERNEL_DTQ_T_DTQCNT;			/**< %jp{ǡ塼󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_W				_KERNEL_DTQCB_T_DTQCNT;			/**< %jp{ǡ塼󥿤DTQCB˳ǼȤη} */
#elif (_KERNEL_DTQ_TMAX_DTQCNT <= _KERNEL_TMAX_UW) && !(_KERNEL_OPT_SIGNED_INT && !_KERNEL_OPT_CB_SIZE)
typedef _KERNEL_T_FAST_UW				_KERNEL_DTQ_T_DTQCNT;			/**< %jp{ǡ塼󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_UW				_KERNEL_DTQCB_T_DTQCNT;			/**< %jp{ǡ塼󥿤DTQCB˳ǼȤη} */
#elif (_KERNEL_DTQ_TMAX_DTQCNT <= _KERNEL_TMAX_D) && _KERNEL_OPT_SIGNED_INT
typedef _KERNEL_T_FAST_D				_KERNEL_DTQ_T_DTQCNT;			/**< %jp{ǡ塼󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_D				_KERNEL_DTQCB_T_DTQCNT;			/**< %jp{ǡ塼󥿤DTQCB˳ǼȤη} */
#else
typedef _KERNEL_T_FAST_UD				_KERNEL_DTQ_T_DTQCNT;			/**< %jp{ǡ塼󥿤黻Ȥη} */
typedef _KERNEL_T_LEAST_UD				_KERNEL_DTQCB_T_DTQCNT;			/**< %jp{ǡ塼󥿤DTQCB˳ǼȤη} */
#endif
#define _KERNEL_DTQCB_TBITDEF_DTQCNT									/**< %jp{ǡ塼󥿤Υӥåȥե} */

#endif


/* %jp{ǡ塼°Ѥη} */
#if _KERNEL_DTQCB_BITFIELD		/* %jp{DTQCB˥ӥåȥեɤѤ} */

/* %jp{TA_TFIFO  TA_TPRI Ƚ 1bit ɬ} */
typedef unsigned int					_KERNEL_DTQ_T_DTQATR;
typedef unsigned int					_KERNEL_DTQCB_T_DTQATR;
#define _KERNEL_DTQCB_TBITDEF_DTQATR	: 1

#else							/* %jp{DTQCB˥ӥåȥեɤѤʤ} */

typedef _KERNEL_T_FAST_UB				_KERNEL_DTQ_T_DTQATR;
typedef _KERNEL_T_LEAST_UB				_KERNEL_DTQCB_T_DTQATR;
#define _KERNEL_DTQCB_TBITDEF_DTQATR

#endif


/* %jp{ǡ塼ΰƬѤη} */
typedef VP_INT*							_KERNEL_DTQ_T_DTQ;
typedef VP_INT*							_KERNEL_DTQCB_T_DTQ;
#define _KERNEL_DTQCB_TBITDEF_DTQ



/* ------------------------------------------ */
/*  Control block                             */
/* ------------------------------------------ */

#if _KERNEL_DTQCB_SPLIT_RO

/** %jp{ǡ塼ȥ֥å(꡼ɥ꡼)}%en{Data queue Control Block(read-only)} */
typedef struct _kernel_t_dtqcb_ro
{
#if _KERNEL_DTQCB_DTQATR
	_KERNEL_DTQCB_T_DTQATR	dtqatr		_KERNEL_DTQCB_TBITDEF_DTQATR;		/**< %jp{ǡ塼°}%en{Data queue attribute} */
#endif

#if _KERNEL_DTQCB_DTQCNT
	_KERNEL_DTQCB_T_DTQCNT	dtqcnt		_KERNEL_DTQCB_TBITDEF_DTQCNT;		/**< %jp{ǡ塼ΰ(ǡθĿ)}%en{Capacity of the data queue area(the number of data elements)} */
#endif

#if _KERNEL_DTQCB_DTQ
	_KERNEL_DTQCB_T_DTQ		dtq			_KERNEL_DTQCB_TBITDEF_DTQ;			/**< %jp{ǡ塼ΰƬ}%en{Start address of the data queue area} */
#endif
} _KERNEL_T_DTQCB_RO;

/** %jp{ǡ塼ȥ֥å}%en{Data queue Control Block} */
typedef struct _kernel_t_dtqcb
{
#if _KERNEL_DTQCB_SQUE
	_KERNEL_T_QUE			sque;											/**< %jp{ǡ塼Ԥ塼} */
#endif

#if _KERNEL_DTQCB_RQUE
	_KERNEL_T_QUE			rque;											/**< %jp{ǡ塼Ԥ塼} */
#endif

#if _KERNEL_DTQCB_SDTQCNT
	_KERNEL_DTQCB_T_DTQCNT	sdtqcnt		_KERNEL_DTQCB_TBITDEF_DTQCNT;		/**< %jp{ǡ塼äƤǡο}%en{The number of data elemnts int the data queue} */
#endif

#if _KERNEL_DTQCB_HEAD
	_KERNEL_DTQCB_T_DTQCNT	head		_KERNEL_DTQCB_TBITDEF_DTQCNT;		/**< %jp{ǡ塼ΥǡƬ} */
#endif


#if _KERNEL_DTQCB_ALGORITHM == _KERNEL_DTQCB_ALG_PTRARRAY
	const _KERNEL_T_SEMCB_RO	*dtqcb_ro;									/**< %jp{ǡ塼ȥ֥åROؤΥݥ} */
#endif
} _KERNEL_T_DTQCB;


#else


/** %jp{ǡ塼ȥ֥å}%en{Data queue Control Block} */
typedef struct _kernel_t_dtqcb
{
#if _KERNEL_DTQCB_SQUE
	_KERNEL_T_QUE			sque;											/**< %jp{ǡ塼Ԥ塼} */
#endif

#if _KERNEL_DTQCB_RQUE
	_KERNEL_T_QUE			rque;											/**< %jp{ǡ塼Ԥ塼} */
#endif

#if _KERNEL_DTQCB_SDTQCNT
	_KERNEL_DTQCB_T_DTQCNT	sdtqcnt		_KERNEL_DTQCB_TBITDEF_DTQCNT;		/**< %jp{ǡ塼äƤǡο}%en{The number of data elemnts int the data queue} */
#endif

#if _KERNEL_DTQCB_HEAD
	_KERNEL_DTQCB_T_DTQCNT	head		_KERNEL_DTQCB_TBITDEF_DTQCNT;		/**< %jp{ǡ塼ΥǡƬ} */
#endif


#if _KERNEL_DTQCB_DTQATR
	_KERNEL_DTQCB_T_DTQATR	dtqatr		_KERNEL_DTQCB_TBITDEF_DTQATR;		/**< %jp{ǡ塼°}%en{Data queue attribute} */
#endif

#if _KERNEL_DTQCB_DTQCNT
	_KERNEL_DTQCB_T_DTQCNT	dtqcnt		_KERNEL_DTQCB_TBITDEF_DTQCNT;		/**< %jp{ǡ塼ΰ(ǡθĿ)}%en{Capacity of the data queue area(the number of data elements)} */
#endif

#if _KERNEL_DTQCB_DTQ
	_KERNEL_DTQCB_T_DTQ		dtq			_KERNEL_DTQCB_TBITDEF_DTQ;			/**< %jp{ǡ塼ΰƬ}%en{Start address of the data queue area} */
#endif
} _KERNEL_T_DTQCB;

typedef _KERNEL_T_DTQCB		_KERNEL_T_DTQCB_RO;


#endif



/* ------------------------------------------ */
/*  ID range                                  */
/* ------------------------------------------ */

extern const ID							_kernel_max_dtqid;										/**< %jp{ǡ塼IDκ} */

#define _KERNEL_DTQ_TMIN_ID				1														/**< %jp{ǡ塼IDκǾ} */
#define _KERNEL_DTQ_TMAX_ID				(_kernel_max_dtqid)										/**< %jp{ǡ塼IDκ} */

#define _KERNEL_DTQ_CHECK_DTQID(dtqid)	((dtqid) >= _KERNEL_DTQ_TMIN_ID && (dtqid) <= _KERNEL_DTQ_TMAX_ID)
																								/**< %jp{IDϰϥå} */


/* ------------------------------------------ */
/*  Control block tables                      */
/* ------------------------------------------ */

#if _KERNEL_DTQCB_ALGORITHM == _KERNEL_DTQCB_ALG_BLKARRAY
#if _KERNEL_DTQCB_SPLIT_RO

/* %jp{֥åROʬΥξ}%en{block array} */
extern  _KERNEL_T_DTQCB					_kernel_dtqcb_tbl[];									/**< %jp{ǡ塼ȥ֥åơ֥} */
extern const _KERNEL_T_DTQCB_RO			_kernel_dtqcb_ro_tbl[];									/**< %jp{ǡ塼ȥ֥å(꡼ɥ꡼)ơ֥} */
#define _KERNEL_DTQ_ID2DTQCB(dtqid)		(&_kernel_dtqcb_tbl[(dtqid) - _KERNEL_DTQ_TMIN_ID])		/**< %jp{ȥ֥åμ} */
#define _KERNEL_DTQ_CHECK_EXS(dtqid)	(_kernel_dtqcb_ro_tbl[(dtqid) - _KERNEL_DTQ_TMIN_ID].dtq != NULL)
																								/**< %jp{֥Ȥ¸ߥå} */

#else

/* %jp{֥åξ}%en{block array} */
extern  _KERNEL_T_DTQCB					_kernel_dtqcb_tbl[];									/**< %jp{ǡ塼ȥ֥åơ֥} */
#define _KERNEL_DTQ_ID2DTQCB(dtqid)		(&_kernel_dtqcb_tbl[(dtqid) - _KERNEL_DTQ_TMIN_ID])		/**< %jp{ȥ֥åμ} */
#define _KERNEL_DTQ_CHECK_EXS(dtqid)	(_kernel_dtqcb_tbl[(dtqid) - _KERNEL_DTQ_TMIN_ID].dtq != NULL)
																								/**< %jp{֥Ȥ¸ߥå} */

#endif

#elif _KERNEL_DTQCB_ALGORITHM == _KERNEL_DTQCB_ALG_PTRARRAY

/* %jp{ݥξ}%en{pointer array} */
extern  _KERNEL_T_DTQCB					*_kernel_dtqcb_tbl[];									/**< %jp{ǡ塼ȥ֥åơ֥} */
#define _KERNEL_DTQ_ID2DTQCB(dtqid)		(_kernel_dtqcb_tbl[(dtqid) - _KERNEL_DTQ_TMIN_ID])		/**< %jp{ǡ塼IDDTQCB ɥ쥹} */
#define _KERNEL_DTQ_CHECK_EXS(dtqid)	(_KERNEL_DTQ_ID2DTQCB(dtqid) != NULL)					/**< %jp{֥Ȥ¸ߥå} */

#endif



/* ------------------------------------------ */
/*   Accessor for DTQCB                       */
/* ------------------------------------------ */

/* dtqcb_ro */
#if !_KERNEL_DTQCB_SPLIT_RO								
#define _KERNEL_DTQ_GET_DTQCB_RO(dtqid, dtqcb)	(dtqcb)
#else
#if _KERNEL_DTQCB_ALGORITHM == _KERNEL_DTQCB_ALG_BLKARRAY		/* %jp{DTQCBñǴ}%en{array of block} */
#define _KERNEL_DTQ_GET_DTQCB_RO(dtqid, dtqcb)	(&_kernel_dtqcb_ro_tbl[(dtqid)])
#elif _KERNEL_DTQCB_ALGORITHM == _KERNEL_DTQCB_ALG_PTRARRAY		/* %jp{DTQCBݥǴ}%en{array of pointer} */
#define _KERNEL_DTQ_GET_DTQCB_RO(dtqid, dtqcb)	((dtqcb)->dtqcb_ro)
#endif
#endif


/* sque */
#define _KERNEL_DTQ_GET_SQUE(dtqcb)			(&(dtqcb)->sque)


/* rque */
#define _KERNEL_DTQ_GET_RQUE(dtqcb)			(&(dtqcb)->rque)


/* sdtqcnt */
#if _KERNEL_DTQCB_SDTQCNT
#define _KERNEL_DTQ_SET_SDTQCNT(dtqcb, x)	do { (dtqcb)->sdtqcnt = (_KERNEL_DTQCB_T_DTQCNT)(x); } while (0)
#define _KERNEL_DTQ_GET_SDTQCNT(dtqcb)		((_KERNEL_DTQ_T_DTQCNT)(dtqcb)->sdtqcnt)
#else
#define _KERNEL_DTQ_SET_SDTQCNT(dtqcb, x)	do { } while (0)
#define _KERNEL_DTQ_GET_SDTQCNT(dtqcb)		(0)
#endif


/* head */
#if _KERNEL_DTQCB_HEAD
#define _KERNEL_DTQ_SET_HEAD(dtqcb, x)		do { (dtqcb)->head = (_KERNEL_DTQCB_T_DTQCNT)(x); } while (0)
#define _KERNEL_DTQ_GET_HEAD(dtqcb)			((_KERNEL_DTQ_T_DTQCNT)(dtqcb)->head)
#else
#define _KERNEL_DTQ_SET_HEAD(dtqcb, x)		do { } while (0)
#define _KERNEL_DTQ_GET_HEAD(dtqcb)			(0)
#endif


/* dtqatr */
#if _KERNEL_DTQCB_DTQATR
#define _KERNEL_DTQ_SET_DTQATR(dtqcb, x)	do { (dtqcb)->dtqatr = (_KERNEL_DTQCB_T_DTQATR)(x); } while (0)
#define _KERNEL_DTQ_GET_DTQATR(dtqcb)		((_KERNEL_DTQ_T_DTQATR)(dtqcb)->dtqatr)
#else
#define _KERNEL_DTQ_SET_DTQATR(dtqcb, x)	do { } while (0)
#if _KERNEL_SPT_DTQ_TA_TFIFO
#define _KERNEL_DTQ_GET_DTQATR(dtqcb)		(TA_TFIFO)
#else
#define _KERNEL_DTQ_GET_DTQATR(dtqcb)		(TA_TPRI)
#endif
#endif


/* dtqcnt */
#if _KERNEL_DTQCB_DTQCNT
#define _KERNEL_DTQ_SET_DTQCNT(dtqcb_ro, x)	do { (dtqcb_ro)->dtqcnt = (_KERNEL_DTQCB_T_DTQCNT)(x); } while (0)
#define _KERNEL_DTQ_GET_DTQCNT(dtqcb_ro)	((_KERNEL_DTQ_T_DTQCNT)(dtqcb_ro)->dtqcnt)
#else
#define _KERNEL_DTQ_SET_DTQCNT(dtqcb_ro, x)	do { } while (0)
#define _KERNEL_DTQ_GET_DTQCNT(dtqcb_ro)	(0)
#endif


/* dtq */
#if _KERNEL_DTQCB_DTQ
#define _KERNEL_DTQ_SET_DTQ(dtqcb_ro, x)	do { (dtqcb_ro)->dtq = (VP_INT *)(x); } while (0)
#define _KERNEL_DTQ_GET_DTQ(dtqcb_ro)		((VP_INT *)(dtqcb_ro)->dtq)
#else
#define _KERNEL_DTQ_SET_DTQ(dtqcb_ro, x)	do { } while (0)
#define _KERNEL_DTQ_GET_DTQ(dtqcb_ro)		(0)
#endif



/* ------------------------------------------ */
/*   Macro functions                          */
/* ------------------------------------------ */

/* %jp{塼³} */
#if _KERNEL_SPT_DTQ_TA_TFIFO && _KERNEL_SPT_DTQ_TA_TPRI		/* %jp{TA_TFIFO  TA_TPRI κ } */
#define _KERNEL_DTQ_ADD_SQUE(dtqcb, dtqcb_ro, tskhdl)	_KERNEL_ADD_QUE(_KERNEL_DTQ_GET_SQUE(dtqcb), tskhdl, _KERNEL_DTQ_GET_DTQATR(dtqcb_ro))
#define _KERNEL_DTQ_ADD_RQUE(dtqcb, dtqcb_ro, tskhdl)	_KERNEL_ADD_QUE(_KERNEL_DTQ_GET_RQUE(dtqcb), tskhdl, _KERNEL_DTQ_GET_DTQATR(dtqcb_ro))
#elif _KERNEL_SPT_DTQ_TA_TFIFO && !_KERNEL_SPT_SE_TA_TPRI	/* %jp{TA_TFIFO Τ } */
#define _KERNEL_DTQ_ADD_SQUE(dtqcb, dtqcb_ro, tskhdl)	_KERNEL_ADF_QUE(_KERNEL_DTQ_GET_SQUE(dtqcb), tskhdl)
#define _KERNEL_DTQ_ADD_RQUE(dtqcb, dtqcb_ro, tskhdl)	_KERNEL_ADF_QUE(_KERNEL_DTQ_GET_RQUE(dtqcb), tskhdl)
#elif !_KERNEL_SPT_DTQ_TA_TFIFO && _KERNEL_SPT_DTQ_TA_TPRI	/* %jp{TA_TPRI Τ } */
#define _KERNEL_DTQ_ADD_SQUE(dtqcb, dtqcb_ro, tskhdl)	_KERNEL_ADP_QUE(_KERNEL_DTQ_GET_SQUE(dtqcb), tskhdl)
#define _KERNEL_DTQ_ADD_RQUE(dtqcb, dtqcb_ro, tskhdl)	_KERNEL_ADP_QUE(_KERNEL_DTQ_GET_RQUE(dtqcb), tskhdl)
#else
#error error:_KERNEL_SPT_DTQ_TA_TPRI and _KERNEL_SPT_DTQ_TA_TFIFO
#endif

/* %jp{塼곰} */
#define _KERNEL_DTQ_RMV_SQUE(dtqcb, tskhdl)		_KERNEL_RMV_QUE(_KERNEL_DTQ_GET_SQUE(dtqcb), tskhdl)
#define _KERNEL_DTQ_RMV_RQUE(dtqcb, tskhdl)		_KERNEL_RMV_QUE(_KERNEL_DTQ_GET_RQUE(dtqcb), tskhdl)

/* %jp{塼ƬФ} */
#define _KERNEL_DTQ_RMH_SQUE(dtqcb)				_KERNEL_RMH_QUE(_KERNEL_DTQ_GET_SQUE(dtqcb))
#define _KERNEL_DTQ_RMH_RQUE(dtqcb)				_KERNEL_RMH_QUE(_KERNEL_DTQ_GET_RQUE(dtqcb))


/* %jp{ॢȥ塼} */
#if _KERNEL_SPT_TSND_DTQ	/* %jp{tsnd_dtqݡȻϥॢȥ塼θ} */
#define _KERNEL_DTQ_ADD_STOQ(tskhdl, tmout)		_KERNEL_SYS_ADD_TOQ(tskhdl, tmout)
#define _KERNEL_DTQ_RMV_STOQ(tskhdl)			_KERNEL_SYS_RMV_TOQ(tskhdl)
#else
#define _KERNEL_DTQ_ADD_STOQ(tskhdl)			do { } while (0)
#define _KERNEL_DTQ_RMV_STOQ(tskhdl)			do { } while (0)
#endif

#if _KERNEL_SPT_TRCV_DTQ	/* %jp{trcv_dtqݡȻϥॢȥ塼θ} */
#define _KERNEL_DTQ_ADD_RTOQ(tskhdl, tmout)		_KERNEL_SYS_ADD_TOQ(tskhdl, tmout)
#define _KERNEL_DTQ_RMV_RTOQ(tskhdl)			_KERNEL_SYS_RMV_TOQ(tskhdl)
#else
#define _KERNEL_DTQ_ADD_RTOQ(tskhdl)			do { } while (0)
#define _KERNEL_DTQ_RMV_RTOQ(tskhdl)			do { } while (0)
#endif



/* ------------------------------------------ */
/*   Functions                                */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

ER _kernel_cre_dtq(ID dtqid, const T_CDTQ *pk_cdtq);		/**< %jp{ǡ塼}%en{Create Data queue} */
ER _kernel_snd_dtq(ID dtqid, VP_INT data, TMO tmout);		/**< %jp{ǡ塼ؤ()}%en{Send Data Queue} */
ER _kernel_rcv_dtq(ID dtqid, VP_INT *p_data, TMO tmout);	/**< %jp{ǡ塼()}%en{Receive from Data Queue} */

#ifdef __cplusplus
}
#endif




#endif	/* _KERNEL__object__dtqobj_h__ */


/* end of file */
