/** 
 *  Hyper Operating System V4 Advance
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "arm_v4t.inc"


				.code	32
				.text
				.align	2

				.global	_kernel_ictxcb
				.global	_kernel_sta_inh
				.global	_kernel_end_inh
				.global	_kernel_exe_inh


/************************************************
  IRQ handler
 ************************************************/
				.global	_kernel_irq_hdr
_kernel_irq_hdr:
			/* ---- 쥸 */
				msr		cpsr_c, #(Mode_SYS | F_Bit | I_Bit)		/* SYS⡼ɤ˰ܹ */
				stmfd	sp!, {r0-r3, r12, lr}					/* SYS⡼ɤѥ쥸 */
				msr		cpsr_c, #(Mode_IRQ | F_Bit | I_Bit)		/* IRQ⡼ɤ˰ܹ */
				mov		r0, lr									/* lr_irq Ф */
				mrs		r1, spsr								/* spsr_irq Ф */
				msr		cpsr_c, #(Mode_SYS | F_Bit | I_Bit)		/* SYS⡼ɤ˰ܹ */
				stmfd	sp!, {r0, r1}							/* lr_irq, spsr_irq */
				
			/* ---- ߥޥ */
				ldr		r0, =_kernel_ictxcb
				ldr		r3, [r0, #ICTXCB_IMSK]					/* ŤimskͤФ */
				orr		r1, r3, #I_Bit							/* ߥޥ */
				strb	r1, [r0, #ICTXCB_IMSK]					/* cpsrͤimskͤ */
				
			/* ---- ¿ųȽ */
				ldrb	r1, [r0, #ICTXCB_INTCNT]				/* ߥͥȥͼ */
				add		r1, r1, #1								/* ߥͥȥ󥿥󥯥 */
				strb	r1, [r0, #ICTXCB_INTCNT]				/* ߥͥȥ */
				cmp		r1, #1
				bne		multiple_int							/* ¿ųߤʤʬ */
				
			/* ---- SPߥƥȤΤΤؤ */
				mov		r1, sp									/* SP¸ */
				ldr		sp, [r0, #ICTXCB_ISP]					/* ѥåڤؤ */
				stmfd	sp!, {r1, r3}							/* SPȵimask¸ */
				
			/* ---- ߳Ͻ */
				bl		_kernel_sta_inh							/* ߳ */
				
			/* ---- ߥϥɥ¹ */
				mov		r0, #INHNO_IRQ
				bl		_kernel_exe_inh
				
			/* ---- ߽νλ */
				ldmfd	sp!, {r1, r3}							/* ѥ쥸 */
				mov		sp, r1									/* SP򸵤ΥƥȤΤΤ᤹ */
				ldr		r0, =_kernel_ictxcb						/* ߥͥȥ󥿤Υɥ쥹 */
				mov		r1, #0									/* ߥͥȥ󥿤0᤹ */
				strb	r1, [r0, #ICTXCB_INTCNT]				/* ߥͥȥ */
			
			/* ---- ߥޥ */
				strb	r3, [r0, #ICTXCB_IMSK]					/* ޥ */
			
			/* ---- ߽λ */
				bl		_kernel_end_inh							/* ߽λ */
				
			/* ---- ߥޥ */
				ldr		r0, =_kernel_ictxcb
				ldr		r1, [sp, #4]							/* spsr_irq ͼФ */
				tst		r1, #I_Bit								/* ؤƱIRQ礬Τǥ */
				ldreqb	r0, [r0, #ICTXCB_IMSK]					/* λǤimskͼФ */
				biceq	r1, r1, #(F_Bit | I_Bit)
				orreq	r1, r1, r0
				streq	r1, [sp, #4]							/* spsr_irq imskȿ */
				
return_int:
			/* ----  */
				ldmfd	sp!, {r0, r1}							/* lr_irq, spsr_irq  */
				msr		cpsr_c, #(Mode_IRQ | F_Bit | I_Bit)		/* IRQ⡼ɤ˰ܹ */
				mov		lr, r0									/* lr_irq  */
				msr		spsr_csxf, r1 							/* spsr_irq  */
				msr		cpsr_c, #(Mode_SYS | F_Bit | I_Bit)		/* SYS⡼ɤ˰ܹ */
				ldmfd	sp!, {r0-r3, r12, lr}					/* SYS⡼ɤѥ쥸 */
				msr		cpsr_c, #(Mode_IRQ | F_Bit | I_Bit)		/* IRQ⡼ɤ˰ܹ */
				subs	pc, lr, #4								/*  */
				
				
			/* ---- ¿ų߽ */
multiple_int:
			/* ---- å8Хȥ饤Ȥ˰ư */
				mov		r1,  sp									/* ȯSYS⡼ɤSP8ܿݾڤʤΤ */
				bic		sp, sp, #0x7
				stmfd	sp!, {r0, r1}							/* SPѥå¸(8ܿˤʤ褦r1) */
				
			/* ---- ߥϥɥ¹ */
				mov		r0, #INHNO_IRQ
				bl		_kernel_exe_inh

			/* ---- å饤 */
				ldmfd	sp!, {r0, r1}							/* ѥ쥸 */
				mov		sp, r1
				
			/* ---- ߥ */
				ldrb	r1, [r0, #ICTXCB_INTCNT]
				add		r1, r1, #1
				strb	r1, [r0, #ICTXCB_INTCNT]
				b		return_int								/*  */


				.end


/* end of file */
