/* ------------------------------------------------------------------------ */
/* Hyper Operating System V4 Advance                                        */
/*                                                                          */
/*                                  Copyright (C) 1998-2006 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */

				.h8300h


				.global	__kernel_int_hdr
				.global	__kernel_ictxcb			/* ߥƥ */


				.text


/************************************************
  ߽

  ȯ er0  push 塢er0 
  ֹ򥻥åȤơ˥פ
************************************************/
__kernel_int_hdr:
		/* ---- 쥸¸ ---- */
				push.l	er1
				push.l	er2
				push.l	er3
				
		/* ---- ߤޥ ---- */
				stc.b	ccr, r1l						/* ccr¸ */
				orc		#0xc0, ccr						/* ޥ */
				and.b	#0xc0, r1l
				
		/* ---- ¿ųߤȽ ---- */
				mov.b	@(__kernel_ictxcb + 1), r1h		/* ߥͥȥ󥿼 */
				bne		multiple_int
				
		/* ======== ǽγ ======== */
		/* ---- ߥޥͤ ---- */
				mov.b	@(__kernel_ictxcb + 0), r0h		/* Ťߥޥͤ¸ */
				mov.b	r1l, @(__kernel_ictxcb + 0)		/* ޥͤ */
				
		/* ---- ߥͥȥ ---- */
				mov.b	#1, r1h
				mov.b	r1h, @(__kernel_ictxcb + 1)		/* ߥͥȥ */
				
		/* ---- åݥ󥿤ؤ ---- */
				mov.l	er7, er1
				mov.l	@(__kernel_ictxcb + 4), er7
				push.l	er1								/* ľΥåݥ󥿤¸ */
		
		/* ---- Ťߥޥ(r0h)ȳֹ(r0l)¸ ---- */
				push.w	r0

		/* ---- ߽γ ---- */
				jsr		@__kernel_sta_inh
				
		/* ---- ߥϥɥν ---- */
				mov.b	@(1, er7), r0l					/* åֹФ */
				extu.w	r0
				extu.l	er0
				jsr		@__kernel_exe_inh

		/* ---- Ťߥޥ(r0h)ȳֹ(r0l) ---- */
				pop.w	r0
				
		/* ---- åݥ ---- */
				mov.l	@er7, er7
				
		/* ---- ߥͥȥ󥿥ꥢ ---- */
				xor.b	r1l, r1l
				mov.b	r1l, @(__kernel_ictxcb + 1)
				
		/* ---- ߥޥͤ ---- */
				mov.b	@(16, er7), r1l
				and.b	#0xc0, r1l
				mov.b	r1l, @(__kernel_ictxcb + 0)		/* ᤹ͤ */
				cmp.b	r1l, r0h
				bne		return_int						/* ¿ųߤʤ򥫥å */
				
		/* ---- ƥȥå» ---- */
				jsr		@__kernel_end_inh
		
		/* ---- ƥȥåθ ---- */
				mov.b	@(__kernel_ictxcb + 0), r0l		/* ޥͼФ */
				mov.b	@(16, er7), r1l
				and.b	#0x3f, r1l
				or.b	r0l, r1l
				mov.b	r1l, @(16, er7)					/* åCCR򹹿 */

return_int:
		/* ----  ---- */
				pop.l	er3
				pop.l	er2
				pop.l	er1
				pop.l	er0
				rte


		/* ======== ¿ų ======== */
multiple_int:
		/* ---- ߥͥȥ󥿲û ---- */
				add.b	#1, r1h
				mov.b	r1h, @(__kernel_ictxcb + 1)

		/* ---- ߥޥͤ ---- */
				mov.b	r1l, @(__kernel_ictxcb + 0)		/* ޥͤ */
				
		/* ---- ߥϥɥƤӽФ ---- */
				jsr		@__kernel_exe_inh
				
		/* ---- ߥͥȥ󥿸 ---- */
				mov.b	@(__kernel_ictxcb + 1), r1h
				dec.b	r1h
				mov.b	r1h, @(__kernel_ictxcb + 1)
				
		/* ----  ---- */
				bra		return_int


				.end


/* end of file */
