/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  kcre_ctx.c
 * @brief %jp{ƥ}%en{context control}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <process.h>
#include "core/core.h"
#include "object/inhobj.h"


static unsigned __stdcall	_kernel_ctx_ent(void *param);		/**< %jp{ƥȤΥåɥȥ꡼ؿ} */
static unsigned __stdcall	_kernel_ctx_int(void *param);		/**< %jp{ƥȤγ߽å} */


/** %jp{¹ԥƥȤκ} */
void _kernel_cre_ctx(
		_KERNEL_T_CTXCB	*ctxcb,		/* ƥȤ륢ɥ쥹 */
		FP              entry,			/* ƥȤμ¹Գ */
		VP_INT          exinf1,			/* ƥȤμ¹Իѥ᡼1 */
		VP_INT          exinf2)			/* ƥȤμ¹Իѥ᡼2 */
{
	ctxcb->blInterrupt = FALSE;

	/* %jp{ưǼ} */
	ctxcb->entry  = entry;
	ctxcb->exinf1 = exinf1;
	ctxcb->exinf2 = exinf2;
	
	/* %jp{ƥȥå} */
	ctxcb->hEvent     = CreateEvent(NULL, FALSE, FALSE, NULL);
	ctxcb->hIntEvent  = CreateEvent(NULL, FALSE, FALSE, NULL);

#if defined(_MSC_VER)	/* Visual-C++ ξ */
	ctxcb->hThread    = (HANDLE)_beginthreadex(NULL, 0, _kernel_ctx_ent, (void *)ctxcb, 0, &ctxcb->dwThreadId);
	ctxcb->hIntThread = (HANDLE)_beginthreadex(NULL, 0, _kernel_ctx_int, (void *)ctxcb, 0, &ctxcb->dwIntThreadId);
#else					/* Visual-C++ ʳ */
	ctxcb->hThread    = CreateThread(NULL, 0, _kernel_ctx_ent, (LPVOID)ctxcb, 0, &ctxcb->dwThreadId);
	ctxcb->hIntThread = CreateThread(NULL, 0, _kernel_ctx_int, (LPVOID)ctxcb, 0, &ctxcb->dwIntThreadId);
#endif
}


/** %jp{ƥȤΥåɥȥ꡼ؿ} */
unsigned __stdcall _kernel_ctx_ent(void *param)
{
	_KERNEL_T_CTXCB *ctxcb;

	/* %jp{ƥȾ} */
	ctxcb = (_KERNEL_T_CTXCB *)param;

	/* %jp{Ԥ} */
	WaitForSingleObject(ctxcb->hEvent, INFINITE);

	/* %jp{ꥹsetjmp} */
	setjmp(ctxcb->jmpenv);

	/*  */
	ctxcb->entry(ctxcb->exinf1, ctxcb->exinf2);
	
	return 0;
}


/** %jp{ߥϥɥ} */
unsigned __stdcall _kernel_ctx_int(void *param)
{
	_KERNEL_T_CTXCB *ctxcb;

	/* %jp{ƥȾ} */
	ctxcb = (_KERNEL_T_CTXCB *)param;

	for ( ; ; )
	{
		/* %jp{Ԥ} */
		WaitForSingleObject(ctxcb->hIntEvent, INFINITE);

		_kernel_ictxcb.blDisInt = TRUE;

		/* %jp{߽} */
		_kernel_sta_inh();
		_kernel_ictxcb.blIntCtx = TRUE;
		_kernel_exe_inh(_kernel_ictxcb.inhno);
		_kernel_ictxcb.blIntCtx = FALSE;
		_kernel_end_inh();
		
		/* ƥ */
		ctxcb->blInterrupt      = FALSE;
		_kernel_ictxcb.blDisInt = FALSE;
		ResumeThread(ctxcb->hThread);							/* %jp{å} */
		ReleaseSemaphore(_kernel_ictxcb.hSemIntLock, 1, NULL);	/* %jp{ߥå} */
	}
	
	return 0;
}



/* end of file */
