/**
 *  Hyper Operating System V4 Advance
 *
 * @file  dpc.h
 * @brief %jp{ٱץ㡼إåե}%en{Deferred Procedure Call header file}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "core/dpc.h"


#if _KERNEL_SPT_DPC


/* %jp{ӥлν} */
void _kernel_exe_dpc(_KERNEL_T_DPCCB *dcpcb)
{
	volatile _KERNEL_T_DPCMSG	*msg;
	UINT						head;
	
	for ( ; ; )
	{
		/* %jp{塼å} */
		head = dcpcb->head;
		_KERNEL_SYS_LOC_DPC();
		if ( head == dcpcb->tail )
		{
			_KERNEL_SYS_CLR_SVC();
			_KERNEL_SYS_UNL_DPC();
			return;					/* %jp{塼}%en{empty} */
		}
		_KERNEL_SYS_UNL_DPC();
		
		do
		{
			/* %jp{åФ} */
			msg = &dcpcb->que[head];

			/* %jp{ٱץƤӽФ} */
			msg->svc(msg->id, msg->param);

			/* %jp{ݥ󥿤ʤ} */
			head = head + 1;
			if ( head >= dcpcb->quecnt )
			{
				head = 0;
			}
			dcpcb->head = head;
		} while ( head != dcpcb->tail );
		
		_KERNEL_DSP_TSK();			/* %jp{ǥѥåμ¹} */
	}
}


#endif	/* _KERNEL_SPT_DPC */


/* end of file */
