/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  dsp_sus.c
 * @brief %jp{򥵥ڥɤ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"


/** %jp{򥵥ڥɤ} */
void _kernel_dsp_sus_tsk(_KERNEL_T_TSKHDL tskhdl)
{
	_KERNEL_T_TCB_PTR     tcb;
	_KERNEL_TSK_T_TSKSTAT tskstat;

	/* %jp{TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{ߤξ֤} */
	tskstat = _KERNEL_TSK_GET_TSKSTAT(tcb);
	
	/* %jp{ߤξ֤} */
	if ( !(tskstat & _KERNEL_TTS_WAI) )
	{
#if _KERNEL_RUNTSK_ON_RDQ
		/* %jp{ǥ塼곰} */
		_KERNEL_SYS_RMV_RDQ(tskhdl);
#else
		if ( tskhdl != _KERNEL_SYS_GET_RUNTSK() )
		{
			_KERNEL_SYS_RMV_RDQ(tskhdl);
		}
#endif
	}

	/* %jp{Ԥ֤} */
	tskstat |= _KERNEL_TTS_SUS;
	_KERNEL_TSK_SET_TSKSTAT(tcb, tskstat);
}



/* end of file */
