/**
 *  Hyper Operating System V4 Advance
 *
 * @file  add_tmq.c
 * @brief %jp{ޥ塼˥֥Ȥɲ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "core/tmq.h"



/* ޥ֥ȤꥹȤɲ */
void _kernel_add_tmq(
		_KERNEL_T_TMQCB  *tmqcb,
		_KERNEL_T_TIMOBJ *pk_timobj)
{
	/* ϿƤ鲿⤷ʤ */
	if ( pk_timobj->next != NULL )
	{
		return;
	}
	
	/* ΥƥåޤǤλ֤ûƤ */
	pk_timobj->lefttim += _KERNEL_SYS_GET_TIC();
	
	/* ꥹȤϿ */
	if ( tmqcb->head == NULL )
	{
		/* ꥹȤξɲ */
		pk_timobj->next = pk_timobj;
		pk_timobj->prev = pk_timobj;
		tmqcb->head     = pk_timobj;
	}
	else
	{
		/* ꥹȤɲ */
		pk_timobj->next       = tmqcb->head;
		pk_timobj->prev       = tmqcb->head->prev;
		pk_timobj->next->prev = pk_timobj;
		pk_timobj->prev->next = pk_timobj;
	}
}



/* end of file */
