/**
 *  Hyper Operating System V4 Advance
 *
 * @file  add_tmq.c
 * @brief %jp{ޥ塼˥֥Ȥɲ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "core/tmq.h"



/* ޥ֥Ȥλ֤ʤ */
void _kernel_sig_tmq(
		_KERNEL_T_TMQCB *tmqcb,
		RELTIM          tictim)
{
	_KERNEL_T_TIMOBJ *timobj;
	
	/* ޥ֥ȤΥϥɥƤӽФ */
	if ( tmqcb->head != NULL )
	{
		/* ݥ */
		tmqcb->next = tmqcb->head;
		
		do /* ꥹޤǷ֤ */
		{
			timobj      = tmqcb->next;
			tmqcb->busy = timobj->next;		/* %jp{楪֥} */
			tmqcb->next = timobj->next;		/* %jp{Υݥ󥿤} */
			
			if ( timobj->lefttim > tictim )
			{
				/* %jp{Ļָ} */
				timobj->lefttim -= tictim;
			}
			else
			{
				/* %jp{ޥϥɥƤӽФ} */
				timobj->timhdr(timobj, tictim - timobj->lefttim);
				if ( tmqcb->next == NULL )
				{
					break;
				}
			}
		} while ( tmqcb->next != tmqcb->head );
		
		/* ݥ󥿤Υꥢ */
		tmqcb->next = NULL;
		tmqcb->busy = NULL;
	}
}


/* end of file */
