/**
 *  Hyper Operating System V4 Advance
 *
 * @file  add_toq.c
 * @brief %jp{򥿥ॢȥ塼ɲ}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"


#if _KERNEL_SPT_TOQ

/** %jp{ॢԤ˥ɲ} */
void _kernel_add_toq(
		_KERNEL_T_TOQCB  *toqcb,
		_KERNEL_T_TSKHDL tskhdl,
		RELTIM           tmout)
{
	_KERNEL_T_TSKHDL tskhdl_head;
	_KERNEL_T_TSKHDL tskhdl_next;
	_KERNEL_T_TSKHDL tskhdl_prev;
	_KERNEL_T_TCB    *tcb;
	_KERNEL_T_TCB    *tcb_next;
	_KERNEL_T_TCB    *tcb_prev;
	RELTIM           tmout_next;

	/* %jp{TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{ॢȥ塼Ƭ} */
	tskhdl_head = _KERNEL_TOQ_GET_HEAD(toqcb);
	
	if ( tskhdl_head == _KERNEL_TSKHDL_NULL )
	{
		/* %jp{ǽΣĤ򥭥塼Ͽ} */
		_KERNEL_TSK_SET_TOQNEXT(tcb, tskhdl);
		_KERNEL_TSK_SET_TOQPREV(tcb, tskhdl);
		_KERNEL_TOQ_SET_HEAD(toqcb, tskhdl);

		/* %jp{ॢȻ} */
		_KERNEL_TSK_SET_TOQDIFTIM(tcb, tmout);

		return;
	}
	
	/* %jp{򸡺} */
	tskhdl_next = tskhdl_head;
	tcb_next    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_next);
	tskhdl_prev = _KERNEL_TSK_GET_TOQPREV(tcb_next);
	tcb_prev    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_prev);
	do
	{
		tmout_next = _KERNEL_TSK_GET_TOQDIFTIM(tcb_next);
		
		/* %jp{} */
		if ( tmout < tmout_next )
		{
			/* %jp{Ƭʤ} */
			if ( tskhdl_next == tskhdl_head )
			{
				_KERNEL_TOQ_SET_HEAD(toqcb, tskhdl);	/* %jp{Ƭݥ󥿹} */
			}
			
			/* %jp{֤κʬ} */
			_KERNEL_TSK_SET_TOQDIFTIM(tcb_next, tmout_next - tmout);
			_KERNEL_TSK_SET_TOQDIFTIM(tcb, tmout);

			/* %jp{ꥹȤ} */
			_KERNEL_TSK_SET_TOQNEXT(tcb, tskhdl_next);
			_KERNEL_TSK_SET_TOQPREV(tcb, tskhdl_prev);
			_KERNEL_TSK_SET_TOQNEXT(tcb_prev, tskhdl);
			_KERNEL_TSK_SET_TOQPREV(tcb_next, tskhdl);
			
			return;
		}
		
		tmout -= tmout_next;		/* %jp{ʬ򸺻} */
		
		tskhdl_prev = tskhdl_next;
		tcb_prev    = tcb_next;
		tskhdl_next = _KERNEL_TSK_GET_TOQNEXT(tcb_next);		/* %jp{Υؿʤ} */
		tcb_next    = _KERNEL_TSK_TSKHDL2TCB(tskhdl_next);
	} while ( tskhdl_next != tskhdl_head );	/* %jp{ꥹȤޤǥ롼} */

	/* Ĥäʬ */
	_KERNEL_TSK_SET_TOQDIFTIM(tcb, tmout);

	/* %jp{ɲ} */
	_KERNEL_TSK_SET_TOQNEXT(tcb, tskhdl_next);
	_KERNEL_TSK_SET_TOQPREV(tcb, tskhdl_prev);
	_KERNEL_TSK_SET_TOQNEXT(tcb_prev, tskhdl);
	_KERNEL_TSK_SET_TOQPREV(tcb_next, tskhdl);
}

#endif	/* _KERNEL_SPT_TOQ */


/* end of file */
