/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  cre_cyc.c
 * @brief %jp{ϥɥ(IDֹ漫ưդ)}%en{Create cyclic handler(ID Number Automatic Assignment)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/cycobj.h"



#if _KERNEL_SPT_CRE_CYC

/** %jp{ϥɥ(IDֹ漫ưդ)}%en{Create cyclic handler(ID Number Automatic Assignment)}
 * @param  cycid		%jp{оݤμϥɥIDֹ}%en{ID number of the cyclic handler to be created}
 * @param  pk_ccyc	    %jp{ϥɥ줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the cyclic handler creation information}
 * @retval %jp{}%en{positiv-value} %jp{ϥɥIDֹ}%en{ID number of the created cyclic handler}
 * @retval E_NOID  %jp{IDֹ­(ղǽʼϥɥID̵)}%en{No ID number available(there id no cyclic handler ID assignable)}
 * @retval E_RSATR %jp{ͽ°(cycatr뤤ϻѤǤʤ)}%en{Reserved attribute(cycatr is invalid or unusable)}
 */
ID cre_cyc(ID cycid, const T_CCYC *pk_ccyc)
{
	ER_ID erid;
	
	/* %jp{IDå}%en{check ID} */
#if _KERNEL_SPT_CRE_CYC_E_ID
	if ( !_KERNEL_CYC_CHECK_CYCID(cycid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}	
#endif
	
	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{¸ߥå}%en{check object} */
#if _KERNEL_SPT_CRE_CYC_E_OBJ
	if ( _KERNEL_CYC_CHECK_EXS(cycid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_OBJ;			/* %jp{֥Ⱦ֥顼}%en{Object state error} */
	}
#endif
	
	/* %jp{֥} */
#if (_KERNEL_CYCCB_ALGORITHM == _KERNEL_CYCCB_ALG_PTRARRAY) && _KERNEL_SPT_ACRE_CYC_E_NOMEM
	erid = (ER_ID)_kernel_cre_cyc(cycid, pk_ccyc);
	if ( erid == E_OK )
	{
		erid = (ER_ID)cycid;	/* %jp{顼ǤʤмϥɥIDǼ} */
	}
#else
	_kernel_cre_cyc(cycid, pk_ccyc);
	erid = (ER_ID)cycid;		/* %jp{ϥɥIDǼ} */
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return erid;
}


#else	/* _KERNEL_SPT_ACRE_CYC */


#if _KERNEL_SPT_ACRE_CYC_E_NOSPT


/** %jp{ϥɥ(IDֹ漫ưդ)}%en{Create cyclic handler(ID Number Automatic Assignment)}
 * @param  pk_ccyc  %jp{ϥɥ줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the cyclic handler creation information}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ID cre_cyc(ID cycid, const T_CCYC *pk_ccyc)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_ACRE_CYC */



/* end of file */
