/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  del_que.c
 * @brief %jp{ǡ塼κ}%en{Delete Data queue}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/dtqobj.h"



#if _KERNEL_SPT_DEL_DTQ


/** %jp{ޥեκ}%en{Delete Data queue}
 * @param  dtqid    %jp{оݤΥޥեIDֹ}%en{ID number of the data queue to be deleted}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(dtqid뤤ϻѤǤʤ)}%en{Invalid ID number(dtqid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥޥե̤Ͽ)}%en{Non-existant object(specified data queue is not registerd)}
 */
ER del_dtq(ID dtqid)
{
	_KERNEL_T_DTQCB		*dtqcb;
	_KERNEL_T_QUE		*que;
	_KERNEL_T_TSKHDL	tskhdl;
	_KERNEL_T_TCB		*tcb;
	
	/* %jp{IDå}%en{check ID} */
#if _KERNEL_SPT_DEL_DTQ_E_ID
	if ( !_KERNEL_DTQ_CHECK_DTQID(dtqid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}	
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{¸ߥå}%en{check object} */
#if _KERNEL_SPT_DEL_DTQ_E_NOEXS
	if ( !_KERNEL_DTQ_CHECK_EXS(dtqid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOEXS;
	}
#endif
	
	/* %jp{ޥեȥ֥å} */
	dtqcb = _KERNEL_DTQ_ID2DTQCB(dtqid);
	
	/* %jp{ԤΥƵ} */
	que = _KERNEL_DTQ_GET_SQUE(dtqcb);
	while ( (tskhdl = _KERNEL_RMH_QUE(que)) != _KERNEL_TSKHDL_NULL )
	{
		/* %jp{ԤԤ} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);		/* %jp{TCB} */
		_KERNEL_TSK_SET_ERCD(tcb, E_DLT);			/* %jp{顼} */
		_KERNEL_DTQ_RMV_STOQ(tskhdl);				/* %jp{ॢȥ塼鳰} */
		_KERNEL_DSP_WUP_TSK(tskhdl);				/* %jp{Ԥ} */	
	}
	
	/* %jp{ԤΥƵ} */
	que = _KERNEL_DTQ_GET_RQUE(dtqcb);
	while ( (tskhdl = _KERNEL_RMH_QUE(que)) != _KERNEL_TSKHDL_NULL )
	{
		/* %jp{ԤԤ} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);		/* %jp{TCB} */
		_KERNEL_TSK_SET_ERCD(tcb, E_DLT);			/* %jp{顼} */
		_KERNEL_DTQ_RMV_RTOQ(tskhdl);				/* %jp{ॢȥ塼鳰} */
		_KERNEL_DSP_WUP_TSK(tskhdl);				/* %jp{Ԥ} */	
	}
	
	/* %jp{֥Ⱥ} */
#if _KERNEL_DTQCB_ALGORITHM == _KERNEL_DTQCB_ALG_PTRARRAY
	_KERNEL_SYS_FRE_HEP(dtqcb);						/* %jp{곫} */
	_KERNEL_DTQ_ID2DTQCB(dtqid) = NULL;
#elif _KERNEL_DTQCB_ALGORITHM == _KERNEL_DTQCB_ALG_BLKARRAY
	_KERNEL_DTQ_SET_MAXDTQ(dtqcb, 0);
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return E_OK;
}


#else	/* _KERNEL_SPT_DEL_DTQ */


#if _KERNEL_SPT_DEL_DTQ_E_NOSPT

/** %jp{ޥեκ}%en{Delete Data queue}
 * @param  dtqid    %jp{оݤΥޥեIDֹ}%en{ID number of the data queue to be deleted}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER del_dtq(ID dtqid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_DEL_DTQ */



/* end of file */
