/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  pol_flg.c
 * @brief %jp{٥ȥե饰Ԥ(ݡ)}%en{Wait for Eventflag(Polling)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/flgobj.h"



#if _KERNEL_SPT_POL_FLG


#if _KERNEL_SPT_TWAI_FLG && (_KERNEL_OPT_CODE_SIZE <= _KERNEL_OPT_SPEED)	/* %jp{twai_flgǡɥͥʤ} */

/** %jp{٥ȥե饰Ԥ(ݡ)}%en{Wait for Eventflag(Polling)}
 * @param  flgid    %jp{ԤоݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{Ԥӥåȥѥ}%en{Wait bit pattern}
 * @param  wfmode   %jp{Ԥ⡼}%en{Wait mode}
 * @param  p_flgptn %jp{ԤΥӥåȥѥֵѥɥ쥹}%en{Bit pattern causing a task to be released from waiting}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(flgid뤤ϻѤǤʤ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥ٥ȥե饰̤Ͽ)}%en{Non-existant object(specified eventflag is not registerd)}
 * @retval E_PAR    %jp{ѥ᡼顼(waiptn, wfmode, p_flgptn)}%en{Parameter error(waiptn, wfmode, or p_flgptn is invalid)}
 * @retval E_TMOUT  %jp{ݡ󥰼}%en{Polling failure}
 * @retval E_DLT    %jp{Ԥ֥Ȥκ(Ԥ֤δ֤оݥ٥ȥե饰)}%en{Waiting object deleted(eventflag is deleted waiting)}
 */
ER pol_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn)
{
	/* %jp{twai_flg Ѥɥ︺} */
	return twai_flg(flgid, waiptn, wfmode, p_flgptn, TMO_POL);
}

#else

/** %jp{٥ȥե饰Ԥ}%en{Wait for Eventflag}
 * @param  flgid    %jp{ԤоݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{Ԥӥåȥѥ}%en{Wait bit pattern}
 * @param  wfmode   %jp{Ԥ⡼}%en{Wait mode}
 * @param  p_flgptn %jp{ԤΥӥåȥѥֵѥɥ쥹}%en{Bit pattern causing a task to be released from waiting}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(flgid뤤ϻѤǤʤ)}%en{Invalid ID number(flgid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥ٥ȥե饰̤Ͽ)}%en{Non-existant object(specified eventflag is not registerd)}
 * @retval E_PAR    %jp{ѥ᡼顼(waiptn, wfmode, p_flgptn)}%en{Parameter error(waiptn, wfmode, or p_flgptn is invalid)}
 * @retval E_TMOUT  %jp{ݡ󥰼}%en{Polling failure}
 * @retval E_DLT    %jp{Ԥ֥Ȥκ(Ԥ֤δ֤оݥ٥ȥե饰)}%en{Waiting object deleted(eventflag is deleted waiting)}
 */
ER pol_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn)
{
	_KERNEL_T_FLGCB          *flgcb;
	_KERNEL_T_FLGINF         flginf;
	ER                       ercd;

	/* %jp{ID Υå} */
#if _KERNEL_SPT_POL_FLG_E_ID
	if ( !_KERNEL_FLG_CHECK_FLGID(flgid) )
	{
		return E_ID;	/* %jp{ID} */
	}
#endif
	
	_KERNEL_ENTER_SVC();		/* %jp{ӥ볫} */
	
	/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_POL_FLG_E_NOEXS
	if ( !_KERNEL_FLG_CHECK_EXS(flgid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */
		return E_NOEXS;			/* %jp{֥̤} */
	}
#endif
	
	
	/* %jp{ȥ֥å} */
	flgcb = _KERNEL_FLG_ID2FLGCB(flgid);
	
	/* %jp{Ԥ} */
	flginf.waiptn = waiptn;
	flginf.wfmode = wfmode;
	
	/* %jp{ե饰å} */
	if ( _kernel_chk_flg(flgcb, &flginf) )
	{
		/* %jp{˾Ƥʤ} */
		*p_flgptn = _KERNEL_FLG_GET_FLGPTN(flgcb);			/* %jp{Υե饰ѥǼ} */

#if _KERNEL_SPT_FLG_TA_CLR
		if ( _KERNEL_FLG_GET_FLGATR(_KERNEL_FLG_GET_FLGCB_RO(flgid, flgcb)) & TA_CLR )
		{
			_KERNEL_FLG_SET_FLGPTN(flgcb, 0);		/* %jp{ꥢ°Хꥢ} */
		}
#endif
		
		ercd = E_OK;
	}
	else
	{
		ercd = E_TMOUT;
	}
		
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */
	
	return ercd;	/*  */
}

#endif


#else	/* _KERNEL_SPT_POL_FLG */


#if _KERNEL_SPT_POL_FLG_E_NOSPT

/** %jp{٥ȥե饰Ԥ}%en{Wait for Eventflag}
 * @param  flgid    %jp{ԤоݤΥ٥ȥե饰IDֹ}%en{ID number of the eventflag to be set}
 * @param  flgptn   %jp{Ԥӥåȥѥ}%en{Wait bit pattern}
 * @param  wfmode   %jp{Ԥ⡼}%en{Wait mode}
 * @param  p_flgptn %jp{ԤΥӥåȥѥֵѥɥ쥹}%en{Bit pattern causing a task to be released from waiting}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER pol_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn)
{
	return E_NOSPT;
}

#endif

#endif	/* _KERNEL_SPT_POL_FLG */


/* end of file */
