/**
 *  Hyper Operating System V4 Advance
 *
 * @file  sta_inte.c
 * @brief %jp{߽}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/inhobj.h"


#if _KERNEL_SPT_DPC


/** %jp{߽}
 * @return void
 */
void _kernel_end_inh(void)
{
	/* %jp{ߥƥȤȴ} */
	_KERNEL_SYS_CLR_CTX();
	
	/* %jp{ӥʤ鲿⤷ʤ} */
	if ( _KERNEL_SYS_SNS_SVC() )
	{
		return;
	}
	
	/* %jp{ƥȤDPC} */
	_KERNEL_ENA_INT();			/* %jp{ߵ} */

	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
		
	_KERNEL_DIS_INT();			/* %jp{߶ػ} */
}


#else


/** %jp{߽}
 * @return void
 */
void _kernel_end_inh(void)
{
	/* %jp{ߥƥȤȴ} */
	_KERNEL_SYS_CLR_CTX();
	
	/* %jp{ٱ䤷Ƥǥѥåм»} */
	if ( _KERNEL_SYS_SNS_DLY() )
	{
		_KERNEL_DSP_TSK();
	}
}

#endif


/* end of file */
