/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_sem.c
 * @brief %en{Activate Task}%jp{εư}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/isrobj.h"




ER _kernel_cre_isr(ID isrid, const T_CISR *pk_cisr)
{
	_KERNEL_T_ISRCB    *isrcb;
	_KERNEL_T_ISRCB_RO *isrcb_ro;
	
	if ( pk_cisr->intno < _KERNEL_INT_TMIN_INTNO || pk_cisr->intno > _KERNEL_INT_TMAX_INTNO )
	{
		return E_PAR;
	}

	/* %jp{}%en{get memory} */
#if _KERNEL_ISRCB_ALGORITHM == _KERNEL_ISRCB_ALG_BLKARRAY
	{
		isrcb    = _KERNEL_ISR_ID2ISRCB(isrid);
		isrcb_ro = isrcb;
	}
#elif _KERNEL_ISRCB_ALGORITHM == _KERNEL_ISRCB_ALG_PTRARRAY
#if _KERNEL_ISRCB_SPLIT_RO
	{
		/* %jp{ISRCBΰ褬ݥ󥿴ǡROM/RAMʬΥξ} */
		VP   mem;
		SIZE memsz;

		/* %jp{ꥵ} */
		memsz = _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_ISRCB))
					+ _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_ISRCB_RO));

		/* %jp{} */
		mem = _KERNEL_SYS_ALC_HEP(memsz);

		/* %jp{­å} */
#if _KERNEL_SPT_KCRE_ISR_E_NOMEM
		if ( mem == NULL )
		{
			return E_NOMEM;
		}
#endif
		
		/* %jp{} */
		isrcb    = (_KERNEL_T_ISRCB *)mem;
		isrcb_ro = (_KERNEL_T_ISRCB_RO *)((VB *)mem + _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_ISRCB)));
		_KERNEL_ISR_ID2ISRCB(isrid)           = isrcb;
		_KERNEL_ISR_ID2ISRCB(isrid)->isrcb_ro = (const _KERNEL_T_ISRCB_RO *)isrcb_ro;
	}
#else
	{
		VP   mem;
		
		/* %jp{} */
		mem = _KERNEL_SYS_ALC_HEP(sizeof(_KERNEL_T_ISRCB));

		/* %jp{­å} */
#if _KERNEL_SPT_KCRE_ISR_E_NOMEM
		if ( mem == NULL )
		{
			return E_NOMEM;
		}
#endif

		/* %jp{} */
		isrcb    = (_KERNEL_T_ISRCB *)mem;
		isrcb_ro = (_KERNEL_T_ISRCB_RO *)mem;
		_KERNEL_ISR_ID2ISRCB(isrid) = isrcb;
	}
#endif
#endif

	/* %jp{н} */
	_KERNEL_ISR_SET_EXINF(isrcb_ro, pk_cisr->exinf);
	_KERNEL_ISR_SET_ISR(isrcb_ro, pk_cisr->isr);


#if _KERNEL_SPT_DPC
	_KERNEL_DIS_INT();										/* %jp{߶ػ} */
#endif

	/* %jp{ߥꥹȤƬ˷Ҥ} */
	_KERNEL_ISR_SET_NEXT(isrcb, _KERNEL_INT_GET_HEAD(pk_cisr->intno));
	_KERNEL_INT_SET_HEAD(pk_cisr->intno, _KERNEL_ISR_GET_ISRHDL(isrid, isrcb));
	
#if _KERNEL_SPT_DPC
	if ( !_KERNEL_SYS_SNS_LOC() ) { _KERNEL_ENA_INT(); }	/* %jp{ߵ} */
#endif
	
	return E_OK;
}



/* end of file */
