/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  sig_mbx.c
 * @brief %jp{᡼ܥå񸻤ֵ}%en{Release Semaphore Resource}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mbxobj.h"



#if _KERNEL_SPT_SND_MBX


/**< %jp{᡼ܥåؤ} */
ER snd_mbx(ID mbxid, T_MSG *pk_msg)
{
	_KERNEL_T_MBXCB_PTR mbxcb;
	_KERNEL_T_TSKHDL    tskhdl;
	_KERNEL_T_TCB       *tcb;
	
	/* %jp{ID Υå} */
#if _KERNEL_SPT_SND_MBX_E_ID
	if ( !_KERNEL_MBX_CHECK_MBXID(mbxid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_SND_MBX_E_NOEXS
	if ( !_KERNEL_MBX_CHECK_EXS(mbxid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */
		return E_NOEXS;			/* %jp{֥̤} */
	}
#endif
	
	/* %jp{ȥ֥å} */
	mbxcb = _KERNEL_MBX_ID2MBXCB(mbxid);
	
	/* %jp{ԤƬ饿Ф} */
	tskhdl = _kernel_rmh_que(_KERNEL_MBX_GET_QUE(mbxcb));
	if ( tskhdl != _KERNEL_TSKHDL_NULL )
	{
		T_MSG **ppk_msg;

		/* %jp{ԤԤ} */
		tcb     = _KERNEL_TSK_TSKHDL2TCB(tskhdl);			/* %jp{TCB} */
		ppk_msg = (T_MSG **)_KERNEL_TSK_GET_DATA(tcb);
		*ppk_msg = pk_msg;
		_KERNEL_TSK_SET_ERCD(tcb, E_OK);				/* %jp{顼} */
		_KERNEL_DSP_WUP_TSK(tskhdl);					/* %jp{Ԥ} */
		_KERNEL_MBX_RMV_TOQ(tskhdl);					/* %jp{ॢȤβ} */
		
		/* %jp{ǥѥåμ¹} */
		_KERNEL_DSP_TSK();
	}
	else
	{
		/* %jp{᡼ܥåɲ} */
		_KERNEL_MBX_ADD_MSG(mbxcb, _KERNEL_MBX_GET_MBXCB_RO(mbxid, mbxcb), pk_msg);
	}
	
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return E_OK;	/* %jp{ｪλ}%en{Normal completion} */
}


#else	/* _KERNEL_SPT_SND_MBX */


#if _KERNEL_SPT_SND_MBX_E_NOSPT


ER snd_mbx(ID mbxid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_SND_MBX */



/* end of file */
