/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_mpf.c
 * @brief %jp{Ĺס(IDֹ漫ưդ)}%en{Create fixed-sized memory pool(ID Number Automatic Assignment)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mpfobj.h"



#if _KERNEL_SPT_ACRE_MPF

/** %jp{Ĺס(IDֹ漫ưդ)}%en{Create fixed-sized memory pool(ID Number Automatic Assignment)}
 * @param  pk_cmpf	      %jp{Ĺס줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the fixed-sized memory pool creation information}
 * @retval %jp{}%en{positiv-value} %jp{ĹסIDֹ}%en{ID number of the created fixed-sized memory pool}
 * @retval E_NOID  %jp{IDֹ­(ղǽʸĹסID̵)}%en{No ID number available(there id no fixed-sized memory pool ID assignable)}
 * @retval E_RSATR %jp{ͽ°(mpfatr뤤ϻѤǤʤ)}%en{Reserved attribute(mpfatr is invalid or unusable)}
 */
ER_ID acre_mpf(const T_CMPF *pk_cmpf)
{
	ID    mpfid;
	ER_ID erid;

	/* %jp{°å}%en{check attribute} */
#if _KERNEL_SPT_ACRE_MPF_E_RSATR
	if ( ((pk_cmpf->mpfatr & TA_TPRI) == 0 && !_KERNEL_SPT_MPF_TA_TFIFO)
		|| ((pk_cmpf->mpfatr & TA_TPRI) != 0 && !_KERNEL_SPT_MPF_TA_TPRI) )
	{
		return E_RSATR;	/* %jp{ͽ°}%en{Reserved attribute} */
	}
#endif

	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{IDõ} */
	for ( mpfid = _KERNEL_MPF_TMAX_ID; mpfid >= _KERNEL_MPF_TMIN_ID; mpfid-- )
	{
		if ( !_KERNEL_MPF_CHECK_EXS(mpfid) )
		{
			break;
		}
	}

	/* %jp{IDõå} */
#if _KERNEL_SPT_ACRE_MPF_E_NOID
	if ( mpfid < _KERNEL_MPF_TMIN_ID )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOID;			/* %jp{IDֹ­} */
	}
#endif
	
	/* %jp{֥} */
#if (_KERNEL_MPFCB_ALGORITHM == _KERNEL_MPFCB_ALG_PTRARRAY) && _KERNEL_SPT_ACRE_MPF_E_NOMEM
	erid = (ER_ID)_kernel_cre_mpf(mpfid, pk_cmpf);
	if ( erid == E_OK )
	{
		erid = (ER_ID)mpfid;	/* %jp{顼ǤʤиĹסIDǼ} */
	}
#else
	_kernel_cre_mpf(mpfid, pk_cmpf);
	erid = (ER_ID)mpfid;		/* %jp{ĹסIDǼ} */
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return erid;
}


#else	/* _KERNEL_SPT_ACRE_MPF */


#if _KERNEL_SPT_ACRE_MPF_E_NOSPT


/** %jp{Ĺס(IDֹ漫ưդ)}%en{Create Semaphore(ID Number Automatic Assignment)}
 * @param  pk_cmpf  %jp{Ĺס줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the mpfaphore creation information}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER_ID acre_mpf(const T_CMPF *pk_cmpf)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_ACRE_MPF */



/* end of file */
