/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  acre_mpf.c
 * @brief %jp{Ĺס}%en{}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mpfobj.h"


/* %jp{­顼åݡȤȽ} */
#if (_KERNEL_SPT_CRE_MPF && _KERNEL_SPT_CRE_MPF_E_NOMEM) || (_KERNEL_SPT_ACRE_MPF && _KERNEL_SPT_ACRE_MPF_E_NOMEM)
#define _KERNEL_SPT_KCRE_MPF_E_NOMEM	TRUE
#else
#define _KERNEL_SPT_KCRE_MPF_E_NOMEM	FALSE
#endif


void _kernel_set_mpf(_KERNEL_T_MPFCB_PTR mpfcb, _KERNEL_MPF_T_BLKCNT blkcnt, _KERNEL_MPF_T_BLKSZ blksz, VP mpf);


/** %jp{Ĺס}%en{Create mpfaphore}
 * @param  mpfid	%jp{оݤθĹסIDֹ}%en{ID number of the mpfaphore to be created}
 * @param  pk_ctsk	%jp{Ĺס줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the mpfaphore creation information}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_NOMEM  %jp{­}%en{Insufficient memory}
 */
ER _kernel_cre_mpf(ID mpfid, const T_CMPF *pk_cmpf)
{
	_KERNEL_T_MPFCB    *mpfcb;
	_KERNEL_T_MPFCB_RO *mpfcb_ro;
	VP                 mpf;
	
	/* %jp{}%en{get memory} */
#if _KERNEL_MPFCB_ALGORITHM == _KERNEL_MPFCB_ALG_BLKARRAY
	{	/*  %jp{MPFCBΰ褬֥åξ} */

		/*  */
		if ( pk_cmpf->mpf == NULL )
		{
			mpf = _KERNEL_SYS_ALC_HEP(TSZ_MPF(pk_cmpf->blkcnt, pk_cmpf->blksz));
		/* %jp{­å} */
#if _KERNEL_SPT_KCRE_MPF_E_NOMEM
			if ( mpf == NULL )
			{
				return E_NOMEM;
			}
#endif
		}
		else
		{
			mpf = pk_cmpf->mpf;
		}
		mpfcb    = _KERNEL_MPF_ID2MPFCB(mpfid);
		mpfcb_ro = mpfcb;
	}
#elif _KERNEL_MPFCB_ALGORITHM == _KERNEL_MPFCB_ALG_PTRARRAY
#if _KERNEL_MPFCB_SPLIT_RO
	{	/* %jp{MPFCBΰ褬ݥ󥿴ǡROM/RAMʬΥξ} */
		VP   mem;
		SIZE memsz;

		/* %jp{ꥵ} */
		memsz  = _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_MPFCB));
		memsz += _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_MPFCB_ROM));
		if ( pk_cmpf->mpf == NULL )
		{
			memsz += TSZ_MPF(pk_cmpf->blkcnt, pk_cmpf->blksz);
		}

		/* %jp{} */
		mem = _KERNEL_SYS_ALC_HEP(memsz);

		/* %jp{­å} */
#if _KERNEL_SPT_KCRE_MPF_E_NOMEM
		if ( mem == NULL )
		{
			return E_NOMEM;
		}
#endif
		
		/* %jp{} */
		mpfcb    = (_KERNEL_T_MPFCB *)mem;
		mpfcb_ro = (_KERNEL_T_MPFCB_ROM *)((B *)mem + _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_MPFCB)));
		mpfcb->mpfcb_ro = mpfcb_ro;
		_KERNEL_TSK_ID2MPFCB(mpfid) = mpfcb;
		if ( pk_cmpf->mpf == NULL )
		{
			mpf = (_KERNEL_T_MPFCB_ROM *)((B *)mem + _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_MPFCB)) + _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_MPFCB_ROM)));
		}
		else
		{
			mpf = pk_cmpf->mpf;
		}
	}
#else
	{	/* %jp{MPFCBΰ褬ݥ󥿴ǡROM/RAMξ} */
		VP   mem;
		SIZE memsz;

		/* %jp{ꥵ} */
		memsz = _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_MPFCB));
		if ( pk_cmpf->mpf == NULL )
		{
			memsz += TSZ_MPF(pk_cmpf->blkcnt, pk_cmpf->blksz)
		}

		/* %jp{} */
		mem = _KERNEL_SYS_ALC_HEP(memsz);

		/* %jp{­å} */
#if _KERNEL_SPT_KCRE_MPF_E_NOMEM
		if ( mem == NULL )
		{
			return E_NOMEM;
		}
#endif

		/* %jp{} */
		mpfcb    = (_KERNEL_T_MPFCB *)mem;
		mpfcb_ro = mpfcb;
		_KERNEL_MPF_ID2MPFCB(mpfid) = mpfcb;
		if ( pk_cmpf->mpf == NULL )
		{
			mpf = (_KERNEL_T_MPFCB_ROM *)((B *)mem + _KERNEL_SYS_ALG_HEP(sizeof(_KERNEL_T_MPFCB)));
		}
		else
		{
			mpf = pk_cmpf->mpf;
		}
	}
#endif
#endif
		
	/* %jp{н} */
	_KERNEL_MPF_SET_MPFATR(mpfcb_ro, pk_cmpf->mpfatr);
	_KERNEL_MPF_SET_BLKCNT(mpfcb_ro, pk_cmpf->blkcnt);
	_KERNEL_MPF_SET_BLKSZ(mpfcb_ro, _KERNEL_TSZ_ALIGNED(pk_cmpf->blksz));
	_KERNEL_MPF_SET_MPF(mpfcb_ro, mpf);
	_KERNEL_CRE_QUE(_KERNEL_MPF_GET_QUE(mpfcb));
	_kernel_set_mpf(mpfcb, pk_cmpf->blkcnt, pk_cmpf->blksz, mpf);

	return E_OK;
}


void _kernel_set_mpf(_KERNEL_T_MPFCB_PTR mpfcb, _KERNEL_MPF_T_BLKCNT blkcnt, _KERNEL_MPF_T_BLKSZ blksz, VP mpf)
{
	UINT i;

#if _KERNEL_MPF_ALGORITHM == _KERNEL_MPF_ALG_CHAIN_PTR		/* %jp{ݥ󥿴} */
	{
		VB *ptr, *next;

		ptr = (VB *)mpf;
		_KERNEL_MPF_SET_FREBLK(mpfcb, ptr);
		for ( i = 0; i < blkcnt - 1; i++ )
		{
			next = ptr + blksz;
			*(_KERNEL_MPFCB_T_BLKHDL *)ptr = next;
			ptr = next;
		}
		*(_KERNEL_MPFCB_T_BLKHDL *)ptr = NULL;
	}
#elif  _KERNEL_MPF_ALGORITHM == _KERNEL_MPF_ALG_CHAIN_NUM	/* %jp{֥åֹ} */
	{
		VB *ptr;

		ptr = (VB *)mpf;
		_KERNEL_MPF_SET_FREBLK(mpfcb, 1);
		for ( i = 1; i < blkcnt - 1; i++ )
		{
			*(_KERNEL_MPFCB_T_BLKHDL *)ptr = (i + 1);
			ptr += blksz;
		}
		*(_KERNEL_MPFCB_T_BLKHDL *)ptr = 0;
	}
#endif
}




/* end of file */
