/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  cre_mtx.c
 * @brief %jp{ߥ塼ƥå}%en{Create Mutex}
 *
 * Copyright (C) 1998-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/mtxobj.h"



#if _KERNEL_SPT_CRE_MTX


/** %jp{ߥ塼ƥå}%en{Create Mutex}
 * @param  mtxid    %jp{оݤΥߥ塼ƥåIDֹ}%en{ID number of the mutex to be created}
 * @param  pk_ctsk	%jp{ߥ塼ƥå줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the mutex creation information}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(mtxid뤤ϻѤǤʤ)}%en{Invalid ID number(mtxid is invalid or unusable)}
 * @retval E_RSATR  %jp{ͽ°(mtxatr뤤ϻѤǤʤ)}%en{Reserved attribute(mtxatr is invalid or unusable)}
 * @retval E_OBJ    %jp{֥Ⱦ֥顼(оݥߥ塼ƥåϿѤ)}%en{Object state error(specified mutex is already registerd)}
 */
ER cre_mtx(ID mtxid, const T_CMTX *pk_cmtx)
{
	ER ercd;

	/* %jp{IDå}%en{check ID} */
#if _KERNEL_SPT_CRE_MTX_E_ID
	if ( !_KERNEL_MTX_CHECK_MTXID(mtxid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}	
#endif

	/* %jp{°å}%en{check attribute} */
#if _KERNEL_SPT_CRE_MTX_E_RSATR
	if ( ((pk_cmtx->mtxatr & TA_TPRI) == 0 && !_KERNEL_SPT_MTX_TA_TFIFO)
		|| ((pk_cmtx->mtxatr & TA_TPRI) != 0 && !_KERNEL_SPT_MTX_TA_TPRI) )
	{
		return E_RSATR;	/* %jp{ͽ°}%en{Reserved attribute} */
	}
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{¸ߥå}%en{check object} */
#if _KERNEL_SPT_CRE_MTX_E_OBJ
	if ( _KERNEL_MTX_CHECK_EXS(mtxid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_OBJ;			/* %jp{֥Ⱦ֥顼}%en{Object state error} */
	}
#endif
	
	/* %jp{֥}%en{create object} */
	ercd = _kernel_cre_mtx(mtxid, pk_cmtx);
	
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return ercd;
}


#else	/* _KERNEL_SPT_CRE_MTX */


#if _KERNEL_SPT_CRE_MTX_E_NOSPT

/** %jp{ߥ塼ƥå}%en{Create Mutex}
 * @param  mtxid    %jp{оݤΥߥ塼ƥåIDֹ}%en{ID number of the mutex to be created}
 * @param  pk_ctsk	%jp{ߥ塼ƥå줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the mutex creation information}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER cre_mtx(ID mtxid, const T_CMTX *pk_cmtx)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_CRE_MTX */



/* end of file */
