/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  del_mtx.c
 * @brief %jp{ߥ塼ƥåκ}%en{Delete Mutex}
 *
 * Copyright (C) 1998-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/mtxobj.h"



#if _KERNEL_SPT_DEL_MTX


/** %jp{ߥ塼ƥåκ}%en{Delete Mutex}
 * @param  mtxid    %jp{оݤΥߥ塼ƥåIDֹ}%en{ID number of the mutex to be deleted}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(mtxid뤤ϻѤǤʤ)}%en{Invalid ID number(mtxid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥߥ塼ƥå̤Ͽ)}%en{Non-existant object(specified mutex is not registerd)}
 */
ER del_mtx(ID mtxid)
{
	_KERNEL_T_MTXCB  *mtxcb;
	_KERNEL_T_QUE    *pk_que;
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;

	/* %jp{IDå}%en{check ID} */
#if _KERNEL_SPT_DEL_MTX_E_ID
	if ( !_KERNEL_MTX_CHECK_MTXID(mtxid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}	
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{¸ߥå}%en{check object} */
#if _KERNEL_SPT_DEL_MTX_E_NOEXS
	if ( !_KERNEL_MTX_CHECK_EXS(mtxid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOEXS;			
	}
#endif
	
	/* %jp{ߥ塼ƥåȥ֥å} */
	mtxcb = _KERNEL_MTX_ID2MTXCB(mtxid);
	
	/* %jp{Ԥ} */
	pk_que = _KERNEL_MTX_GET_QUE(mtxcb);
	
	/* %jp{ԤΥƵ} */
	while ( (tskhdl = _KERNEL_RMH_QUE(pk_que)) != _KERNEL_TSKHDL_NULL )
	{
		/* %jp{ԤԤ} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);		/* %jp{TCB} */
		_KERNEL_TSK_SET_ERCD(tcb, E_DLT);			/* %jp{顼} */
		_KERNEL_MTX_RMV_TOQ(tskhdl);				/* %jp{ॢȥ塼鳰} */
		_KERNEL_DSP_WUP_TSK(tskhdl);				/* %jp{Ԥ} */	
	}
	
	/* %jp{֥Ⱥ} */
#if _KERNEL_MTXCB_ALGORITHM == _KERNEL_MTXCB_ALG_PTRARRAY
	_KERNEL_SYS_FRE_HEP(mtxcb);						/* %jp{곫} */
	_KERNEL_MTX_ID2MTXCB(mtxid) = NULL;
#elif _KERNEL_MTXCB_ALGORITHM == _KERNEL_MTXCB_ALG_BLKARRAY
	_KERNEL_MTX_SET_MTXATR(mtxcb, 0);
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return E_OK;
}


#else	/* _KERNEL_SPT_DEL_MTX */


#if _KERNEL_SPT_DEL_MTX_E_NOSPT

/** %jp{ߥ塼ƥåκ}%en{Delete Mutex}
 * @param  mtxid    %jp{оݤΥߥ塼ƥåIDֹ}%en{ID number of the mutex to be deleted}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER del_mtx(ID mtxid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_DEL_MTX */



/* end of file */
