/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  loc_mtx.c
 * @brief %jp{ߥ塼ƥåΥå}%en{Lock Mutex}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mtxobj.h"



#if _KERNEL_SPT_LOC_MTX


#if _KERNEL_SPT_KLOC_MTX && (_KERNEL_OPT_CODE_SIZE <= _KERNEL_OPT_SPEED)	/* %jp{ɥͥ礢ʤ} */

/** %jp{ߥ塼ƥåΥå}%en{Lock Mutex}
 * @param  mtxid    %jp{åоݤΥߥ塼ƥåIDֹ}%en{ID number of the mutex to be locked}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(mtxid뤤ϻѤǤʤ)}%en{Invalid ID number(mtxid is invalid or unusable)}
 * @retval E_CTX    %jp{ƥȥ顼}%en{Context error}
 * @retval E_NOEXS  %jp{֥̤(оݥߥ塼ƥå̤Ͽ)}%en{Non-existant object(specified mutex is not registerd)}
 * @retval E_ILUSE  %jp{ӥ(ߥ塼ƥå¿ťåͥ٤ΰȿ)}%en{Illegal service call use(multiple locking of a mutex, ceiling priority violation)}
 * @retval E_RLWAI  %jp{Ԥ֤ζ(Ԥ֤δ֤rel_wai)}%en{Forced release from waiting(accept rel_wai while waiting)}
 * @retval E_DLT    %jp{Ԥ֥Ȥκ(Ԥ֤δ֤оݥߥ塼ƥå)}%en{Waiting object deleted(mutex is deleted waiting)}
 */
ER loc_mtx(ID mtxid)
{
	/* %jp{pol_mtxtloc_mtxȶ̽Ȥ} */
	return _kernel_loc_mtx(mtxid, TMO_FEVR);
}

#else

/** %jp{ߥ塼ƥåΥå}%en{Lock Mutex}
 * @param  mtxid    %jp{åоݤΥߥ塼ƥåIDֹ}%en{ID number of the mutex to be locked}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(mtxid뤤ϻѤǤʤ)}%en{Invalid ID number(mtxid is invalid or unusable)}
 * @retval E_CTX    %jp{ƥȥ顼}%en{Context error}
 * @retval E_NOEXS  %jp{֥̤(оݥߥ塼ƥå̤Ͽ)}%en{Non-existant object(specified mutex is not registerd)}
 * @retval E_ILUSE  %jp{ӥ(ߥ塼ƥå¿ťåͥ٤ΰȿ)}%en{Illegal service call use(multiple locking of a mutex, ceiling priority violation)}
 * @retval E_RLWAI  %jp{Ԥ֤ζ(Ԥ֤δ֤rel_wai)}%en{Forced release from waiting(accept rel_wai while waiting)}
 * @retval E_DLT    %jp{Ԥ֥Ȥκ(Ԥ֤δ֤оݥߥ塼ƥå)}%en{Waiting object deleted(mutex is deleted waiting)}
 */
ER loc_mtx(ID mtxid)
{
	_KERNEL_T_MTXCB_RO_PTR	mtxcb_ro;
	_KERNEL_T_MTXCB_PTR		mtxcb;
	_KERNEL_T_MTXHDL		mtxhdl;
	_KERNEL_T_TCB_PTR		tcb;
	_KERNEL_T_TSKHDL		tskhdl;
	_KERNEL_T_TSKHDL		tskhdl_lock;
	ER						ercd;
	
	/* %jp{ƥȥå} */
#if _KERNEL_SPT_LOC_MTX_E_CTX
	if ( _KERNEL_SYS_SNS_DPN() )
	{
		return E_CTX;			/* %jp{ƥȥ顼}%en{Context error} */
	}
#endif
	
	/* %jp{ID Υå} */
#if _KERNEL_SPT_LOC_MTX_E_ID
	if ( !_KERNEL_MTX_CHECK_MTXID(mtxid) )
	{
		return E_ID;			/* %jp{IDֹ}%en{Invalid ID number} */
	}
#endif
	
	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_LOC_MTX_E_NOEXS
	if ( !_KERNEL_MTX_CHECK_EXS(mtxid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOEXS;			/* %jp{֥̤}%en{Non-existant object} */
	}
#endif

	/* %jp{ߥ塼ƥåȥ֥å} */
	mtxcb    = _KERNEL_MTX_ID2MTXCB(mtxid);
	mtxcb_ro = _KERNEL_MTX_GET_MTXCB_RO(mtxid, mtxcb);

	/* %jp{¹Υϥɥ} */
	tskhdl = _KERNEL_SYS_GET_RUNTSK();
	tcb    = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{åΥϥɥ} */
	tskhdl_lock = _KERNEL_MTX_GET_TSKHDL(mtxcb);

	if ( _KERNEL_MTX_GET_TSKHDL(mtxcb) == _KERNEL_TSKHDL_NULL )
	{
		/* %jp{ͭʤХߥ塼ƥåå} */
		_KERNEL_MTX_SET_TSKHDL(mtxcb, tskhdl); 		/* %jp{ߥ塼ƥå񸻤γ} */

		/* %jp{ߥ塼ƥåTCB³} */
		mtxhdl = _KERNEL_MTX_GET_MTXHDL(mtxid, mtxcb);
		_kernel_add_mtx(mtxhdl, tskhdl);
		
#if _KERNEL_SPT_MTX_TA_CEILING
		if ( _KERNEL_MTX_GET_MTXATR(mtxcb_ro) == TA_CEILING )
		{
			/* %jp{ͥ٤򥷡ͤޤǰ夲} */
			if ( _KERNEL_TSK_GET_TSKPRI(tcb) < _KERNEL_MTX_GET_CEILPRI(mtxcb_ro) )
			{
				_KERNEL_TSK_SET_TSKPRI(tcb, _KERNEL_MTX_GET_CEILPRI(mtxcb_ro));
			}
		}
#endif
		
		ercd = E_OK;
	}
	else
	{
		/* %jp{Ԥ֤ˤ} */
		_KERNEL_TSK_SET_TSKWAIT(tcb, _KERNEL_TTW_MTX);
		_KERNEL_TSK_SET_WOBJID(tcb, mtxid);
		_KERNEL_DSP_WAI_TSK(tskhdl);
		_KERNEL_MTX_ADD_QUE(mtxcb, _KERNEL_MTX_GET_MTXCB_RO(mtxid, mtxcb), tskhdl);			/* %jp{Ԥɲ} */

#if _KERNEL_SPT_MTX_TA_INHERIT
		/* %jp{ͥٷѾ} */
		if ( _KERNEL_MTX_GET_MTXATR(mtxcb_ro) == TA_INHERIT )
		{
			_KERNEL_T_TCB_PTR tcb_lock;

			/* %jp{å楿TCB} */
			tcb_lock = _KERNEL_TSK_TSKHDL2TCB(tskhdl_lock);

			/* %jp{ͥٷѾ} */
			if ( _KERNEL_TSK_GET_TSKPRI(tcb_lock) > _KERNEL_TSK_GET_TSKPRI(tcb) )
			{
				_KERNEL_TSK_SET_TSKPRI(tcb_lock, _KERNEL_TSK_GET_TSKPRI(tcb));
				if ( _KERNEL_TSK_GET_TSKSTAT(tcb) == TTS_RDY )
				{
					_KERNEL_SYS_RMV_RDQ(tskhdl);
					_KERNEL_SYS_ADD_RDQ(tskhdl);
				}
			}
		}
#endif

		/* %jp{ǥѥåμ¹} */
		_KERNEL_DSP_TSK();

		/* %jp{顼ɤμ} */
		ercd = _KERNEL_TSK_GET_ERCD(tcb);
	}
	
	_KERNEL_LEAVE_SVC();	/* %jp{֥̤}%en{Non-existant object} */
	
	return ercd;
}

#endif


#else	/* _KERNEL_SPT_LOC_MTX */


#if _KERNEL_SPT_LOC_MTX_E_NOSPT

/** %jp{ߥ塼ƥåΥå}%en{Lock Mutex}
 * @param  mtxid    %jp{åоݤΥߥ塼ƥåIDֹ}%en{ID number of the mutex to be locked}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER loc_mtx(ID mtxid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_LOC_MTX */



/* end of file */
