/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  cre_sem.c
 * @brief %jp{ޥե}%en{Create Semaphore}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/semobj.h"



#if _KERNEL_SPT_CRE_SEM


/** %jp{ޥե}%en{Create Semaphore}
 * @param  semid    %jp{оݤΥޥեIDֹ}%en{ID number of the semaphore to be created}
 * @param  pk_ctsk	%jp{ޥե줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the semaphore creation information}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(semid뤤ϻѤǤʤ)}%en{Invalid ID number(semid is invalid or unusable)}
 * @retval E_RSATR  %jp{ͽ°(sematr뤤ϻѤǤʤ)}%en{Reserved attribute(sematr is invalid or unusable)}
 * @retval E_OBJ    %jp{֥Ⱦ֥顼(оݥޥեϿѤ)}%en{Object state error(specified semaphore is already registerd)}
 */
ER cre_sem(ID semid, const T_CSEM *pk_csem)
{
	ER ercd;

	/* %jp{IDå}%en{check ID} */
#if _KERNEL_SPT_CRE_SEM_E_ID
	if ( !_KERNEL_SEM_CHECK_SEMID(semid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}	
#endif

	/* %jp{°å}%en{check attribute} */
#if _KERNEL_SPT_CRE_SEM_E_RSATR
	if ( ((pk_csem->sematr & TA_TPRI) == 0 && !_KERNEL_SPT_SEM_TA_TFIFO)
		|| ((pk_csem->sematr & TA_TPRI) != 0 && !_KERNEL_SPT_SEM_TA_TPRI) )
	{
		return E_RSATR;	/* %jp{ͽ°}%en{Reserved attribute} */
	}
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{¸ߥå}%en{check object} */
#if _KERNEL_SPT_CRE_SEM_E_OBJ
	if ( _KERNEL_SEM_CHECK_EXS(semid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_OBJ;			/* %jp{֥Ⱦ֥顼}%en{Object state error} */
	}
#endif
	
	/* %jp{֥}%en{create object} */
	ercd = _kernel_cre_sem(semid, pk_csem);
	
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return ercd;
}


#else	/* _KERNEL_SPT_CRE_SEM */


#if _KERNEL_SPT_CRE_SEM_E_NOSPT

/** %jp{ޥե}%en{Create Semaphore}
 * @param  semid    %jp{оݤΥޥեIDֹ}%en{ID number of the semaphore to be created}
 * @param  pk_ctsk	%jp{ޥե줿ѥåȤؤΥݥ}%en{Pointer to the packet containing the semaphore creation information}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER cre_sem(ID semid, const T_CSEM *pk_csem)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_CRE_SEM */



/* end of file */
