/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  del_sem.c
 * @brief %jp{ޥեκ}%en{Delete Semaphore}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"
#include "object/semobj.h"



#if _KERNEL_SPT_DEL_SEM


/** %jp{ޥեκ}%en{Delete Semaphore}
 * @param  semid    %jp{оݤΥޥեIDֹ}%en{ID number of the semaphore to be deleted}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(semid뤤ϻѤǤʤ)}%en{Invalid ID number(semid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥޥե̤Ͽ)}%en{Non-existant object(specified semaphore is not registerd)}
 */
ER del_sem(ID semid)
{
	_KERNEL_T_SEMCB  *semcb;
	_KERNEL_T_QUE    *pk_que;
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;

	/* %jp{IDå}%en{check ID} */
#if _KERNEL_SPT_DEL_SEM_E_ID
	if ( !_KERNEL_SEM_CHECK_SEMID(semid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}	
#endif
	
	_KERNEL_ENTER_SVC();	/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{¸ߥå}%en{check object} */
#if _KERNEL_SPT_DEL_SEM_E_NOEXS
	if ( !_KERNEL_SEM_CHECK_EXS(semid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOEXS;
	}
#endif
	
	/* %jp{ޥեȥ֥å} */
	semcb = _KERNEL_SEM_ID2SEMCB(semid);
	
	/* %jp{Ԥ} */
	pk_que = _KERNEL_SEM_GET_QUE(semcb);
	
	/* %jp{ԤΥƵ} */
	while ( (tskhdl = _KERNEL_RMH_QUE(pk_que)) != _KERNEL_TSKHDL_NULL )
	{
		/* %jp{ԤԤ} */
		tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);		/* %jp{TCB} */
		_KERNEL_TSK_SET_ERCD(tcb, E_DLT);			/* %jp{顼} */
		_KERNEL_SEM_RMV_TOQ(tskhdl);				/* %jp{ॢȥ塼鳰} */
		_KERNEL_DSP_WUP_TSK(tskhdl);				/* %jp{Ԥ} */	
	}
	
	/* %jp{֥Ⱥ} */
#if _KERNEL_SEMCB_ALGORITHM == _KERNEL_SEMCB_ALG_PTRARRAY
	_KERNEL_SYS_FRE_HEP(semcb);						/* %jp{곫} */
	_KERNEL_SEM_ID2SEMCB(semid) = NULL;
#elif _KERNEL_SEMCB_ALGORITHM == _KERNEL_SEMCB_ALG_BLKARRAY
	_KERNEL_SEM_SET_MAXSEM(semcb, 0);
#endif

	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return E_OK;
}


#else	/* _KERNEL_SPT_DEL_SEM */


#if _KERNEL_SPT_DEL_SEM_E_NOSPT

/** %jp{ޥեκ}%en{Delete Semaphore}
 * @param  semid    %jp{оݤΥޥեIDֹ}%en{ID number of the semaphore to be deleted}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER del_sem(ID semid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_DEL_SEM */



/* end of file */
