/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  pol_sem.c
 * @brief %jp{ޥե񸻤γ(ݡ)}%en{Acquire Semaphore Resource(Polling)}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/semobj.h"



#if _KERNEL_SPT_POL_SEM


#if _KERNEL_SPT_TWAI_SEM && (_KERNEL_OPT_CODE_SIZE <= _KERNEL_OPT_SPEED)	/* %jp{twai_semǡͥʤ} */

/** %jp{ޥե񸻤γ(ݡ)}%en{Acquire Semaphore Resource(Polling)}
 * @param  semid    %jp{񸻳оݤΥޥեIDֹ}%en{ID number of the semaphore from which resource is acquired}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(semid뤤ϻѤǤʤ)}%en{Invalid ID number(semid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥޥե̤Ͽ)}%en{Non-existant object(specified semaphore is not registerd)}
 * @retval E_TMOUT  %jp{ݡ󥰼}%en{Polling failure}
 */
ER pol_sem(ID semid)
{
	/* %jp{pol_semtwai_semȶ̽Ȥ} */
	return _kernel_wai_sem(semid, TMO_POL);
}

#else

/** %jp{ޥե񸻤γ(ݡ)}%en{Acquire Semaphore Resource(Polling)}
 * @param  semid    %jp{񸻳оݤΥޥեIDֹ}%en{ID number of the semaphore from which resource is acquired}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(semid뤤ϻѤǤʤ)}%en{Invalid ID number(semid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥޥե̤Ͽ)}%en{Non-existant object(specified semaphore is not registerd)}
 * @retval E_TMOUT  %jp{ݡ󥰼}%en{Polling failure}
 */
ER pol_sem(ID semid)
{
	_KERNEL_T_SEMCB_PTR  semcb;
	_KERNEL_SEM_T_SEMCNT semcnt;
	ER                   ercd;
	
	/* %jp{ID Υå} */
#if _KERNEL_SPT_POL_SEM_E_ID
	if ( !_KERNEL_SEM_CHECK_SEMID(semid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}
#endif
	
	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_POL_SEM_E_NOEXS
	if ( !_KERNEL_SEM_CHECK_EXS(semid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOEXS;			/* %jp{֥̤}%en{Non-existant object} */
	}
#endif

	/* %jp{ޥեȥ֥å} */
	semcb = _KERNEL_SEM_ID2SEMCB(semid);
	
	/* %jp{ޥե󥿼} */
	semcnt = _KERNEL_SEM_GET_SEMCNT(semcb);

	/* %jp{񸻿å} */
	if ( semcnt > 0 ) 
	{
		/* %jp{ޥե񸻤} */
		_KERNEL_SEM_SET_SEMCNT(semcb, semcnt - 1); 		/* %jp{ޥե񸻤γ} */
		ercd = E_OK;
	}
	else
	{
		ercd = E_TMOUT;
	}
	
	
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	return ercd;
}

#endif


#else	/* _KERNEL_SPT_POL_SEM */


#if _KERNEL_SPT_POL_SEM_E_NOSPT

/** %jp{ޥե񸻤γ(ݡ)}%en{Acquire Semaphore Resource(Polling)}
 * @param  semid    %jp{񸻳оݤΥޥեIDֹ}%en{ID number of the semaphore from which resource is acquired}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER wai_sem(ID semid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_POL_SEM */



/* end of file */
