/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  ref_sem.c
 * @brief %jp{ޥեξֻ}%en{Reference Semaphore State}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/semobj.h"



#if _KERNEL_SPT_REF_SEM


/** %jp{ޥեξֻ}%en{Reference Semaphore State}
 * @param  semid    %jp{񸻳оݤΥޥեIDֹ}%en{ID number of the semaphore from which resource is acquired}
 * @param  pk_rsem  %jp{ޥե֤֤ѥåȤؤΥݥ}%en{Pointer to the packet returning the semaphore state}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(semid뤤ϻѤǤʤ)}%en{Invalid ID number(semid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥޥե̤Ͽ)}%en{Non-existant object(specified semaphore is not registerd)}
 * @retval E_PAR    %jp{ѥ᡼顼(pk_rsem)}%en{Parameter error(pk_rsem is invalid)}
 */
ER ref_sem(ID semid, T_RSEM *pk_rsem)
{
	_KERNEL_T_SEMCB_PTR semcb;
	
	/* %jp{ID Υå} */
#if _KERNEL_SPT_REF_SEM_E_ID
	if ( !_KERNEL_SEM_CHECK_SEMID(semid) )
	{
		return E_ID;	/* %jp{IDֹ}%en{Invalid ID number} */
	}
#endif
	
#if _KERNEL_SPT_REF_SEM_E_PAR
	if ( pk_rsem == NULL )
	{
		return E_PAR;	/* %jp{ѥ᡼顼}%en{Parameter error} */
	}
#endif
		
	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_REF_SEM_E_NOEXS
	if ( !_KERNEL_SEM_CHECK_EXS(semid) )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_NOEXS;			/* %jp{֥̤}%en{Non-existant object} */
	}
#endif

	/* %jp{ޥեȥ֥å} */
	semcb = _KERNEL_SEM_ID2SEMCB(semid);
	
	/* %jp{} */
	pk_rsem->wtskid = _KERNEL_TSK_GET_TSKID(_KERNEL_REF_QUE(_KERNEL_SEM_GET_QUE(semcb)));
	pk_rsem->semcnt = _KERNEL_SEM_GET_SEMCNT(semcb);
	
	_KERNEL_LEAVE_SVC();	/* %jp{֥̤}%en{Non-existant object} */
	
	return E_OK;
}


#else	/* _KERNEL_SPT_REF_SEM */


#if _KERNEL_SPT_REF_SEM_E_NOSPT

/** %jp{ޥե񸻤γ(ݡ)}%en{Acquire Semaphore Resource(Polling)}
 * @param  semid    %jp{񸻳оݤΥޥեIDֹ}%en{ID number of the semaphore from which resource is acquired}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER ref_sem(ID semid, T_RSEM *pk_rsem)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_REF_SEM */



/* end of file */
