/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  sta_knl.c
 * @brief %en{Start Kernel}%jp{OSεư}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"



/**** μȴ() *****/
#if _KERNEL_SPT_DPC
_KERNEL_T_DPCMSG dpc_buf[32];
#endif
/**** μȴ(ޤ) *****/




static void _kernel_sys_sta(void);		/** %jp{ƥॳƥȤγ} */


/** %jp{ͥγ(ȼӥ)}%en{Start Kernel}
 * @return void
 */
ER vsta_knl(void)
{
	/* %jp{ƥν} */
	_KERNEL_SYS_INI_SYS();
	
	/* %jp{ץåͭν} */
	_KERNEL_INI_PRC();
	
	_KERNEL_ENTER_SVC();
	
	/* %jp{롼󥿥} */
	_KERNEL_SYS_SET_CTX();
	_KERNEL_SYS_SET_LOC();
	
	/* %jp{IRCͭν} */
	_KERNEL_INI_IRC();
	
	/* %jp{ϥɥ¹} */
	_kernel_cfg_ini();

#if _KERNEL_SPT_DPC
	_KERNEL_SYS_INI_DPC(dpc_buf, 32);
#endif
	
	/* %jp{ƥॳƥȤ} */
	_KERNEL_CRE_CTX(
			_KERNEL_SYS_GET_SYSCTXCB(),
			_KERNEL_SYS_GET_SYSSTKSZ(),
			_KERNEL_SYS_GET_SYSSTK(),
			_KERNEL_SYS_GET_SYSISP(),
			(FP)_kernel_sys_sta,
			(VP_INT)0,
			(VP_INT)0
		);
	
	
	_KERNEL_LEAVE_SVC();
	
	/* %jp{ϥɥ¹} */
	_kernel_cfg_sta();
	
	_KERNEL_ENTER_SVC();
	
	
	/* %jp{ƥȤγ} */
	_kernel_sta_ctx(_KERNEL_SYS_GET_SYSCTXCB());
	
	return E_OK;	/* %jp{} */
}


/** %jp{ƥॳƥȤγ} */
void _kernel_sys_sta(void)
{
	/* %jp{֤} */
	_KERNEL_SYS_CLR_CTX();
	_KERNEL_SYS_CLR_LOC();
	_KERNEL_SYS_CLR_DSP();
	_KERNEL_SYS_CLR_SYS();
	
	/* %jp{DPCбʤ餳ǳߵ} */
#if _KERNEL_SPT_DPC
	_KERNEL_ENA_INT();
#endif
	
	/* %jp{ǥѥå} */
	_KERNEL_DSP_TSK();
	
	/* %jp{ʹߥƥॳƥȤ򥢥ɥȤ} */
	_KERNEL_LEAVE_SVC();
	_kernel_idl_lop();
}


/* end of file */
