/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  dly_tsk.c
 * @brief %jp{ٱ}%en{Delay Task}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "core/core.h"



/** %jp{ٱ}%en{Delay Task}
 * @retval E_OK  %jp{}
 */
ER dly_tsk(RELTIM dlytim)
{
	_KERNEL_T_TSKHDL tskhdl;
	_KERNEL_T_TCB    *tcb;
	ER               ercd;
	
	/* %jp{¹楿} */
	tskhdl = _KERNEL_SYS_GET_RUNTSK();
	
	_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{ӥ} */
		
	/* %jp{ƥȥå} */
#if _KERNEL_SPT_DLY_TSK_E_CTX
	if ( _KERNEL_SYS_SNS_DPN() )
	{
		_KERNEL_LEAVE_SVC();	/* %jp{ӥ뤫Ф}%en{leave service-call} */
		return E_CTX;			/* %jp{ƥȥ顼}%en{Context error} */
	}
#endif

	/* %jp{TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{Ԥ֤ˤ} */
	_KERNEL_DSP_WAI_TSK(tskhdl);
	_KERNEL_TSK_SET_TSKSTAT(tcb, _KERNEL_TTS_WAI);
	_KERNEL_TSK_SET_TSKWAIT(tcb, _KERNEL_TTW_DLY);

	/* %jp{ॢȥ塼˷Ҥ} */
	_KERNEL_SYS_ADD_TOQ(tskhdl, dlytim);
	
	/* %jp{ǥѥåμ¹} */
	_KERNEL_DSP_TSK();
	
	/* %jp{顼ɤμ} */
	ercd = _KERNEL_TSK_GET_ERCD(tcb);
	if ( ercd == E_TMOUT )
	{
		ercd = E_OK;
	}

	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */
	
	return ercd;
}


/* end of file */
