/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  ext_tsk.c
 * @brief %jp{νλȺ}%en{Terminate and Delete Invoking Task}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mtxobj.h"



#if _KERNEL_SPT_EXD_TSK


static void _kernel_exd_tsk(VP_INT exinf1, VP_INT exinf2);


/** %jp{νλȺ}%en{Terminate and Delete Invoking Task}
 * @return void
 */
void exd_tsk(void)
{
	_KERNEL_T_TSKHDL     tskhdl;
	_KERNEL_T_TCB        *tcb;

	/* %jp{¹楿}%en{get current task} */
	tskhdl = _KERNEL_SYS_GET_RUNTSK();
	
	_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	
	/* %jp{ǥ塼} */
	_KERNEL_DSP_EXT_TSK(tskhdl);
	
	/* %jp{TCB}%en{get TCB} */
	tcb    = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{ͭߥ塼ƥåг} */
#if _KERNEL_SPT_MTX
	{
		_KERNEL_T_MTXHDL mtxhdl;
		while ( (mtxhdl = _KERNEL_TSK_GET_MTXHDL(tcb)) != _KERNEL_MTXHDL_NULL )
		{
			_kernel_rmv_mtx(mtxhdl, tskhdl);
		}
	}
#endif
	
	/* %jp{ƥॳƥȤ} */
	_KERNEL_CRE_CTX(
			_KERNEL_SYS_GET_SYSCTXCB(),
			_KERNEL_SYS_GET_SYSSTKSZ(),
			_KERNEL_SYS_GET_SYSSTK(),
			_KERNEL_SYS_GET_SYSISP(),
			(FP)_kernel_exd_tsk,
			(VP_INT)tskhdl,
			(VP_INT)0
		);
	
	/* %jp{ƥॳƥȤ˥å} */
	_kernel_sta_ctx(_KERNEL_SYS_GET_SYSCTXCB());
}


void _kernel_exd_tsk(VP_INT exinf1, VP_INT exinf2)
{
	_KERNEL_T_TSKHDL	tskhdl;
	_KERNEL_T_TCB_PTR	tcb;
	ID					tskid;
	
	tskhdl = (_KERNEL_T_TSKHDL)exinf1;
	tcb    = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	tskid  = _KERNEL_TSK_TSKHDL2ID(tskhdl);
	
	/* %jp{֥Ⱥ} */
#if _KERNEL_TCB_ALGORITHM == _KERNEL_TCB_ALG_PTRARRAY
	_KERNEL_SYS_FRE_HEP(tcb);						/* %jp{곫} */
	_KERNEL_TSK_ID2TCB(tskid) = NULL;
#elif _KERNEL_TCB_ALGORITHM == _KERNEL_TCB_ALG_BLKARRAY
	_KERNEL_TSK_SET_TASK(tcb, 0);
#endif
	
	/* %jp{ǥѥåμ¹}%en{task dispatch} */
	_KERNEL_DSP_TSK();

	_KERNEL_LEAVE_SVC();		/* %jp{ӥ뤫Ф}%en{leave service-call} */
	
	
	/* %jp{ɥ롼פ} */
	_KERNEL_LEAVE_SVC();
	_kernel_idl_lop();
}


#else	/* _KERNEL_SPT_EXD_TSK */


#endif	/* _KERNEL_SPT_EXD_TSK */


/* end of file */
