/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  ext_tsk.c
 * @brief %jp{νλ}%en{Exit Task}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"
#include "object/mtxobj.h"


/** %jp{νλ}%en{Exit Task}
 * @return void
 */
void ext_tsk(void)
{
	_KERNEL_T_TSKHDL     tskhdl;
	_KERNEL_T_TCB        *tcb;
	_KERNEL_T_TCB_RO     *tcb_ro;
	_KERNEL_TSK_T_ACTCNT actcnt;

	/* %jp{¹楿} */
	tskhdl = _KERNEL_SYS_GET_RUNTSK();

	_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{ӥ} */
	
	/* %jp{ǥ塼} */
	_KERNEL_DSP_EXT_TSK(tskhdl);

	/* %jp{TCB} */
	tcb    = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	tcb_ro = _KERNEL_TSK_GET_TCB_RO(_KERNEL_TSK_TSKHDL2ID(tskhdl), tcb);
	
	
	/* %jp{ͭߥ塼ƥåг} */
#if _KERNEL_SPT_MTX
	{
		_KERNEL_T_MTXHDL mtxhdl;
		while ( (mtxhdl = _KERNEL_TSK_GET_MTXHDL(tcb)) != _KERNEL_MTXHDL_NULL )
		{
			_kernel_rmv_mtx(mtxhdl, tskhdl);
		}
	}
#endif
	
	
	/* %jp{ư׵ͥȤΥå} */
	actcnt = _KERNEL_TSK_GET_ACTCNT(tcb);
	if ( actcnt > 0 )	/* %jp{ư׵ͥȤʤ} */
	{
		_KERNEL_TSK_T_TPRI   itskpri;
		
		_KERNEL_TSK_SET_ACTCNT(tcb, actcnt - 1);
		itskpri = _KERNEL_TSK_GET_ITSKPRI(tcb_ro);
		_KERNEL_TSK_SET_TSKPRI(tcb, itskpri);
		_KERNEL_TSK_SET_TSKBPRI(tcb, itskpri);
		
		/* %jp{ǥ塼³} */
		_KERNEL_DSP_STA_TSK(tskhdl);						
	}
	else				/* %jp{ư׵ͥȤʤнλ} */
	{
		_KERNEL_TSK_SET_TSKSTAT(tcb, _KERNEL_TTS_DMT);
	}
	
	/* %jp{ǥѥåμ¹}%en{task dispatch} */
	_KERNEL_DSP_TSK();
	
	/* %jp{ꥹ} */
	_KERNEL_RST_CTX(
				_KERNEL_TSK_GET_CTXCB(tcb),					/* %jp{ƥ֥å} */
				_KERNEL_TSK_GET_STKSZ(tcb_ro),				/* %jp{Υåΰ襵} */
				_KERNEL_TSK_GET_STK(tcb_ro),				/* %jp{ΥåΰƬ} */
				_KERNEL_TSK_GET_ISP(tcb_ro),				/* %jp{åݥ󥿤ν} */
				(FP)_kernel_ent_tsk,						/* %jp{ƥȤγϥɥ쥹} */
				(VP_INT)_KERNEL_TSK_GET_EXINF(tcb_ro),		/* %jp{γĥ} */
				(VP_INT)_KERNEL_TSK_GET_TASK(tcb_ro)		/* %jp{εư} */
			);
}


/* end of file */
