/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  frsm_tsk.c
 * @brief %jp{Ԥ֤ζƳ}%en{Forcibly Resume Suspended Task}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"


#if _KERNEL_SPT_FRSM_TSK


/** %jp{Ԥ֤ζƳ}%en{Forcibly Resume Suspended Task}
 * @param  tskid    %jp{ƳоݤΥIDֹ}%en{ID number of the task to be resumed}
 * @retval E_OK     %jp{ｪλ}%en{Normal completion}
 * @retval E_ID     %jp{IDֹ(tskid뤤ϻѤǤʤ)}%en{Invalid ID number(tskid is invalid or unusable)}
 * @retval E_NOEXS  %jp{֥̤(оݥ̤Ͽ)}%en{Non-existant object(specified task is not registered)}
 * @retval E_OBJ    %jp{֥Ⱦ֥顼(оݥԤ֤Ǥʤ)}%en{Object state error(specified task is neither in SUSPENDED state nor WAITING-SUSPENDED state)}
 */
ER frsm_tsk(
		ID tskid)
{
	_KERNEL_T_TSKHDL      tskhdl;
	_KERNEL_T_TCB         *tcb;
	
	
#if _KERNEL_SPT_FRSM_TSK_E_ID
	if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
	{
		return E_ID;				/* %jp{IDֹ}%en{Invalid ID number} */
	}
#endif
	
	_KERNEL_ENTER_SVC();			/* %jp{ӥ}%en{enter service-call} */
		
	/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_FRSM_TSK_E_NOEXS
	if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
	{
		_KERNEL_LEAVE_SVC();		/* %jp{ӥФ}%en{leave service-call} */
		return E_NOEXS;				/* %jp{֥̤} */
	}
#endif
	
	/* %jp{IDֹѴ} */
	tskhdl = _KERNEL_TSK_ID2TSKHDL(tskid);
	
	/* %jp{ȥ֥å} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{֥å}%en{check current state} */
#if _KERNEL_SPT_FRSM_TSK_E_OBJ
	{
		_KERNEL_TSK_T_TSKSTAT tskstat;
		tskstat = _KERNEL_TSK_GET_TSKSTAT(tcb);
		if ( !(tskstat & _KERNEL_TTS_SUS) )
		{
			_KERNEL_LEAVE_SVC();	/* %jp{ӥФ}%en{leave service-call} */
			return E_OBJ;			/* %jp{֥Ⱦ֥顼}%en{Object state error} */
		}
	}
#endif

	/* %jp{ζԤ} */
	_KERNEL_TSK_SET_SUSCNT(tcb, 0);
	_KERNEL_DSP_RSM_TSK(tskhdl);
	
	/* %jp{ǥѥå} */
	_KERNEL_DSP_TSK();
	
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */
	
	return E_OK;
}


#else	/* _KERNEL_SPT_FRSM_TSK */


#if _KERNEL_SPT_FRSM_TSK_E_NOSPT

/** %jp{Ԥ֤ζƳ}%en{Forcibly Resume Suspended Task}
 * @param  tskid    %jp{ƳоݤΥIDֹ}%en{ID number of the task to be resumed}
 * @retval E_NOSPT  %jp{̤ݡȵǽ}%en{Unsupported function}
 */
ER frsm_tsk(
		ID tskid)
{
	return E_NOSPT;
}

#endif


#endif	/* _KERNEL_SPT_FRSM_TSK */



/* end of file */
