/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  wup_tsk.c
 * @brief %jp{ξֻ(ʰ)}%en{}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



/* ξֻ(ʰ) */
ER ref_tst(ID tskid, T_RTST *p_rtst)
{
	_KERNEL_T_TSKHDL		tskhdl;
	_KERNEL_T_TCB_PTR		tcb;
	_KERNEL_T_TCB_RO_PTR	tcb_ro;

	if ( tskid == TSK_SELF )		/* %jp{Ѵ} */
	{
#if _KERNEL_SPT_REF_TST_E_ID
		if ( _KERNEL_SYS_SNS_CTX() )
		{
			return E_ID;		/* %jp{IDֹ} */
		}
#endif	
		/* %jp{¹楿} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();

		_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{ӥ} */
	}
	else
	{
#if _KERNEL_SPT_REF_TST_E_ID
		if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
		{
			return E_ID;	/* %jp{IDֹ} */
		}
#endif
		
		_KERNEL_ENTER_SVC();			/* %jp{enter service-call}%jp{ӥ} */
		
		/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_REF_TST_E_NOEXS
		if ( _KERNEL_TSK_CHECK_EXS(tskid) )
		{
			_KERNEL_LEAVE_SVC();		/* %jp{leave service-call}%jp{ӥФ} */
			return E_NOEXS;				/* %jp{֥̤} */
		}
#endif
		/* IDֹѴ */
		tskhdl = _KERNEL_TSK_ID2TSKHDL(tskid);
	}

	/* %jp{TCB} */
	tcb    = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	tcb_ro = _KERNEL_TSK_GET_TCB_RO(tskid, tcb);
	
	p_rtst->tskstat = _KERNEL_DEC_TTS(_KERNEL_TSK_GET_TSKSTAT(tcb));	/* %jp{} */
	p_rtst->tskwait = _KERNEL_DEC_TTW(_KERNEL_TSK_GET_TSKWAIT(tcb));	/* %jp{Ԥװ} */
	
	
	/* %jp{ʲȼ}%en{HOS extention} */
#if _KERNEL_SPT_RTST_TSKATR
	p_rtst->tskatr  = _KERNEL_TSK_GET_TSKATR(tcb_ro);					/* %jp{°(HOSȼĥ)} */
#endif

#if _KERNEL_SPT_RTST_EXINF
	p_rtst->exinf   = _KERNEL_TSK_GET_EXINF(tcb_ro);					/* %jp{γĥ(HOSȼĥ)} */
#endif

#if _KERNEL_SPT_RTST_TASK
	p_rtst->task    = _KERNEL_TSK_GET_TASK(tcb_ro);						/* %jp{εư(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTST_ITSKPRI
	p_rtst->itskpri = _KERNEL_TSK_GET_ITSKPRI(tcb_ro);					/* %jp{εưͥ(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTST_STKSZ
	p_rtst->stksz   = _KERNEL_TSK_GET_STKSZ(tcb_ro);					/* %jp{åΰΥ(Хȿ)(HOSȼĥ)} */
#endif
#if _KERNEL_SPT_RTST_STK
	p_rtst->stk     = _KERNEL_TSK_GET_STK(tcb_ro);						/* %jp{åΰƬ(HOSȼĥ)} */
#endif


	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */

	return E_OK;
}


/* end of file */
