/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  sta_tsk.c
 * @brief %jp{εư}%en{Activate Task}
 *
 * Copyright (C) 1998-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"



/** %jp{εư(ưɻ)}%en{Start Task}
 * @param  tskid   %en{ID number of the task to be activated}%jp{ID}
 * @return void
 */
ER sta_tsk(
		ID     tskid,
		VP_INT stacd)
{
	_KERNEL_T_TSKHDL       tskhdl;
	_KERNEL_T_TCB          *tcb;
	const _KERNEL_T_TCB_RO *tcb_ro;
	
	if ( tskid == TSK_SELF )		/* %jp{Ѵ} */
	{
#if _KERNEL_SPT_STA_TSK_E_ID
		if ( _KERNEL_SYS_SNS_CTX() )
		{
			return E_ID;		/* %jp{IDֹ} */
		}
#endif
		/* %jp{¹楿} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();
		
		_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{ӥ} */
	}
	else
	{
#if _KERNEL_SPT_STA_TSK_E_ID
		if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
		{
			return E_ID;	/* %jp{IDֹ} */
		}
#endif
		
		_KERNEL_ENTER_SVC();		/* %jp{enter service-call}%jp{ӥ} */
		
		/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_STA_TSK_E_NOEXS
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			_KERNEL_LEAVE_SVC();		/* %jp{leave service-call}%jp{ӥФ} */
			return E_NOEXS;			/* %jp{֥̤} */
		}
#endif
		/* IDֹѴ */
		tskhdl = _KERNEL_TSK_ID2TSKHDL(tskid);
	}
	

	/* %jp{TCB} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);

	/* %jp{֥å} */
#if _KERNEL_SPT_STA_TSK_E_OBJ
	if ( _KERNEL_TSK_GET_TSKSTAT(tcb) != _KERNEL_TTS_DMT )		/* %jp{֥ȾȽ} */
	{
		_KERNEL_LEAVE_SVC();
		return E_OBJ;		/* %jp{} */
	}
#endif

	/* %jp{ֽ} */
	tcb_ro = _KERNEL_TSK_GET_TCB_RO(tskid, tcb);
	_KERNEL_TSK_SET_TSKPRI(tcb, _KERNEL_TSK_GET_ITSKPRI(tcb_ro));
	_KERNEL_TSK_SET_TSKBPRI(tcb, _KERNEL_TSK_GET_ITSKPRI(tcb_ro));
	_KERNEL_TSK_SET_TSKSTAT(tcb, _KERNEL_TTS_RDY);
	_KERNEL_TSK_SET_ACTCNT(tcb, 0);
	_KERNEL_TSK_SET_WUPCNT(tcb, 0);
	_KERNEL_TSK_SET_SUSCNT(tcb, 0);
	
	/* %jp{ƥ} */
	_KERNEL_CRE_CTX(
			_KERNEL_TSK_GET_CTXCB(tcb),					/* %jp{ƥ֥å} */
			_KERNEL_TSK_GET_STKSZ(tcb_ro),				/* %jp{Υåΰ襵} */
			_KERNEL_TSK_GET_STK(tcb_ro),				/* %jp{ΥåΰƬ} */
			(VP)_KERNEL_TSK_GET_ISP(tcb_ro),			/* %jp{åݥ󥿤ν} */
			(FP)_kernel_ent_tsk,						/* %jp{ƥȤγϥɥ쥹} */
			stacd,										/* %jp{γĥ} */
			(VP_INT)_KERNEL_TSK_GET_TASK(tcb_ro)		/* %jp{εư} */
		);
	
	/* %jp{¹Բǽ֤} */
	_KERNEL_DSP_STA_TSK(tskhdl);
	
	/* %jp{ǥѥåμ¹}%en{task dispatch} */
	_KERNEL_DSP_TSK();
	
	
	_KERNEL_LEAVE_SVC();		/* %jp{leave service-call}%jp{ӥФ} */
	
	
	return E_OK;	/*  */
}


/* end of file */
