/** 
 *  Hyper Operating System V4 Advance
 *
 * @file  sus_tsk.c
 * @brief 
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "core/core.h"


#if _KERNEL_SPT_SUS_TSK


ER sus_tsk(
		ID tskid)
{
	_KERNEL_T_TSKHDL      tskhdl;
	_KERNEL_T_TCB         *tcb;
	_KERNEL_TSK_T_TSKSTAT tskstat;

	
	/* %jp{ϥɥ} */
	if ( tskid == TSK_SELF )		/* %jp{Ѵ} */
	{
		/* %jp{¹楿} */
		tskhdl = _KERNEL_SYS_GET_RUNTSK();
		
		_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
	}
	else
	{
#if _KERNEL_SPT_SUS_TSK_E_ID
		if ( !_KERNEL_TSK_CHECK_TSKID(tskid) )
		{
			return E_ID;			/* %jp{IDֹ} */
		}
#endif
	
		_KERNEL_ENTER_SVC();		/* %jp{ӥ}%en{enter service-call} */
		
		/* %jp{֥¸ߥå} */
#if _KERNEL_SPT_SUS_TSK_E_NOEXS
		if ( !_KERNEL_TSK_CHECK_EXS(tskid) )
		{
			_KERNEL_LEAVE_SVC();	/* %jp{ӥФ}%en{leave service-call} */
			return E_NOEXS;			/* %jp{֥̤} */
		}
#endif
		/* IDֹѴ */
		tskhdl = _KERNEL_TSK_ID2TSKHDL(tskid);
	}
	
	
	/* %jp{ƥȥå} */	
#if _KERNEL_SPT_SUS_TSK_E_CTX
		if ( _KERNEL_SYS_GET_RUNTSK() == tskhdl && _KERNEL_SYS_SNS_DPN() )
		{
			_KERNEL_LEAVE_SVC();	/* %jp{ӥФ}%en{leave service-call} */
			return E_CTX;			/* %jp{ƥ} */
		}
#endif
	
	/* %jp{ȥ֥å} */
	tcb = _KERNEL_TSK_TSKHDL2TCB(tskhdl);
	
	/* %jp{ּ} */
	tskstat = _KERNEL_TSK_GET_TSKSTAT(tcb);
	
	
	/* %jp{֥å} */	
#if _KERNEL_SPT_SUS_TSK_E_CTX
	if ( tskstat == _KERNEL_TTS_DMT )
	{
			_KERNEL_LEAVE_SVC();	/* %jp{ӥФ}%en{leave service-call} */
			return E_OBJ;			/* %jp{} */		
	}
#endif
	
	/* %jp{ڥɽ} */
	if ( tskstat & _KERNEL_TTS_SUS )
	{
		_KERNEL_TSK_T_SUSCNT suscnt;
		
		/* %jp{ߤΥڥɥ󥿼} */
		suscnt = _KERNEL_TSK_GET_SUSCNT(tcb);
		
#if _KERNEL_SPT_SUS_TSK_E_QOVR
		if ( suscnt >= _KERNEL_TMAX_SUSCNT )
		{
			_KERNEL_LEAVE_SVC();	/* %jp{ӥФ}%en{leave service-call} */
			return E_QOVR;			/* %jp{塼󥰥Сե} */
		}
#endif

		_KERNEL_TSK_SET_SUSCNT(tcb, suscnt + 1);
	}
	else
	{
		_KERNEL_DSP_SUS_TSK(tskhdl);	/* %jp{ζԤ} */
		
		_KERNEL_DSP_TSK();
	}
	
	_KERNEL_LEAVE_SVC();	/* %jp{ӥ뽪λ} */

	return E_OK;
}


#else	/* _KERNEL_SPT_SUS_TSK */


#if _KERNEL_SPT_SUS_TSK_E_NOSPT

ER sus_tsk(
		ID tskid)
{
	return E_NOSPT;
}

#endif


#endif


/* end of file */
