# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#
# Copyright (C) 1998-2006 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------


# %jp{å̾}
TARGET ?= sample


# %jp{ǥ쥯ȥ}
OS_DIR            = ../../../..
KERNEL_DIR        = $(OS_DIR)/kernel
KERNEL_CFGRTR_DIR = $(OS_DIR)/cfgrtr/build/gcc
KERNEL_MAKINC_DIR = $(KERNEL_DIR)/build/common/gmake
KERNEL_BUILD_DIR  = $(KERNEL_DIR)/build/h8/h8300ha/ch38
OBJS_DIR          = objs_$(TARGET)
KERNEL_CFGRTR     = $(KERNEL_CFGRTR_DIR)/h4acfg-h8300ha

# %jp{ɹ}
include $(KERNEL_MAKINC_DIR)/common.inc


ifeq ($(MEMMAP),ram)
# %jp{RAM¹(˥ץѤ)}
TARGET := $(TARGET)_ram
SECTION_VECT = 0FFC040
SECTION_ROM  = 0FFC140
SECTION_RAM  = 0FFE140
else
SECTION_VECT = 0
SECTION_ROM  = 0100
SECTION_RAM  = 0FFE140
endif

# %jp{ե饰}
CFLAGS  = -CP=300HA -DEBug
AFLAGS  = -CP=300HA -DEBug
LNFLAGS = 


# %jp{ϥե̾}
TARGET_EXE = $(TARGET).$(EXT_EXE)
TARGET_MOT = $(TARGET).$(EXT_MOT)

# %jp{ɸ饤֥}
STD_LIB = stdlib.lib

# %jp{ch38Ѥɹ}
include $(KERNEL_MAKINC_DIR)/ch38_d.inc



# --------------------------------------
#  %jp{ե}
# --------------------------------------

# %jp{ǥ쥯ȥ}
SRC_DIRS += . ..

# %jp{֥եɲ}
ASRCS += ./vcttbl.src		\
         ./startup.src		\


# %jp{Cեɲ}
CSRCS += ./dbsct.c			\
         ../kernel_cfg.c	\
         ../main.c			\
         ../sample.c		\
         ../ostimer.c		\
         ../sci1.c


# %jp{饤֥ɲ}
LIBS  += $(STD_LIB)



# --------------------------------------
#  %jp{롼}
# --------------------------------------

.PHONY : all
all: makeexe_all $(TARGET_EXE) $(TARGET_MOT)


.PHONY : clean
clean: makeexe_clean
	rm -f $(TARGET_EXE) $(TARGET_MOT) $(OBJS) ../kernel_cfg.c ../kernel_id.h


.PHONY : mostlyclean
mostlyclean: clean clean_kernel

$(STD_LIB):
	lbg38 -OUTPut=$(STD_LIB) $(CFLAGS) -REent 

../kernel_cfg.c ../kernel_id.h: ../system.cfg
	cpp -E ../system.cfg ../system.i
	$(KERNEL_CFGRTR) ../system.i -c ../kernel_cfg.c -i ../kernel_id.h


# %jp{¹ԥեɹ}
include $(KERNEL_MAKINC_DIR)/makeexe.inc

# %jp{ch38ѤΥ롼ɹ}
include $(KERNEL_MAKINC_DIR)/ch38_r.inc


# --------------------------------------
#  %jp{¸ط}
# --------------------------------------

$(OBJS_DIR)/sample.$(EXT_OBJ): ../sample.c ../kernel_id.h



# end of file
