# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#
# Copyright (C) 1998-2006 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------

# %jp{å̾}
TARGET ?= sample


# %jp{ġ}
GCC_ARCH   ?= h8300-elf-
CMD_CC     ?= $(GCC_ARCH)gcc
CMD_ASM    ?= $(GCC_ARCH)gcc
CMD_LINK   ?= $(GCC_ARCH)gcc
CMD_OBJCNV ?= $(GCC_ARCH)objcopy


# %jp{ǥ쥯ȥ}
OS_DIR            = ../../../..
KERNEL_DIR        = $(OS_DIR)/kernel
KERNEL_CFGRTR_DIR = $(OS_DIR)/cfgrtr/build/gcc
KERNEL_MAKINC_DIR = $(KERNEL_DIR)/build/common/gmake
KERNEL_BUILD_DIR  = $(KERNEL_DIR)/build/h8/h8300ha/gcc
OBJS_DIR          = objs_$(TARGET)

# %jp{ɹ}
include $(KERNEL_MAKINC_DIR)/common.inc


ifeq ($(MEMMAP),ram)
# %jp{RAM¹(˥ץѤ)}
TARGET := $(TARGET)_ram
LINKER_SCRIPT ?= link_ram.x
C_DEFS        += _RAM
else
# %jp{ROMƤ}
LINKER_SCRIPT ?= link_rom.x
C_DEFS        += 
endif


# %jp{ե饰}
CFLAGS  = -mh
AFLAGS  = -mh
LNFLAGS = -mh -nostartfiles -T$(LINKER_SCRIPT) -Wl,-Map,$(TARGET).map


# %jp{ե졼}
KERNEL_CFGRTR = $(KERNEL_CFGRTR_DIR)/h4acfg-h8300ha

# %jp{ϥե̾}
TARGET_EXE = $(TARGET).$(EXT_EXE)
TARGET_MOT = $(TARGET).$(EXT_MOT)


# %jp{gccѤɹ}
include $(KERNEL_MAKINC_DIR)/gcc_d.inc


# --------------------------------------
#  %jp{ե}
# --------------------------------------

# %jp{ǥ쥯ȥ}
SRC_DIRS += . ..

# %jp{֥եɲ}
ASRCS += ./vector.S			\
         ./crt0.S

# %jp{Cեɲ}
CSRCS += ../kernel_cfg.c	\
         ../main.c			\
         ../sample.c		\
         ../ostimer.c		\
         ../sci1.c

# %jp{饤֥ɲ}
LIBS  +=


# --------------------------------------
#  %jp{롼}
# --------------------------------------

.PHONY : all
all: makeexe_all $(TARGET_EXE) $(TARGET_MOT)


.PHONY : clean
clean: makeexe_clean
	rm -f $(TARGET_EXE) $(TARGET_MOT) $(OBJS) ../kernel_cfg.c ../kernel_id.h


.PHONY : mostlyclean
mostlyclean: clean clean_kernel


../kernel_cfg.c ../kernel_id.h: ../system.cfg
	cpp -E ../system.cfg ../system.i
	$(KERNEL_CFGRTR) ../system.i -c ../kernel_cfg.c -i ../kernel_id.h


# %jp{¹ԥեɹ}
include $(KERNEL_MAKINC_DIR)/makeexe.inc

# %jp{gccѤΥ롼ɹ}
include $(KERNEL_MAKINC_DIR)/gcc_r.inc


# --------------------------------------
#  %jp{¸ط}
# --------------------------------------

$(OBJS_DIR)/sample.$(EXT_OBJ): ../sample.c ../kernel_id.h


# end of file

