# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#  makefile for PC/AT
#
# Copyright (C) 1998-2008 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------


# --------------------------------------
#  %jp{Ƽ}{setting}
# --------------------------------------

# %jp{å̾}%en{target name}
TARGET ?= sample


# %jp{ġ}%en{tools}
GCC_ARCH   ?= i386-elf-
CMD_CC     ?= $(GCC_ARCH)gcc
CMD_ASM    ?= $(GCC_ARCH)gcc
CMD_LINK   ?= $(GCC_ARCH)gcc
CMD_OBJCNV ?= $(GCC_ARCH)objcopy


# %jp{ƥ}%en{architecture}
ARCH_NAME ?= pcat
ARCH_CC   ?= gcc


# %jp{ǥ쥯ȥ}
TOP_DIR           = ../../../..
KERNEL_DIR        = $(TOP_DIR)/kernel
KERNEL_CFGRTR_DIR = $(TOP_DIR)/cfgrtr/build/gcc
KERNEL_MAKINC_DIR = $(KERNEL_DIR)/build/common/gmake
KERNEL_BUILD_DIR  = $(KERNEL_DIR)/build/ia32/pcat/gcc


# %jp{ե졼}
KERNEL_CFGRTR = $(KERNEL_CFGRTR_DIR)/h4acfg-$(ARCH_NAME)


# %jp{ɹ}%jp{common setting}
include $(KERNEL_MAKINC_DIR)/common.inc


# %jp{󥫥ץ}%en{linker script}
LINK_SCRIPT = link.x


# %jp{ѥ}%en{add source directories}
INC_DIRS += . ..
SRC_DIRS += . ..


# %jp{ץե饰}%en{option flags}
AFLAGS  = -march=i386
CFLAGS  = -march=i386
LNFLAGS = -nostartfiles -Wl,-Map,$(TARGET).map,-T$(LINK_SCRIPT)


# %jp{ѥ¸ɹ}%en{compiler dependent definitions}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_d.inc

# %jp{¹ԥեɹ}%en{definitions for exection file}
include $(KERNEL_MAKINC_DIR)/makexe_d.inc


# %jp{ϥե̾}%en{output files}
TARGET_EXE = $(TARGET).$(EXT_EXE)
TARGET_MOT = $(TARGET).$(EXT_MOT)
TARGET_HEX = $(TARGET).$(EXT_HEX)
TARGET_BIN = $(TARGET).$(EXT_BIN)
TARGET_IMG = $(TARGET).img



# --------------------------------------
#  %jp{ե}%en{source files}
# --------------------------------------

# %jp{֥եɲ}%en{assembry sources}
ASRCS += ./crt0.S


# %jp{Cեɲ}%en{C sources}
CSRCS += ../main.c
CSRCS += ../kernel_cfg.c
CSRCS += ../sample.c
CSRCS += ../ostimer.c
CSRCS += ../console.c

# debug
SRC_DIRS += ../../../../aplfw/library/algorithm/stringformat
CSRCS += ../../../../aplfw/library/algorithm/stringformat/stringformat_decimal.c
CSRCS += ../../../../aplfw/library/algorithm/stringformat/stringformat_format.c
CSRCS += ../../../../aplfw/library/algorithm/stringformat/stringformat_formatstring.c
CSRCS += ../../../../aplfw/library/algorithm/stringformat/stringformat_formatstringv.c
CSRCS += ../../../../aplfw/library/algorithm/stringformat/stringformat_formatv.c
CSRCS += ../../../../aplfw/library/algorithm/stringformat/stringformat_hexadecimal.c
CSRCS += ../../../../aplfw/library/algorithm/stringformat/stringformat_nibble.c
CSRCS += ../../../../aplfw/library/algorithm/stringformat/stringformat_string.c



# --------------------------------------
#  %jp{롼}%en{rules}
# --------------------------------------

# %jp{ALL}%en{all}
all: kernel_make makeexe_all ipl.bin $(TARGET_BIN) $(TARGET_HEX) $(TARGET_MOT) $(TARGET).img

# %jp{꡼}%en{clean}
clean: makeexe_clean
	rm -f $(TARGET_BIN) $(TARGET_HEX) $(TARGET_MOT) $(TARGET).img $(OBJS) ../kernel_cfg.c ../kernel_id.h

# %jp{¸ط}%en{depend}
depend: makeexe_depend

# %jp{祳ԡ}%en{source files copy}
.PHONY : srccpy
srccpy: makeexe_srccpy

# %jp{ͥ뤴ȥ꡼}%en{mostlyclean}
.PHONY : mostlyclean
mostlyclean: clean kernel_clean

# %jp{ե졼¹}%en{configurator}
../kernel_cfg.c ../kernel_id.h: ../system.cfg $(KERNEL_CFGRTR)
	cpp -E ../system.cfg ../system.i
	$(KERNEL_CFGRTR) ../system.i -c ../kernel_cfg.c -i ../kernel_id.h


# %jp{IPL}
ipl.bin: $(OBJS_DIR)/ipl.o
	$(GCC_ARCH)ld -Ttext=0x0000 $(OBJS_DIR)/ipl.o -o ipl.out
	$(CMD_OBJCNV) -O binary ipl.out ipl.bin

# %jP{եåԡǥ᡼}%en{FD image}
$(TARGET).img: ipl.bin $(TARGET_BIN)
	./fd_img.pl $(TARGET).img ipl.bin $(TARGET_BIN)

.PHONY : bochs
bochs: $(TARGET).img
	bochs "floppya: 1_44=$(TARGET).img, status=inserted" "boot: a"


# %jp{¹ԥեɹ}%en{rules for exection file}
include $(KERNEL_MAKINC_DIR)/makexe_r.inc

# %jp{ѥ¸Υ롼ɹ}%en{rules for compiler}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_r.inc




# --------------------------------------
#  %jp{¸ط}%en{dependency}
# --------------------------------------

$(TARGET_EXE): $(LINK_SCRIPT)
$(OBJS_DIR)/sample.$(EXT_OBJ): ../sample.c ../kernel_id.h


# end of file

