/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  ostimer.c
 * @brief %jp{OS}%en{OS timer}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "kernel.h"
#include "ostimer.h"
#include "regs_sh7144.h"


#define INHNO_OSTIMER			144							/**< %jp{ߥϥɥֹ} */
#define PERIPHERAL_CLOCK		(24000000UL)				/**< %jp{ڥե륯å(24MHz)} */


static void OsTimer_IrqHandler(void);						/**< %jp{޳ߥϥɥ} */


/** %jp{OSѥ޽롼} */
void OsTimer_Initialize(VP_INT exinf)
{
	T_DINH dfinh;
	
	/* %jp{ߥϥɥ} */
	dfinh.inthdr = (FP)OsTimer_IrqHandler;
	def_inh(INHNO_OSTIMER, &dfinh);
	
	/* %jp{ư} */
	*REG_STANDBY_MSTCR2 &= 0xefff;
	*REG_CMT_CMSTR  &= 0xfffe;								/* %jp{ư} */
	*REG_CMT0_CMCNT  = 0x0000;								/* %jp{󥿥ꥢ} */
	*REG_CMT0_CMCOR  = (PERIPHERAL_CLOCK / 128) / 1000;		/* %jp{1ms} */
	*REG_CMT0_CMCSR  = 0x0042;								/* %jp{128ʬ} */
	*REG_CMT_CMSTR  |= 0x0001;								/* %jp{ư} */
	
	/* %jp{ߵ} */
	*REG_INTC_IPRG = ((*REG_INTC_IPRG & 0xff0f) | 0x0010);
}


/** %jp{޳ߥϥɥ} */
void OsTimer_IrqHandler(void)
{
	*REG_CMT0_CMCSR &= 0xff7f;
	
	isig_tim();
}


/* end of file */
