/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  sample.c
 * @brief %jp{ץץ}%en{Sample program}
 *
 * Copyright (C) 1998-2010 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdlib.h>
#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "sci1.h"
#include "regs_sh7144.h"


#define LEFT(num)	((num) <= 1 ? 5 : (num) - 1)
#define RIGHT(num)	((num) >= 5 ? 1 : (num) + 1)


ID mbxid;
ID mpfid;


/*const VP _kernel_int_isp = (VP)0xfffffff0;*/


/* void sim_puts(void *addr); */



/** %jp{å¤} */
typedef struct t_print_msg
{
	T_MSG msg;
	char  text[32];
} T_PRINT_MSG;


/** %jp{ϥɥ} */
void Sample_Initialize(VP_INT exinf)
{
	T_CMPF cmpf;
	T_CMBX cmbx;
	
	/* %jp{ϡɥͭ} */
	*REG_STANDBY_MSTCR1 &= ~0x0002;	/* %jp{SCI1ΥХ⡼ɤ} */
	*REG_PFC_PACRL2 |= 0x0100;		/* %jp{ü} */
	*REG_INTC_IPRF = ((*REG_INTC_IPRF & 0xfff0) | 0x0001);
	
	/* %jp{SCI1ν} */
	Sci1_Initialize();
	
	/* %jp{Ĺס} */
	cmpf.mpfatr = TA_TFIFO;					
	cmpf.blkcnt = 3;						
	cmpf.blksz  = sizeof(T_PRINT_MSG);		
	cmpf.mpf    = NULL;						
	mpfid = acre_mpf(&cmpf);
	
	/* %jp{᡼ܥå} */
	cmbx.mbxatr  = TA_TFIFO | TA_TFIFO;		
	cmbx.maxmpri = 1;						
	cmbx.mprihd  = NULL;					
	mbxid = acre_mbx(&cmbx);
	
	/* %jp{ư} */
	act_tsk(TSKID_PRINT);
	act_tsk(TSKID_SAMPLE1);
	act_tsk(TSKID_SAMPLE2);
	act_tsk(TSKID_SAMPLE3);
	act_tsk(TSKID_SAMPLE4);
	act_tsk(TSKID_SAMPLE5);
}


/** %jp{ŬʻԤ} */
void rand_wait(void)
{
	dly_tsk(rand() % 1000 + 100);	
}


/** %jp{ɽ} */
void print_state(int num, char *text)
{
	T_PRINT_MSG *msg;
	VP  mem;
	
	/* %jp{} */
	get_mpf(mpfid, &mem);
	msg = (T_PRINT_MSG *)mem;

	/* %jp{ʸ} */
	msg->text[0] = '0' + num;
	msg->text[1] = ' ';
	msg->text[2] = ':';
	msg->text[3] = ' ';
	strcpy(&msg->text[4], text);
	strcat(msg->text, "\n");
	
	/* %jp{ɽ} */
	snd_mbx(mbxid, (T_MSG *)msg);
}


/** %jp{ץ륿} */
void Sample_Task(VP_INT exinf)
{
	int  num;
	
	num = (int)exinf;
	
	print_state(num, "start");
	
	/* %jp{ůؼԤο} */
	for ( ; ; )
	{
		/* %jp{Ŭʻֹͤ} */
		print_state(num, "thinking");
		rand_wait();
		
		/* %jp{Υեޤǥ롼} */
		for ( ; ; )
		{
			/* %jp{˼} */
			wai_sem(LEFT(num));
			if ( pol_sem(RIGHT(num)) == E_OK )
			{
				break;	/* %jp{ξ줿} */
			}
			sig_sem(LEFT(num));	/* %jp{ʤΥ} */
			
			/* %jp{ŬʻԤ} */
			print_state(num, "hungry");
			rand_wait();
			
			/* %jp{˼} */
			wai_sem(RIGHT(num));
			if ( pol_sem(LEFT(num)) == E_OK )
			{
				break;	/* %jp{ξ줿} */
			}
			sig_sem(RIGHT(num));	/* %jp{ʤΥ} */
			
			/* %jp{ŬʻԤ} */
			print_state(num, "hungry");
			rand_wait();
		}
		
		/* %jp{Ŭʻ֡٤} */
		print_state(num, "eating");
		rand_wait();
		
		/* %jp{ե֤} */
		sig_sem(LEFT(num));
		sig_sem(RIGHT(num));
	}
}


/** %jp{ɽ} */
void Sample_Print(VP_INT exinf)
{
	T_PRINT_MSG *msg;
	
	Sci1_Initialize();
	
	for ( ; ; )
	{
		rcv_mbx(mbxid, (T_MSG **)&msg);
		Sci1_PutString(msg->text);
		rel_mpf(mpfid, msg);
	}
}



/* end of file */
