# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#  makefile for sh2-sample
#
# Copyright (C) 1998-2006 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------



# --------------------------------------
#  %jp{Ƽ}{setting}
# --------------------------------------

# %jp{å̾}%en{target name}
TARGET ?= sample


# %jp{ġ}%en{tools}
GCC_ARCH   ?= 
CMD_CC     ?= $(GCC_ARCH)gcc
CMD_ASM    ?= $(GCC_ARCH)gcc
CMD_LINK   ?= $(GCC_ARCH)gcc
CMD_OBJCNV ?= $(GCC_ARCH)objcopy


# %jp{ĥ}%en{file extention}
EXT_EXE = exe


# %jp{ƥ}%en{architecture}
ARCH_NAME ?= win32
ARCH_CC   ?= gcc


# %jp{ǥ쥯ȥ}%en{directories}
TOP_DIR           = ../../../..
KERNEL_DIR        = $(TOP_DIR)/kernel
KERNEL_MAKINC_DIR = $(KERNEL_DIR)/build/common/gmake
KERNEL_BUILD_DIR  = $(KERNEL_DIR)/build/win/win32/gcc
KERNEL_CFGRTR_DIR = $(TOP_DIR)/cfgrtr/build/gcc


# %jp{ե졼}
KERNEL_CFGRTR = $(KERNEL_CFGRTR_DIR)/h4acfg-$(ARCH_NAME)


# %jp{ɹ}%jp{common setting}
include $(KERNEL_MAKINC_DIR)/common.inc


# %jp{ѥ}%en{add source directories}
INC_DIRS += . ..
SRC_DIRS += . ..


# %jp{ץե饰}%en{option flags}
AFLAGS   = 
CFLAGS   = 
LNFLAGS  = 
LNFLAGS2 = -lwinmm


# %jp{ѥ¸ɹ}%en{compiler dependent definitions}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_d.inc

# %jp{¹ԥեɹ}%en{definitions for exection file}
include $(KERNEL_MAKINC_DIR)/makexe_d.inc


# %jp{ϥե̾}%en{output files}
TARGET_EXE = $(TARGET).$(EXT_EXE)



# --------------------------------------
#  %jp{ե}%en{source files}
# --------------------------------------


# --------------------------------------
#  %jp{ե}%en{source files}
# --------------------------------------

# %jp{֥եɲ}%en{assembry sources}
ASRCS += 


# %jp{Cեɲ}%en{C sources}
CSRCS += ../kernel_cfg.c
CSRCS += ../main.c
CSRCS += ../sample.c
CSRCS += ../ostimer.c
CSRCS += ../wintimer.c


# %jp{饤֥ɲ}%en{libraries}
LIBS += 



# --------------------------------------
#  %jp{롼}%en{rules}
# --------------------------------------


# %jp{ALL}%en{all}
.PHONY : all
all: makeexe_all $(TARGET_EXE)

# %jp{꡼}%en{clean}
clean: makeexe_clean
	rm -f $(TARGET_EXE) $(TARGET_EXE) $(OBJS) ../kernel_cfg.c ../kernel_id.h

# %jp{¸ط}%en{depend}
.PHONY : depend
depend: makeexe_depend

# %jp{祳ԡ}%en{source files copy}
.PHONY : srccpy
srccpy: makeexe_srccpy

# %jp{ͥ뤴ȥ꡼}%en{mostlyclean}
.PHONY : mostlyclean
mostlyclean: clean kernel_clean

# %jp{ե졼¹}%en{configurator}
../kernel_cfg.c ../kernel_id.h: ../system.cfg
	cpp -E ../system.cfg ../system.i
	$(KERNEL_CFGRTR) ../system.i -c ../kernel_cfg.c -i ../kernel_id.h


# %jp{¹ԥեɹ}%en{rules for exection file}
include $(KERNEL_MAKINC_DIR)/makexe_r.inc

# %jp{ѥ¸Υ롼ɹ}%en{rules for compiler}
include $(KERNEL_MAKINC_DIR)/$(ARCH_CC)_r.inc




# --------------------------------------
#  %jp{¸ط}
# --------------------------------------

$(OBJS_DIR)/sample.$(EXT_OBJ): ../sample.c ../kernel_id.h


# end of file

