/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  sample.c
 * @brief %jp{ץץ}%en{Sample program}
 *
 * Copyright (C) 1998-2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */

#include <stdlib.h>
#include <string.h>
#include "kernel.h"
#include "kernel_id.h"
#include "uart.h"



/** %jp{ϥɥ} */
void Sample_Initialize(VP_INT exinf)
{
	/* %jp{UART} */
	Uart_Initialize();

	/* %jp{ư} */
	act_tsk(TSKID_WAIT);
	act_tsk(TSKID_SIGNAL);
}


/** %jp{} */
int GetRand(void)
{
	int r;

	wai_sem(SEMID_RAND);
	r = rand();
	sig_sem(SEMID_RAND);
	
	return r;
}



/** %jp{Ԥ} */
void Sample_WaitTask(VP_INT exinf)
{
	TMO	tmo;
	ER	ercd;

	for ( ; ; )
	{
		/* Ԥ֤ */
		tmo = GetRand() % 5;
		
		/* Ԥ */
		ercd = twai_sem(SEMID_TEST, tmo);
		switch ( ercd )
		{
		case E_OK:
			Uart_PutString("OK\n");
			break;
		
		case E_TMOUT:
			Uart_PutString("TMOUT\n");
			break;

		default:
			Uart_PutString("error!\n");
			for ( ; ; ) ;
		}
	}
}


/** %jp{sig_sem} */
void Sample_SignalTask(VP_INT exinf)
{
	RELTIM tim;
	
	for ( ; ; )
	{
		tim = GetRand() % 5;
		dly_tsk(tim);
		
		sig_sem(SEMID_TEST);
	}
}



/* end of file */
