/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4 Tiny  ITRON4.0 Real-Time OS             */
/*    ͥ¸إå                                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2003 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4T__kernel_h__
#define __HOS_V4T__kernel_h__


#include "itron.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* ƥξ */
#define KERNEL_TSS_TSK		0x00				/* ¹ */
#define KERNEL_TSS_INDP		0x04				/* Ω¹ */
#define KERNEL_TSS_DDSP		0x01				/* ǥѥåػ (dis_dsp ͭ) */
#define KERNEL_TSS_DINT		0x02				/* ߶ػ(loc_cpu ͭ) */


/* 塼󥰡ͥȲκ */
#define TMAX_ACTCNT			0					/* ư׵ᥭ塼󥰿κ */
#define TMAX_WUPCNT			127					/* ׵ᥭ塼󥰿κ */
#define TMAX_SUSCNT			0					/* Ԥ׵ͥȿκ */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */


/* ƥȾ¸֥å */
typedef struct t_hos_pac_ctxinf
{
	VP sp;			/* åݥ¸ΰ */
} T_HOSPAC_CTXINF;


/* 塼֥å */
typedef struct t_kernel_que
{
	ID    head;					/* 塼ƬΥID */
} T_KERNEL_QUE;


/* ȥ֥å */
typedef struct t_kernel_tcb
{
	T_HOSPAC_CTXINF ctxinf;		/* ƥȾ¸֥å */
	T_KERNEL_QUE    *que;		/* ³Ƥ륭塼 */
	PRI   tskpri;				/* ߤͥ */
	ID    next;					/* Υ */
	ID    prev;					/* Υ */
	UB    wupcnt;				/* ׵ᥭ塼󥰿 */
	FP    task;					/* εư */
	VP    isp;					/* åݥ */
} T_KERNEL_TCB;


/* ޥեȥ֥å */
typedef struct t_kernel_semcb
{
	T_KERNEL_QUE que;			/* ޥեԤ塼 */
	UB           semcnt;		/* ޥեλ񸻿 */
} T_KERNEL_SEMCB;


/* ٥ȥե饰ȥ֥å */
typedef struct t_kernel_flgcb
{
	ID     tskid;		/* ե饰ԤΥID */
	FLGPTN flgptn;		/* ٥ȥե饰Υӥåȥѥ */
	MODE   wfmode;		/* Ԥ⡼ */
	FLGPTN waiptn;		/* Ԥӥåȥѥʲѥȷ) */
	FLGPTN *p_flgptn;	/* ե饰ѥǼɥ쥹 */
} T_KERNEL_FLGCB;


/* ߥϥɥ */
typedef struct t_kernel_intcb
{
	FP    	isr;		/* ϥɥεư */
	VP_INT	exinf;
} T_KERNEL_INTCB;


/* ƥ */
typedef struct t_kernel_sys
{
    T_HOSPAC_CTXINF ctxinf_idle;	/* ɥ륳ƥ */
	T_KERNEL_QUE    rdyque;			/* ǥ塼 */
	UB              tskid_run;		/* ¹楿ID */
	UB              stat;			/* ƥΥƥȾ */
	UB              dly_dsp;		/* ٱ䤷Ƥǥѥå뤫 */
} T_KERNEL_SYS;



/* ---------------------------------- */
/*        Хѿ          */
/* ---------------------------------- */


extern FP             kernel_irq_tbl[];			/* ߥϥɥơ֥ */
extern T_KERNEL_TCB   kernel_tcb_tbl[];			/* ȥ֥åơ֥ */
extern T_KERNEL_SEMCB kernel_semcb_tbl[];		/* ޥեȥ֥åơ֥ */
extern T_KERNEL_FLGCB kernel_flgcb_tbl[];		/* ե饰ȥ֥åơ֥ */
extern const T_KERNEL_INTCB kernel_intcb_tbl[];		/* ߥϥɥ饳ȥ֥åơ֥ */


/* ---------------------------------- */
/*            ޥ              */
/* ---------------------------------- */

/* ȥ֥åơ֥0ܤǤ˥ƥŤͤ */
#define kernel_sys		(*((T_KERNEL_SYS*)(&kernel_tcb_tbl[0])))		/* 0ܤidleŤʤ */

/* ƥ */
#define KERNEL_SET_RUN_TSKID(tskid)	(kernel_sys.tskid_run = tskid)		/* ¹楿ID */
#define KERNEL_GET_RUN_TSKID()		(kernel_sys.tskid_run)				/* ¹楿IDμ */
#define KERNEL_GET_RDYQUE()			(&kernel_sys.rdyque)				/* ǥ塼μ */


#define KERNEL_GET_TCB(tskid)		(&kernel_tcb_tbl[tskid])			/* IDTCBɥ쥹 */
#define KERNEL_GET_SEMCB(semid)		(&kernel_semcb_tbl[(semid) - 1])	/* ޥեIDSEMCBɥ쥹 */
#define KERNEL_GET_FLGCB(flgid)		(&kernel_flgcb_tbl[(flgid) - 1])	/* ޥեIDFLGCBɥ쥹 */
#define KERNEL_GET_INTCB(intno)		(&kernel_intcb_tbl[(intno)])	/* ֹ椫INTCBɥ쥹 */

/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* ץåݲ */
void    hospac_dis_int(void);								/* ߶ػ */
void    hospac_ena_int(void);								/* ߵ */
void    hospac_cre_ctx(T_HOSPAC_CTXINF *pk_ctxinf,
						VP sp, FP task, VP_INT exinf);		/* ¹ԥƥȤκ */
void    hospac_swi_ctx(T_HOSPAC_CTXINF *pk_pre_ctxinf,
						T_HOSPAC_CTXINF *pk_nxt_ctxinf);	/* ¹ԥƥȤ */
#define hospac_idle()										/* ɥ */


/* 塼 */
void    kernel_add_que(T_KERNEL_QUE *que, ID tskid);		/* ͥٽǥ塼ɲ */
void    kernel_rmv_que(ID tskid);							/* 򥭥塼 */
#define kernel_ref_qhd(que)	((que)->head)					/* 塼Ƭλ(ޥؿ) */

void    kernel_exe_dsp(void);								/* ǥѥåμ¹ */

/* ƥ */
#define kernel_loc_sys()	hospac_dis_int()				/* ƥΥå */
#define kernel_unl_sys()	hospac_ena_int()				/* ƥΥå */


/* ե졼 */
void    hoscfg_ini(void);


/* ͥ륷ƥ */
ER      sta_hos(void);										/* ͥư */


/* ǽ */
ER      sta_tsk(ID tskid, VP_INT stacd);					/* εư(ưɻ) */
void    ext_tsk(void);										/* νλ */
ER      chg_pri(ID tskid, ID tskpri);						/* ͥ٤ѹ */
ER      get_pri(ID tskid, PRI *p_tskpri);					/* ͥ٤λ */


/* °Ʊǽ */
ER      slp_tsk(void);										/* εԤ */
ER      wup_tsk(ID tskid);									/* ε */
#define	iwup_tsk	wup_tsk									/* ε(󥿥ƥѥޥ) */
ER_UINT can_wup(ID tskid);									/* ׵Υ󥻥 */

/* ޥե */
ER      sig_sem(ID semid);									/* ޥե񸻤ֵ */
#define isig_sem sig_sem									/* ޥե񸻤ֵ(󥿥ƥѥޥ) */
ER      wai_sem(ID semid);									/* ޥե񸻤γ */
ER      pol_sem(ID semid);									/* ޥե񸻤γ(ݡ) */

/* ٥ȥե饰 */
ER      set_flg(ID flgid, FLGPTN setptn);					/* ٥ȥե饰Υå */
#define iset_flg	set_flg									/* ٥ȥե饰Υå(󥿥ƥѥޥ) */
ER      clr_flg(ID flgid, FLGPTN clrptn);					/* ٥ȥե饰Υꥢ */
ER      wai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn);
															/* ٥ȥե饰Ԥ */
ER      pol_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn);
															/* ٥ȥե饰Ԥ(ݡ) */
BOOL    kernel_chk_flg(T_KERNEL_FLGCB *flgcb);


#ifdef __cplusplus
}
#endif



#endif /* __HOS_V4T__kernel_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2003 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
