; --------------------------------------------------------------------------- 
;  Hyper Operating System V4 Tiny ITRON4.0 Real-Time OS                 
;    ץåݲݡͥ (ARM Thumb⡼)                       
;    ƥ                                                         
;                                                                             
;                                     Copyright (C) 1998-2003 by Project HOS  
;                                     http://sourceforge.jp/projects/hos/     
; --------------------------------------------------------------------------- 


				INCLUDE	pacarm.inc

				EXPORT	hospac_dis_int		; ߶ػ
				EXPORT	hospac_ena_int		; ߵ
				EXPORT	hospac_cre_ctx		; ¹ԥƥȤκ
				EXPORT	hospac_swi_ctx		; ¹ԥƥȤ

				CODE16

				AREA	code, CODE, READONLY


; -----------------------------------------------
;  ߶ػ
;  void hospac_dis_int(void)
; -----------------------------------------------
hospac_dis_int
				mov		r0, #1			; Zե饰ݤ
				adr		r0, ctl_int_32
				bx		r0

; -----------------------------------------------
;  ߵ
;  void hospac_ena_int(void)
; -----------------------------------------------
hospac_ena_int
				mov		r0, #0			; Zե饰ΩƤ
				adr		r0, ctl_int_32
				bx		r0


				ALIGN
				CODE32
ctl_int_32
				mrs		r0, cpsr
				biceq	r0, r0, #I_Bit
				orrne	r0, r0, #I_Bit
				msr 	cpsr_cf, r0
				bx		lr
				CODE16


; -----------------------------------------------
;  ¹ԥƥȥȥ꡼ɥ쥹
; -----------------------------------------------
				IMPORT	ext_tsk
ctx_entry	
				bl		hospac_ena_int	; ߵ
				mov		a1, v2			; ¹Իѥ᡼
				ldr		r0, =ext_tsk	; ꥿󥢥ɥ쥹
				mov		lr, r0
				bx		v1				; ¹ԥɥ쥹ʬ


; -----------------------------------------------
;  ¹ԥƥȤκ
;  void hospac_cre_ctx(
;		T_HOSPAC_CTXINF *pk_ctxinf,	/* 륳ƥ */
;		VP     sp,					/* åݥ */
;		void   (*task)(VP_INT),		/* ¹ԥɥ쥹 */
;		VP_INT exinf				/* ¹Իѥ᡼ */
;		)
; -----------------------------------------------
hospac_cre_ctx
				sub		a2, #20			; å
				str		a3, [a2, #0]	; v1 ʬ˼¹ԥɥ쥹
				str		a4, [a2, #4]	; v2 ʬ˼¹Իѥ᡼
				ldr		a3, =ctx_entry
				str		a3, [a2, #16]	; lr ʬ˥ȥ꡼ɥ쥹
				str		a2, [a1]		; ƥȤȤ sp ¸
				bx		lr				; ꥿


; -----------------------------------------------
;  ¹ԥƥȤ
;  void hospac_swi_ctx(
;		T_HOSPAC_CTXINF *pk_pre_ctxinf,	/* ߤΥƥȤ¸ */
;		T_HOSPAC_CTXINF *pk_nxt_ctxinf	/* ڤؤ륳ƥ */
;		)
; -----------------------------------------------
hospac_swi_ctx
				push	{v1-v4, lr}			; 쥸¸
				mov		v1, sp
				str		v1, [a1]			; åݥ¸
				ldr		v1, [a2]			; åݥ
				mov		sp, v1
				pop		{v1-v4, pc}			; 쥸꥿

				END



; --------------------------------------------------------------------------- 
;  Copyright (C) 1998-2003 by Project HOS                                     
; --------------------------------------------------------------------------- 
