/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4 Tiny  ITRON4.0 Real-Time OS             */
/*    ITRONͥ ٥ȥե饰                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2003 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "kernel.h"



/* ٥ȥե饰Ԥ */
ER wai_flg(
		ID     flgid,		/* ԤоݤΥ٥ȥե饰IDֹ */
		FLGPTN waiptn,		/* Ԥӥåȥѥ */
		MODE   wfmode,		/* Ԥ⡼ */
		FLGPTN *p_flgptn)	/* ԤΥӥåȥѥǼɥ쥹 */
{
	T_KERNEL_FLGCB *flgcb;
	ID             tskid;

	kernel_loc_sys();	/* ƥΥå */
	
	flgcb = KERNEL_GET_FLGCB(flgid);
	
	/* Ԥ */
	flgcb->waiptn = waiptn;
	flgcb->wfmode = wfmode;
	
	/* ե饰å */
	if ( kernel_chk_flg(flgcb) )
	{
		/* ˾Ƥʤ */
		if ( p_flgptn != NULL )
		{
			*p_flgptn = flgcb->flgptn;		/* Υե饰ѥǼ */
		}
	}
	else
	{
		/* ƤʤԤ */
		tskid           = KERNEL_GET_RUN_TSKID();	/* ¹楿IDμ */
		flgcb->tskid    = tskid;					/* ԤϿ */
		flgcb->p_flgptn = p_flgptn;					/*  ԤΥӥåȥѥǼɥ쥹¸ */
		kernel_rmv_que(tskid);						/* ǥ塼곰 */
		
		/* ǥѥå¹ */
		kernel_exe_dsp();
	}
	
	kernel_unl_sys();	/* ƥΥå */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2003 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
