/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4 Tiny  ITRON4.0 Real-Time OS             */
/*    ITRONͥ ޥե                                                */
/*                                                                          */
/*                                  Copyright (C) 1998-2003 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "kernel.h"



/* ޥե񸻤γ */
ER wai_sem(
		ID semid)	/* 񸻳оݤΥޥեIDֹ */
{
	T_KERNEL_SEMCB *semcb;
	ID             tskid;

	kernel_loc_sys();	/* ƥΥå */
	
	semcb = KERNEL_GET_SEMCB(semid);
	
	/* ޥե񸻤Ǥ */
	if ( semcb->semcnt > 0 )
	{
		semcb->semcnt--;	/* ޥե񸻤γ */
	}
	else
	{
		/* ¹楿IDμ */
		tskid = KERNEL_GET_RUN_TSKID();

		/* Ԥ֤ˤ */
		kernel_rmv_que(tskid);					/* ǥ塼곰 */
		kernel_add_que(&semcb->que, tskid);		/* ޥեԤɲ */
		
		/* ǥѥåμ¹ */
		kernel_exe_dsp();
	}
		
	kernel_unl_sys();		/* ƥΥå */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2003 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
