/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4 Tiny  ITRON4.0 Real-Time OS             */
/*    ITRONͥ ǽ                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2003 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "kernel.h"




/* ͥ٤ѹ */
ER chg_pri(
		ID  tskid,		/* ѹоݤΥIDֹ */
		PRI tskpri)		/* ѹΥ١ͥ */
{
	T_KERNEL_TCB *tcb;
	T_KERNEL_QUE *que;

	kernel_loc_sys();	/* ƥΥå */
	
	/* ʤ */
	if ( tskid == TSK_SELF )
	{
		tskid = KERNEL_GET_RUN_TSKID();		/* ¹楿IDμ */
	}
	
	/* TCB */
	tcb = KERNEL_GET_TCB(tskid);

	/* 塼 */
	que = tcb->que;
	
	/* ͥѹ */
	tcb->tskpri = tskpri;
	if ( que != NULL )		/* 塼˷ҤäƤʤ */
	{
		kernel_rmv_que(tskid);			/* 塼ö */
		kernel_add_que(que, tskid);		/* 塼˷Ҥľ */
	}
		
	/* ǥѥåμ¹ */
	kernel_exe_dsp();
	
	kernel_unl_sys();	/* ƥΥå */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2003 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
