//
// CMusicList : ȃXgǗNX
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

/*
	WaitForSingleObject̐

	EBhE쐬Xbhł́AWaitForSingleObject ֐ł͂ȂA
	MsgWaitForMultipleObjects ܂ MsgWaitForMultipleObjectsEx ֐gĂB

	ƂĂ邯ǁc܂蒷Ԃ͑҂ȂvƎv

	̃NXɈڍsADDR.cpp
		SearchMusic
		LoadHeader
		Load/SaveCache
		MakeJukeBox
	͍폜Bł
		LoadBMSHeader
		LoadMSDData
	폜ǁAƃO[oϐւ̈ˑ

*/

#include "CMusicList.h"
#include <algorithm>

extern void WriteLog(const char* Format,...);
extern int  CheckType(const char* szFileName);
extern BOOL LoadHeader(string path, MUSIC_DATA* lpHeader); // VJukeBoxp
extern int  GetLine(FILE* fp, char* str, int max);

CMusicList::CMusicList()
{
	m_ScanThreadHandle = NULL;
	m_UpdateThreadHandle = NULL;
	m_SaveCache = TRUE;
}

CMusicList::~CMusicList()
{
	// XbhĂI
	// IOɃoϐ̃肵Ȃ悤
	if(m_ScanThreadHandle!=NULL)
	{
		// Iw
		m_ScanThreadEnd.Signal();

		// I҂
		WaitForSingleObject(m_ScanThreadHandle, INFINITE);

		CloseHandle(m_ScanThreadHandle);
		m_ScanThreadHandle = NULL;
	}

	if(m_UpdateThreadHandle!=NULL)
	{
		// Iw
		m_UpdateCheckThreadEnd.Signal();

		// I҂
		WaitForSingleObject(m_UpdateThreadHandle, INFINITE);

		CloseHandle(m_UpdateThreadHandle);
		m_UpdateThreadHandle = NULL;
	}
}

BOOL CMusicList::StartBGScan(void)
{
	if(size()==0)
		return FALSE;

	if(m_ScanThreadHandle==NULL)
	{
		// ߂ČĂ΂ꂽ̂ŃXbh쐬
runThread:
		unsigned int threadDesc;
		m_ScanThreadHandle = (HANDLE)_beginthreadex(NULL, 0, ScanThread, this, 0, &threadDesc);
		if(m_ScanThreadHandle==0)
		{
			WriteLog("CMusicList::StartBGScan() : obOOEhXLXbh̍쐬Ɏs");
			return FALSE;
		}
	}
	else
	{
		// ɃXbh
		// I`FbN
		if(WaitForSingleObject(m_ScanThreadHandle, 0) == WAIT_OBJECT_0)
		{
			// Xbh͊ɏIĂ̂ōċN
			CloseHandle(m_ScanThreadHandle);
			m_ScanThreadHandle = NULL;
			goto runThread;
		}
		else
		{
			// Xbh͂܂Ă̂ōăX^[gVOi

			// I`FbŇ̃XLɃXbhIƂ܂Ȃ
			// {IɃXbh͏IȂvƎv

			if(m_ScanStopping.Wait(0)) // ꎞ~Ȃ
			{
				if(m_ScanStartEvent.Signal()) // ăX^[gw
				{
					// ҂
					while(m_ScanStopping.Wait(0)) // ~̊ԑ҂X^[g܂ő҂
						Sleep(1);
				}
			}
		}
	}

	return TRUE;
}

BOOL CMusicList::StopBGScan(void)
{
	if(m_ScanThreadHandle==NULL)
	{
		// XbhȂ
		return FALSE;
	}
	else
	{
		// XbĥőĂXgbvVOi
		if(!m_ScanStopping.Wait(0)) // ꎞ~łȂ
		{
			if(m_ScanStopEvent.Signal()) // ~w
			{
				// ҂
				while(!m_ScanStopping.Wait(0)) // ~łȂԑ҂~܂ő҂
					Sleep(1);

				return TRUE;
			}
			else
				return FALSE;
		}

		return TRUE;
	}

}

BOOL CMusicList::IsBGScanStopping(void)
{
	if(m_ScanThreadHandle==NULL)
	{
		// XbhȂ
		return TRUE;
	}
	else
		return m_ScanStopping.Wait(0);
}

BOOL CMusicList::SetNextScanTarget(DWORD targetJuke, DWORD targetDataSet)
{
	// ͈̓`FbN
	if(targetJuke >= size())
		return FALSE;

	if(targetDataSet >= m_JukeBoxes[targetJuke].size())
		return FALSE;

	// signalƂɂXbhQƂȂAsv
	m_ChangeTargetJuke = targetJuke;
	m_ChangeTargetDataSet = targetDataSet;

	if(m_ChangeNextFileEvent.Signal())
	{
		// ҂
//		m_ChangeNextFileEvent.Wait(INFINITE);
		return TRUE;
	}
	else
		return FALSE;
}

// XgbvVOiƂɂWinMaiñXbhIĂƂ
// bWCu̓삪ۏ؂ȂȂ
#define WriteLogMT	if(!lpML->m_ScanThreadEnd.Wait(0)) WriteLog

unsigned __stdcall CMusicList::ScanThread(void* lpMusicList)
{
	CMusicList* lpML = (CMusicList*)lpMusicList;
	if(lpML==NULL)
		return 1;

	if(lpML->m_JukeBoxes.size()==0)
	{
		return 2;
	}

	// C[v
/*	
	ӖƂ
	for(DWORD i=0;i < lpML->m_JukeBoxes.size();i++)
	{
		for(DWORD j=0;j < lpML->m_JukeBoxes[i].size();j++)
		{
			for(DWORD k=0;k < lpML->m_JukeBoxes[i][j].size();k++)
			{
				// ǂݍ
				// ~AIVOi`FbN
			}
		}
	}
	Cfg炷ɌɂȂBǂ}VȂ
*/

	if(lpML->m_ScanStopping.Wait(0))
		lpML->m_ScanStopping.UnSignal();

	WriteLogMT("CMusicList::ScanThread() : obNOEhXLJn܂");
//	WriteLogMT("CMusicList::ScanThread() : %d JukeBoxes", lpML->m_JukeBoxes.size());

	DWORD i=0, j=0, k=0;
	BOOL posChanged = FALSE; // XLɏꏊύXꂽBĂ
	while(1)
	{
		// ꎞ~߂`FbN
		if(lpML->m_ScanStopEvent.Wait(0))
		{
			// Xbhꎞ~
			lpML->m_ScanStopEvent.UnSignal();

			lpML->m_ScanStopping.Signal();

			while(1)
			{
				// ăX^[gȂAIȂ̃VOi҂
				if(lpML->m_ScanStartEvent.Wait(500))
				{
					// ăX^[gVOi
					WriteLogMT("CMusicList::ScanThread() : ăX^[g܂");
					lpML->m_ScanStartEvent.UnSignal();
					break;
				}

				if(lpML->m_ScanThreadEnd.Wait(50))
				{
					// XbhIVOi
					WriteLogMT("CMusicList::ScanThread() : XLXbhI܂");
					lpML->m_ScanThreadEnd.UnSignal();
					goto goodbye;
				}

			}

			if(lpML->m_ScanStopEvent.Wait(0))
			{
				// ~ɂɒ~Ȃ[
				lpML->m_ScanStopEvent.UnSignal();
			}

			lpML->m_ScanStopping.UnSignal();
		}

		// I߂`FbN
		if(lpML->m_ScanThreadEnd.Wait(0))
		{
			// XbhIVOi
			WriteLogMT("CMusicList::ScanThread() : XLXbhI܂");
			lpML->m_ScanThreadEnd.UnSignal();
			goto goodbye;
		}

		// XLʒuύX߂`FbN
		if(lpML->m_ChangeNextFileEvent.Wait(0))
		{
			i = lpML->m_ChangeTargetJuke;
			j = lpML->m_ChangeTargetDataSet;
			k = 0;
			posChanged = TRUE;

			lpML->m_ChangeNextFileEvent.UnSignal();
		}

		// Pȓǂݍ
		BOOL read;
		lpML->m_JukeBoxes[i].Lock();
			assert(lpML->m_JukeBoxes[i][j].size()!=0);
			read = lpML->m_JukeBoxes[i][j][k].bRead;
		lpML->m_JukeBoxes[i].UnLock();
		if(!read)
		{
			// ܂ǂłȂwb_
			// ǂ݂ɂcLock̎ԂŏɂƂȂ
			MUSIC_DATA temp;
			string fullpath;

			lpML->m_JukeBoxes[i].Lock();
			{
				fullpath = lpML->GetFullPath(i, j, k);
				temp = lpML->m_JukeBoxes[i][j][k];
			}
			lpML->m_JukeBoxes[i].UnLock();

			//temp.msdDiff = SINGLE + BASIC; // ՓxΉBb菈u
			LoadHeader(fullpath, &temp);

			temp.bRead = TRUE;

			lpML->m_JukeBoxes[i].Lock();
			{
				lpML->m_JukeBoxes[i][j][k] = temp;
			}
			lpML->m_JukeBoxes[i].UnLock();

//			WriteLogMT("Header[%d][%d][%d] read", i, j, k);

			// Ԃ邩A60FPS邩 SleepȂłӊOƕ׌ylq
			// Sleep(5)łQ{炢Ԃ
			// Sleep(5);
		}
		else
		{
			// ɓǂłwb_
			//Sleep(1);
		}

		// JE^CNg
		k++;
		if(k >= lpML->m_JukeBoxes[i][j].size())
		{
			// Pf[^Zbg

			// f[^Zbg̃^CǧB
			// Ƃ肠蔲B̂Ȗ̋ʕƂ؂o
			lpML->m_JukeBoxes[i].Lock();
			{
				// Nak̊]𖞂AtH_hbvċNƂɋ󗓂ɂȂȂ悤
				if(lpML->m_SaveCache || lpML->m_JukeBoxes[i][j].musicName=="")
				{
					lpML->m_JukeBoxes[i][j].musicName = lpML->m_JukeBoxes[i][j][0].title;
				}

				// VȂ1Ȃł܂܂ĂtO𗧂Ă
				lpML->m_JukeBoxes[i][j].includesNewData = FALSE;
				for(size_t kk=0 ; kk<lpML->m_JukeBoxes[i][j].size() ; kk++)
				{
					if(lpML->m_JukeBoxes[i][j][kk].firstRead + NEW_TIME > time(NULL))
					{
						lpML->m_JukeBoxes[i][j].includesNewData = TRUE;
						break;
					}
				}
			}
			lpML->m_JukeBoxes[i].UnLock();

			k=0; j++;
		}

		if(j >= lpML->m_JukeBoxes[i].size())
		{
			// PJuke

			// SȃXLς݂mF
			BOOL bRead = TRUE;
			for(DWORD a=0;a < lpML->m_JukeBoxes[i].size();a++)
			{
				for(DWORD b=0;b < lpML->m_JukeBoxes[i][a].size();b++)
				{
					bRead &= lpML->m_JukeBoxes[i][a][b].bRead;
				}
			}

			lpML->m_JukeBoxes[i].SetRead(bRead);

			// WriteLog("Juke[%d] finished", i-1);
			j=0; i++;
		}

		if(i >= lpML->m_JukeBoxes.size())
		{
			// XLI
			i = j = k = 0;

			if(posChanged)
			{
				// rŃXLꏊύXꂽ̂ł
				posChanged = FALSE;
			}
			else
			{
				// rŕύXȂ̂ŁAXL̂͂
				WriteLogMT("CMusicList::ScanThread() : obNOEhXL");

				if(lpML->m_SaveCache)
					lpML->SaveCache();

				// XV`FbNXbhX^[g
				// lpML->StartUpdateCheck();

				// Xbh~
				lpML->m_ScanStopEvent.Signal();
			}
		}
	}

goodbye:

	if(lpML->m_SaveCache)
		lpML->SaveCache();

	return 0;
}

BOOL CMusicList::StartUpdateCheck(void)
{
	if(size()==0)
		return FALSE;

	if(m_UpdateThreadHandle==NULL)
	{
		// ߂ČĂ΂ꂽ̂ŃXbh쐬
runThread:
		unsigned int threadDesc;
		m_UpdateThreadHandle = (HANDLE)_beginthreadex(NULL, 0, UpdateCheckThread, this, 0, &threadDesc);
		if(m_UpdateThreadHandle==0)
		{
			WriteLog("CMusicList::StartUpdateCheck() : obOOEhXLXbh̍쐬Ɏs");
			return FALSE;
		}
	}
	else
	{
		// ɃXbh
		// I`FbN
		if(WaitForSingleObject(m_UpdateThreadHandle, 0) == WAIT_OBJECT_0)
		{
			// Xbh͊ɏIĂ̂ōċN
			goto runThread;
		}
		else
		{
			// Xbh͂܂Ă̂ōăX^[gVOi
			if(m_UpdateCheckStartEvent.Signal())
			{
				// ҂
//				m_UpdateCheckStartEvent.Wait(INFINITE);
			}
		}
	}

	return TRUE;
}

BOOL CMusicList::StopUpdateCheck(void)
{
	if(m_UpdateThreadHandle==NULL)
	{
		// XbhȂ
		return FALSE;
	}
	else
	{
		// XbĥŃXgbvVOi
		if(m_UpdateCheckStopEvent.Signal())
		{
			// ҂
//			m_UpdateCheckStopEvent.Wait(INFINITE);
			return TRUE;
		}
		else
			return FALSE;
	}
}

unsigned __stdcall CMusicList::UpdateCheckThread(void* lpMusicList)
{
	CMusicList* lpML = (CMusicList*)lpMusicList;
	if(lpML==NULL)
		return 1;

	if(lpML->m_JukeBoxes.size()==0)
	{
		return 2;
	}
	
	WriteLog("CMusicList::UpdateCheckThread() : t@C̍XVĎX^[g܂");

	// ĎIuWFNg쐬
	for(DWORD i=0;i<lpML->m_JukeBoxes.size();i++)
	{
		// vCx[goLocksvH
		lpML->m_JukeBoxes[i].m_UpdateEvent = FindFirstChangeNotification(lpML->m_JukeBoxes[i].folder.c_str(), TRUE,
			FILE_NOTIFY_CHANGE_FILE_NAME|FILE_NOTIFY_CHANGE_DIR_NAME|FILE_NOTIFY_CHANGE_SIZE|FILE_NOTIFY_CHANGE_LAST_WRITE);

		if(lpML->m_JukeBoxes[i].m_UpdateEvent==INVALID_HANDLE_VALUE)
		{
			WriteLog("CMusicList::UpdateCheckThread() : %s̊ĎIuWFNg쐬Ɏs܂", lpML->m_JukeBoxes[i].folder.c_str());
		}
	}

	while(1)
	{
		// ꎞ~߂`FbN
		if(lpML->m_UpdateCheckStopEvent.Wait(0))
		{
			// Xbhꎞ~
			lpML->m_UpdateCheckStopEvent.UnSignal();

			while(1)
			{
				// ăX^[gȂAIȂ̃VOi҂
				if(lpML->m_UpdateCheckStartEvent.Wait(500))
				{
					// ăX^[gVOi
					lpML->m_UpdateCheckStartEvent.UnSignal();
					break;
				}

				if(lpML->m_UpdateCheckThreadEnd.Wait(50))
				{
					// XbhIVOi
					lpML->m_UpdateCheckThreadEnd.UnSignal();
					goto goodbye;
				}

			}

			if(lpML->m_UpdateCheckStopEvent.Wait(0))
			{
				// ~ɂɒ~Ȃ[
				lpML->m_UpdateCheckStopEvent.UnSignal();
			}
		}

		// I߂`FbN
		if(lpML->m_UpdateCheckThreadEnd.Wait(0))
		{
			// XbhIVOi
			lpML->m_UpdateCheckThreadEnd.UnSignal();
			goto goodbye;
		}

		// XV҂
		int num = lpML->m_JukeBoxes.size();
		const int max_obj = MAXIMUM_WAIT_OBJECTS;
		int checkCount = num/max_obj + (num%max_obj)!=0;

		for(int i=0;i<checkCount;i++)
		{
			HANDLE handle[max_obj];
			int numHandle = 0;
			for(int j=0;j<max_obj;j++)
			{
				int jukePos = i*max_obj + j;
				if(jukePos>=num) break;

				handle[j] = lpML->m_JukeBoxes[jukePos].m_UpdateEvent;
				numHandle++;
			}

			DWORD res = WaitForMultipleObjects(numHandle, handle, FALSE, 500);
			if(WAIT_OBJECT_0<=res && res<=WAIT_OBJECT_0+numHandle-1)
			{
				// XVI
				DWORD upNum = res-WAIT_OBJECT_0;

				WriteLog("CMusicList::UpdateCheckThread() : JukeBox %d̍XVo܂", upNum);

				lpML->m_JukeBoxes[upNum].SetRead(FALSE);
				lpML->SetNextScanTarget(upNum, 0);
				lpML->StartBGScan();

				FindNextChangeNotification(handle[upNum]);
				lpML->m_UpdateCheckStopEvent.Signal();
			}
		}
	}

goodbye:

	// n
	for(DWORD i=0;i<lpML->m_JukeBoxes.size();i++)
	{
		if(lpML->m_JukeBoxes[i].m_UpdateEvent!=INVALID_HANDLE_VALUE)
		{
			FindCloseChangeNotification(lpML->m_JukeBoxes[i].m_UpdateEvent);
			lpML->m_JukeBoxes[i].m_UpdateEvent = INVALID_HANDLE_VALUE;
		}
	}
	
	return 0;
}

// Ōオ'\'ȂΕtĕԂB'\'Ȃ炻̂܂ܕԂ
string CMusicList::AddYen(string path)
{
	// Q̃`FbNōς܂悤ƂƁA"\"̂悤ȂƂ
	// second byteɑ΂IsDBCSLeadByte邱ƂɂȂāA̕ŃoOB
	// ƂƂŁAŏ炷ׂĒH邵Ȃc
	char ch = '\0';
	for(DWORD i=0;i<path.size();i++)
	{
		if(IsDBCSLeadByte((BYTE)path[i]))
			i++;
		else
			ch = path[i];
	}

	if(ch=='\\')
		return path;
	else
		return path + '\\';
}

string CMusicList::RemoveYen(string path)
{
	// Q̃`FbNōς܂悤ƂƁA"\"̂悤ȂƂ
	// second byteɑ΂IsDBCSLeadByte邱ƂɂȂāA̕ŃoOB
	// ƂƂŁAŏ炷ׂĒH邵Ȃc
	char ch = '\0';
	for(DWORD i=0;i<path.size();i++)
	{
		if(IsDBCSLeadByte((BYTE)path[i]))
			i++;
		else
			ch = path[i];
	}

	if(ch=='\\')
		return path.substr(0, path.size()-1);
	else
		return path;
}

// szFullPatḧԌ'\'ȍ~ԂB'\'܂܂ĂȂ΂̂܂ܕԂB
// '\'ŏIĂ""Ԃ
string CMusicList::GetFileName(const string szFullPath){

	int yenPos = -1;

	int i=0;
	for(DWORD i=0;i<szFullPath.size();i++)
	{
		if(IsDBCSLeadByte(BYTE(szFullPath[i])))
			i++;
		else if(szFullPath[i]=='\\')
			yenPos = i;
	}

	if(yenPos==-1)
	{
		// '\'܂܂ĂȂ
		return szFullPath;
	}

	if(yenPos+1 == szFullPath.size())
	{
		// '\'ŏIĂ
		return "";
	}

	return szFullPath.substr(yenPos+1);

}

void CMusicList::SetCurrentToExeDir(void)
{
	// st@C̃tH_Jgɂ(P)
	// t@ChbvċNƃJgC:\WindowsɂȂƂ^RȎdl̂߁B
	char szTxt[MAX_PATH];

	// scm
	if(GetModuleFileName(NULL, szTxt, MAX_PATH)!=0)
	{
		char* yen = strrchr(szTxt, '\\');
		
		// NULLȂ͂͂Ȃ
		if(yen != NULL)
		{
			// EXEt@C؂̂
			yen[1] = '\0';
			SetCurrentDirectory(szTxt);
		}
	}
}

void CMusicList::TryAddData(const string& DirName, const WIN32_FIND_DATA& fd, const int level, const int toplevel)
{
	// ȃf[^t@CJukeɐU蕪
	string jukefolder;
	string dataSetFolder;
	if(level <= toplevel-2)
	{
		// JukeBoxtH_(ʏuꏊ)
		dataSetFolder = GetFileName(DirName);

		jukefolder = DirName;
		CYFile::GetParentDir(jukefolder); // TKwςȂ炱낤
		jukefolder = RemoveYen(jukefolder);
	}
	else
	{
		// [g or JukeBox
		dataSetFolder = ".";
		jukefolder = DirName;
	}

	// ɓo^ĂȂǂT[`
	int targetJuke = -1;
	for(DWORD i=0;i<m_JukeBoxes.size();i++)
	{
		// stricmpȂ̂́AOS炾Ƒ啶ς肷邱Ƃ邽
		if(_stricmp(m_JukeBoxes[i].folder.c_str(), jukefolder.c_str())!=0)
			continue;

		// ɓJuke
		targetJuke = i;
		for(DWORD j=0;j<m_JukeBoxes[i].size();j++)
		{
			if(_stricmp(m_JukeBoxes[i][j].folder.c_str(), dataSetFolder.c_str())!=0)
				continue;

			// ɓf[^Zbg
			for(DWORD k=0;k<m_JukeBoxes[i][j].size();k++)
			{
				if(_stricmp(m_JukeBoxes[i][j][k].szFile.c_str(), fd.cFileName)!=0)
					continue;

				// ɓt@C
				if(m_JukeBoxes[i][j][k].timeStamp.dwLowDateTime == fd.ftLastWriteTime.dwLowDateTime &&
				   m_JukeBoxes[i][j][k].timeStamp.dwHighDateTime == fd.ftLastWriteTime.dwHighDateTime &&
				   m_JukeBoxes[i][j][k].fileSize == fd.nFileSizeLow)
				{
					// XVĂȂBXLbv
					return;
				}
				else
				{
					// XVĂ̂ŏ㏑
					// ZeroMemory(&m_JukeBoxes[i][j][k], sizeof(m_JukeBoxes[i][j][k]));
					WriteLog("Updating %s", m_JukeBoxes[i][j][k].szFile.c_str());

					if(m_JukeBoxes[i][j][k].timeStamp.dwLowDateTime != fd.ftLastWriteTime.dwLowDateTime ||
					   m_JukeBoxes[i][j][k].timeStamp.dwHighDateTime != fd.ftLastWriteTime.dwHighDateTime)
						WriteLog("%s̃^CX^vXVĂ܂ low %u -> %u / high %u -> %u",
							m_JukeBoxes[i][j][k].szFile.c_str(),
							m_JukeBoxes[i][j][k].timeStamp.dwLowDateTime, fd.ftLastWriteTime.dwLowDateTime,
							m_JukeBoxes[i][j][k].timeStamp.dwHighDateTime, fd.ftLastWriteTime.dwHighDateTime
						);

					if(m_JukeBoxes[i][j][k].fileSize != fd.nFileSizeLow)
						WriteLog("%s̃t@CTCYύXĂ܂ %u -> %u",
							m_JukeBoxes[i][j][k].szFile.c_str(),
							m_JukeBoxes[i][j][k].fileSize, fd.nFileSizeLow
						);

					m_JukeBoxes[i][j][k].firstRead = time(NULL);
					m_JukeBoxes[i][j][k].bRead = FALSE;
					m_JukeBoxes[i][j][k].szFile = fd.cFileName;
					m_JukeBoxes[i][j][k].timeStamp = fd.ftLastWriteTime;
					m_JukeBoxes[i][j][k].fileSize = fd.nFileSizeLow;
					m_JukeBoxes[i].SetRead(FALSE);
					return;
				}
			}
		}
	}

	// o^ĂȂ̂ŐVKo^
	if(targetJuke==-1)
	{
		// ΉJukêō쐬
		CJukeBox temp;
		temp.folder = jukefolder;
		temp.jukeName = GetFileName(jukefolder);

		if(temp.jukeName=="" || temp.jukeName==".") // TOP Dir͂ƍ׍H
		{
			temp.jukeName = "Top Directory";
		}

		if(temp.jukeName[temp.jukeName.size()-1] == ':') // "C:" -> "C:\"݂Ȃ
			temp.jukeName += '\\';

		m_JukeBoxes.push_back(temp);
		targetJuke = m_JukeBoxes.size()-1;
	}

	MUSIC_DATA data;
	data.firstRead = time(NULL);
	data.bRead = FALSE;
	data.szFile = fd.cFileName;
	data.timeStamp = fd.ftLastWriteTime;
	data.fileSize = fd.nFileSizeLow;

	// t@Cǉ
	// JukeBoxɒuȂDataSetɂ܂Ƃ߂ȂɐVKȃZbg
	if(dataSetFolder!="" && dataSetFolder!=".")
	{
		// ̋ȃZbgTāA΂ɒǉ
		for(DWORD j=0;j<m_JukeBoxes[targetJuke].size();j++)
		{
			if(m_JukeBoxes[targetJuke][j].folder == dataSetFolder)
			{
				// BǉċA
				m_JukeBoxes[targetJuke][j].musicData.push_back(data);
				return;
			}
		}
	}

	// VKȃZbgĂɒǉ
	MUSIC_DATA_SET dataset;
	dataset.musicData.push_back(data);
	dataset.folder = dataSetFolder;
	m_JukeBoxes[targetJuke].musicDataSet.push_back(dataset);
}

void CMusicList::DirDiver(string DirName, int level)
{
	// TKwBRRς邾JukeBox̍\ςɂȂ܂
	const int toplevel = 2;

	// Kw`FbN
	if(level<0)
		return;

	// pX`FbN
	{
		int last1 = DirName.size()-1;
		int last2 = DirName.size()-2;
		if(last1 < 0 || last2 < 0)
			return;

		// \Ȃɓꂷ
		if(DirName[last1]=='\\' && !IsDBCSLeadByte((BYTE)DirName[last2]))
		{
			DirName = DirName.substr(0, DirName.size()-1);
		}
	}

	// w肳ꂽtH_ɃChJ[hđSt@C 
	string Pattern = DirName + "\\*.*";

	WIN32_FIND_DATA fd;  // 񋓏擾p
	HANDLE hFind = FindFirstFile(Pattern.c_str(), &fd); // ŏ̃t@C 

	if(hFind==INVALID_HANDLE_VALUE)
		return;  // t@C͂P݂Ȃ(ۂ . ..̂ŎsȂ͂)

	do
	{
		if(strcmp(fd.cFileName,".")==0 || strcmp(fd.cFileName,"..")==0)
			continue; // . ..͖

		if(fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
		{
			// tH_ȂTutH_
			string subFolder = DirName;
			subFolder += "\\";
			subFolder += fd.cFileName;

			DirDiver(subFolder, level-1);
		}
		else if(CheckType(fd.cFileName) == TYPE_BMS)
		{
			// t@CȂo^Ă邩`FbN
			TryAddData(DirName, fd, level, toplevel);
		}

	}while(FindNextFile(hFind, &fd) == TRUE);  // t@CȂ܂ő

	FindClose(hFind);  //nh

}

BOOL CMusicList::SearchMusic(string searchRoot)
{
	// JukeBox̂ŁAɃwb_ǂݍ݃Xbh~߂
	StopBGScan();

	SetCurrentToExeDir();
	DirDiver(searchRoot, 2);
	return TRUE;
}

BOOL CMusicList::DeleteNotExist(void)
{
	// ͂ǂ߂񂶂ȂciteratorȂ񂩌[

	vector<CJukeBox>::iterator it1 = m_JukeBoxes.begin();
	int i = 0;
	while(it1 != m_JukeBoxes.end())
	{
		int j = 0;
		vector<MUSIC_DATA_SET>::iterator it2 = (*it1).musicDataSet.begin();
		while(it2 != (*it1).musicDataSet.end())
		{
			vector<MUSIC_DATA>::iterator it3 = (*it2).musicData.begin();
			int k = 0;
			while(it3 != (*it2).musicData.end())
			{
				string file = GetFullPath(i, j, k);

				DWORD res = GetFileAttributes(file.c_str());
				if(res==-1)
				{
					// t@CȂ
					// WriteLog("CMusicList::DeleteNotExist() : %s݂͑܂BXg폜܂", file.c_str());
					it3 = (*it2).musicData.erase(it3);
				}
				else if(res==FILE_ATTRIBUTE_DIRECTORY)
				{
					// ȂŃfBNg˂
					// WriteLog("CMusicList::DeleteNotExist() : %s̓fBNgłBXg폜܂", file.c_str());
					it3 = (*it2).musicData.erase(it3);
				}
				else
				{
					it3++;
					k++;
				}
			}

			if((*it2).musicData.size()==0)
				it2 = (*it1).musicDataSet.erase(it2);
			else
			{
				it2++;
				j++;
			}
		}

		if((*it1).musicDataSet.size()==0)
			it1 = m_JukeBoxes.erase(it1);
		else
		{
			it1++;
			i++;
		}
	}

	return TRUE;

}

BOOL CMusicList::LoadCache(void)
{
	m_LoadCacheLock.Enter();
	{
		FILE* fp = fopen(m_cacheFile.c_str(), "r"); // LbVǂݍ

		if(fp==NULL)
		{
			// WindowstH_ǂł݂
			char szWinDir[MAX_PATH];
			GetWindowsDirectory(szWinDir, MAX_PATH);
			strcat(szWinDir,"\\cache.lst");
			fp = fopen(szWinDir, "r");
		}

		if(fp==NULL)
		{
			m_LoadCacheLock.Leave();
			return FALSE;
		}

		// t@C͊J

		// wb_`FbN
		char sztmp[512];
		GetLine(fp, sztmp, 512);
		if(strcmp(sztmp, "DDR050beta4.3_CacheFile")!=0)
		{
			fclose(fp);
			m_LoadCacheLock.Leave();
			return FALSE;
		}

		int jukeNum, dataSetNum, dataNum;

		// fscanfgȂGetLinesscanfȗR
		//  ɋ󔒕ƁAscanf ֐́Aɋ󔒕ȊO̕܂ŁA
		//  ̓f[^́uuAvv󔒕ǂݎ܂B
		// ƂƂŁAscanf("ȂƂ\n")̌ɋs肷Ƌ
		GetLine(fp,sztmp,512);
		sscanf(sztmp, "%d", &jukeNum);
		for(int i=0;i<jukeNum;i++)
		{
			CJukeBox temp;
			m_JukeBoxes.push_back(temp);

			GetLine(fp,sztmp,512);
			m_JukeBoxes[i].jukeName = sztmp;

			GetLine(fp,sztmp,512);
			m_JukeBoxes[i].folder = sztmp;

			GetLine(fp,sztmp,512);
			sscanf(sztmp, "%d", &dataSetNum);

			for(int j=0;j<dataSetNum;j++)
			{
				MUSIC_DATA_SET temp;
				m_JukeBoxes[i].musicDataSet.push_back(temp);

				GetLine(fp,sztmp,512);
				m_JukeBoxes[i][j].musicName = sztmp;

				GetLine(fp,sztmp,512);
				m_JukeBoxes[i][j].folder = sztmp;

				GetLine(fp,sztmp,512);
				sscanf(sztmp, "%d", &dataNum);

				for(int k=0;k<dataNum;k++)
				{
					MUSIC_DATA temp;
					m_JukeBoxes[i][j].musicData.push_back(temp);

					if(GetLine(fp,sztmp,MAX_PATH)==0) // ŏ1񂭂炢̓G[`FbN
					{
						fclose(fp);
						m_LoadCacheLock.Leave();
						return FALSE;
					}
					m_JukeBoxes[i][j][k].szFile = sztmp;

					GetLine(fp,sztmp,500);
					m_JukeBoxes[i][j][k].title = sztmp;

					GetLine(fp,sztmp,500);
					m_JukeBoxes[i][j][k].artist = sztmp;

					GetLine(fp,sztmp,500);
					m_JukeBoxes[i][j][k].genre = sztmp;

					GetLine(fp,sztmp,MAX_PATH);
					m_JukeBoxes[i][j][k].stageFile = sztmp;

					GetLine(fp,sztmp,512); // [U[f[^̈Bsǂݔ΂

					m_JukeBoxes[i][j][k].crc32 = 0xFFFFFFFF; // vZ
					m_JukeBoxes[i][j][k].WavCh = -1; // 0MSDBGMꂿႤ

					GetLine(fp,sztmp,512);
					assert(sizeof(time_t) == 8);
					sscanf(sztmp, "%I64d %d %u %u %u", &(m_JukeBoxes[i][j][k].firstRead),
													&(m_JukeBoxes[i][j][k].bRead),
													&(m_JukeBoxes[i][j][k].timeStamp.dwLowDateTime),
													&(m_JukeBoxes[i][j][k].timeStamp.dwHighDateTime),
													&(m_JukeBoxes[i][j][k].fileSize));
						
					GetLine(fp,sztmp,512);
					sscanf(sztmp, "%d %d %d %d %d",	&(m_JukeBoxes[i][j][k].player),
													&(m_JukeBoxes[i][j][k].level),
													&(m_JukeBoxes[i][j][k].rank),
													&(m_JukeBoxes[i][j][k].mode),
													&(m_JukeBoxes[i][j][k].bStageFile));
					
					GetLine(fp,sztmp,512);
					sscanf(sztmp, "%lf %d %d %d %d %d %d %d",	&(m_JukeBoxes[i][j][k].dBPM),
																&(m_JukeBoxes[i][j][k].iBMLines),
																&(m_JukeBoxes[i][j][k].iDDRLines),
																&(m_JukeBoxes[i][j][k].CDTr),
																&(m_JukeBoxes[i][j][k].bWavBGM),
																&(m_JukeBoxes[i][j][k].bMidi),
																&(m_JukeBoxes[i][j][k].bBMP),
																&(m_JukeBoxes[i][j][k].bPlayable));
				}
			}
		}

		fclose(fp);
	}
	m_LoadCacheLock.Leave();

	return TRUE;
}

BOOL CMusicList::SaveCache(void)
{
	if(size()==0)
		return FALSE;

	m_SaveCacheLock.Enter();
	{
		DWORD oldAttr = GetFileAttributes(m_cacheFile.c_str());

		SetFileAttributes(m_cacheFile.c_str(), FILE_ATTRIBUTE_NORMAL);
		FILE* fp = fopen(m_cacheFile.c_str(),"w"); // LbV

		if(fp==NULL)
		{
			// WindowstH_ǂł݂
			char szWinDir[MAX_PATH];
			GetWindowsDirectory(szWinDir, MAX_PATH);
			strcat(szWinDir,"\\cache.lst");
			fp = fopen(szWinDir, "w");
		}

		if(fp==NULL)
		{
			if(oldAttr!=0xFFFFFFFF)
				SetFileAttributes(m_cacheFile.c_str(), oldAttr);

			m_SaveCacheLock.Leave();
			return FALSE;
		}

		// t@CĴŏo
		fprintf(fp, "DDR050beta4.3_CacheFile\n");

		fprintf(fp, "%d\n", m_JukeBoxes.size());
		for(DWORD i=0;i<m_JukeBoxes.size();i++)
		{
			m_JukeBoxes[i].Lock();
			{
				fprintf(fp, "%s\n", m_JukeBoxes[i].jukeName.c_str());
				fprintf(fp, "%s\n", m_JukeBoxes[i].folder.c_str());
				fprintf(fp, "%d\n", m_JukeBoxes[i].size());
				for(DWORD j=0;j<m_JukeBoxes[i].size();j++)
				{
					fprintf(fp, "%s\n", m_JukeBoxes[i][j].musicName.c_str());
					fprintf(fp, "%s\n", m_JukeBoxes[i][j].folder.c_str());
					fprintf(fp, "%d\n", m_JukeBoxes[i][j].size());
					for(DWORD k=0;k<m_JukeBoxes[i][j].size();k++)
					{
						fprintf(fp, "%s\n", m_JukeBoxes[i][j][k].szFile.c_str() );
						fprintf(fp, "%s\n", m_JukeBoxes[i][j][k].title.c_str() );
						fprintf(fp, "%s\n", m_JukeBoxes[i][j][k].artist.c_str() );
						fprintf(fp, "%s\n", m_JukeBoxes[i][j][k].genre.c_str() );
						fprintf(fp, "%s\n", m_JukeBoxes[i][j][k].stageFile.c_str() );
						fprintf(fp, "\n"); // [U[f[^̈B512oCgȏ゠Loadɂ܂

						assert(sizeof(time_t) == 8);
						fprintf(fp, "%I64d %d %u %u %u\n", m_JukeBoxes[i][j][k].firstRead,
														m_JukeBoxes[i][j][k].bRead,
														m_JukeBoxes[i][j][k].timeStamp.dwLowDateTime,
														m_JukeBoxes[i][j][k].timeStamp.dwHighDateTime,
														m_JukeBoxes[i][j][k].fileSize);
							
						fprintf(fp, "%d %d %d %d %d\n",	m_JukeBoxes[i][j][k].player,
														m_JukeBoxes[i][j][k].level,
														m_JukeBoxes[i][j][k].rank,
														m_JukeBoxes[i][j][k].mode,
														m_JukeBoxes[i][j][k].bStageFile);
						
						fprintf(fp, "%lf %d %d %d %d %d %d %d\n",	m_JukeBoxes[i][j][k].dBPM,
																	m_JukeBoxes[i][j][k].iBMLines,
																	m_JukeBoxes[i][j][k].iDDRLines,
																	m_JukeBoxes[i][j][k].CDTr,
																	m_JukeBoxes[i][j][k].bWavBGM,
																	m_JukeBoxes[i][j][k].bMidi,
																	m_JukeBoxes[i][j][k].bBMP,
																	m_JukeBoxes[i][j][k].bPlayable);
					}
				}
			}
			m_JukeBoxes[i].UnLock();
		}

		fclose(fp);

		if(oldAttr!=0xFFFFFFFF)
			SetFileAttributes(m_cacheFile.c_str(), oldAttr);
	}
	m_SaveCacheLock.Leave();

	return TRUE;

}

string CMusicList::GetFullPath(DWORD juke, DWORD dataSet, DWORD data)
{
	if(juke>=m_JukeBoxes.size())
		return "";

	if(dataSet>=m_JukeBoxes[juke].size())
		return "";

	if(data>=m_JukeBoxes[juke][dataSet].size())
		return "";

	return m_JukeBoxes[juke].folder + "\\" +
		   m_JukeBoxes[juke][dataSet].folder + "\\" +
		   m_JukeBoxes[juke][dataSet][data].szFile;
}

// 啶ƏA1oCg2oCg𖳎Ĕr
bool CMusicList::less_ignore_case_bytes(const string& lhs, const string& rhs)
{
	int result = CompareString(LOCALE_USER_DEFAULT, NORM_IGNORECASE|NORM_IGNOREWIDTH,
							   lhs.c_str(), lhs.size(), rhs.c_str(), rhs.size());
	return result == CSTR_LESS_THAN;
}

bool CMusicList::eq_ignore_case_bytes(const string& lhs, const string& rhs)
{
	int result = CompareString(LOCALE_USER_DEFAULT, NORM_IGNORECASE|NORM_IGNOREWIDTH,
							   lhs.c_str(), lhs.size(), rhs.c_str(), rhs.size());
	return result == CSTR_EQUAL;
}

bool CMusicList::less_dataset_title(const MUSIC_DATA_SET& lhs, const MUSIC_DATA_SET& rhs)
{
    return less_ignore_case_bytes(lhs.musicName, rhs.musicName);
}

bool CMusicList::less_dataset_scantime(const MUSIC_DATA_SET& lhs, const MUSIC_DATA_SET& rhs)
{
	// VȂ̌ɕׂ
	int numNew[2] = { 0 };

	for(DWORD i=0;i<lhs.musicData.size();i++)
	{
		if(lhs.musicData[i].firstRead+NEW_TIME > time(NULL))
			numNew[0]++;
	}

	for(DWORD i=0;i<rhs.musicData.size();i++)
	{
		if(rhs.musicData[i].firstRead+NEW_TIME > time(NULL))
			numNew[1]++;
	}

	if(numNew[0] == numNew[1])
		return less_dataset_title(lhs, rhs); // Ȃ^Cg
	else
		return numNew[0] > numNew[1];
}

bool CMusicList::less_data_title(const MUSIC_DATA& lhs, const MUSIC_DATA& rhs)
{
    return less_ignore_case_bytes(lhs.title, rhs.title);
}

bool CMusicList::less_data_artist(const MUSIC_DATA& lhs, const MUSIC_DATA& rhs)
{
	if(eq_ignore_case_bytes(lhs.artist, rhs.artist))
		return less_data_title(lhs, rhs); // A[eBXgȂ^Cg
    else
		return less_ignore_case_bytes(lhs.artist, rhs.artist);
}

bool CMusicList::less_data_genre(const MUSIC_DATA& lhs, const MUSIC_DATA& rhs)
{
	if(eq_ignore_case_bytes(lhs.genre, rhs.genre))
		return less_data_title(lhs, rhs); // WȂ^Cg
    else
		return less_ignore_case_bytes(lhs.genre, rhs.genre);
}

bool CMusicList::less_data_level(const MUSIC_DATA& lhs, const MUSIC_DATA& rhs)
{
	if(lhs.level==rhs.level)
		return less_data_title(lhs, rhs); // xȂ^Cg
    else
		return lhs.level < rhs.level;
}

bool CMusicList::less_data_scantime(const MUSIC_DATA& lhs, const MUSIC_DATA& rhs)
{
	// V̂
	return lhs.firstRead > rhs.firstRead;
}

void CMusicList::Sort(DWORD juke, DWORD dataSet, int key)
{
	if(juke>=m_JukeBoxes.size())
		return;

	m_JukeBoxes[juke].Lock();
	{
		if(!m_JukeBoxes[juke].IsRead() || dataSet>=m_JukeBoxes[juke].size())
		{
			// ł邩邟
			m_JukeBoxes[juke].UnLock();
			return;
		}

		switch(key)
		{
			case SORT_NONE: break;

			case SORT_TITLE:
				stable_sort(m_JukeBoxes[juke][dataSet].musicData.begin(), 
							m_JukeBoxes[juke][dataSet].musicData.end(),
							less_data_title);
				break;

			case SORT_ARTIST:
				stable_sort(m_JukeBoxes[juke][dataSet].musicData.begin(), 
							m_JukeBoxes[juke][dataSet].musicData.end(),
							less_data_artist);
				break;

			case SORT_GENRE:
				stable_sort(m_JukeBoxes[juke][dataSet].musicData.begin(), 
							m_JukeBoxes[juke][dataSet].musicData.end(),
							less_data_genre);
				break;

			case SORT_LEVEL:
				stable_sort(m_JukeBoxes[juke][dataSet].musicData.begin(), 
							m_JukeBoxes[juke][dataSet].musicData.end(),
							less_data_level);
				break;

			case SORT_SCANTIME:
				stable_sort(m_JukeBoxes[juke][dataSet].musicData.begin(), 
							m_JukeBoxes[juke][dataSet].musicData.end(),
							less_data_scantime);
				break;
		}
	}
	m_JukeBoxes[juke].UnLock();
}

void CMusicList::Sort(DWORD juke, int key)
{
	if(juke>=m_JukeBoxes.size())
		return;

	m_JukeBoxes[juke].Lock();
	{
		if(!m_JukeBoxes[juke].IsRead())
		{
			// ܂ǂłȂ̂Ƀ\[gł邩邟
			m_JukeBoxes[juke].UnLock();
			return;
		}

		switch(key)
		{
			case SORT_NONE: break;

			case SORT_TITLE:
				stable_sort(m_JukeBoxes[juke].musicDataSet.begin(), 
							m_JukeBoxes[juke].musicDataSet.end(),
							less_dataset_title);
				break;

			case SORT_SCANTIME:
				stable_sort(m_JukeBoxes[juke].musicDataSet.begin(), 
							m_JukeBoxes[juke].musicDataSet.end(),
							less_dataset_scantime);
				break;
		}
	}
	m_JukeBoxes[juke].UnLock();
}

string CMusicList::Trim(string title)
{
	string result;

	// JbR̃lXg
	int nestCount = 0;

	for(string::iterator it = title.begin() ; it!=title.end() ; it++)
	{
		if(IsDBCSLeadByte(*it))
		{
			// QoCg
			string ch;
			ch += (*it);

			// ͂̕PoCg
			it++;

			ch += (*it);
			
			const string pLeft  = "iuowkqsy"; // left parenthesis
			const string pRight = "jvpxlrtz"; // right parenthesis

			if(pLeft.find(ch) != string::npos)
			{
				// Jn
				nestCount++;
			}
			else if(pRight.find(ch) != string::npos)
			{
				// I
				nestCount--;
			}
			else if(nestCount==0)
			{
				result += ch;
			}

		}
		else
		{
			// PoCg
			char ch = (*it);

			const string pLeft  = "({[<"; // left parenthesis
			const string pRight = ")}]>"; // right parenthesis

			if(pLeft.find(ch) != string::npos)
			{
				// Jn
				nestCount++;
			}
			else if(pRight.find(ch) != string::npos)
			{
				// I
				nestCount--;
			}
			else if(nestCount==0)
			{
				result += ch;
			}
		}
	}

	while(result.size()>=0)
	{
		int last = result.size()-1;

		// ŏEŌ̋󔒕ځ`
		if(result[0] == ' ')
			result = result.substr(1);
		else if(result[0] == '\t')
			result = result.substr(1);
		else if(result.substr(0, 2) == "@")
			result = result.substr(2);

		else if(result[last] == ' ')
			result = result.substr(0, last);
		else if(result[last] == '\t')
			result = result.substr(0, last);
		else if(last>=1 && result.substr(last-1, 2) == "@")
			result = result.substr(0, last-1);
		else
			break;
	}

	return result;
}


string CMusicList::DecideMusicName(DWORD juke, DWORD dataset) const
{
	return "";
/*	vector<string> list;
	for(DWORD i=0;i<m_JukeBoxes[juke][dataset].size();i++)
	{
		list.push_back(Trim(m_JukeBoxes[juke][dataset][i].title));
	}

	typedef struct tagpair {
		string key;
		int count;
	} PAIR;
	vector<PAIR> counter;

	for(DWORD i=0;i<list.size();i++)
	{
		string tmp=list[i]+" ";
		int size1 = tmp.size();

		for(DWORD j=0;j<counter.size();j++)
		{
			int size2 = counter[j].key.size();
			bool useSp=false;

			for(int k=0 ; k<size1 && k<size2 ; k++)
			{
				useSp|=(list[i][k]==" ");
				if(list[i][k] != counter[j].key[k])
				{
					if(useSp)
					{
						//܂
					}
				}
			}
		}
	}
*/
}
