//
//	DirectDraw.h
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef __DirectDraw__
#define __DirectDraw__

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

//#ifndef DIRECTDRAW_VERSION
//#define DIRECTDRAW_VERSION 0x0300
//#endif
#define INITGUID
#include <ddraw.h>
#pragma comment(lib, "ddraw.lib")

#include <stdio.h>

#include "SPI.h"
#include "yaneFile.h"
#include "yaneCPUID.h"

#define OFFSCR_W		640
#define OFFSCR_H		480
#define SCR_W			640
#define SCR_H			480

#define LOAD_RAM		1	// BitmapRAMɓǂݍ
#define LOAD_DEFAULT	2	// BitmapVRAMRAMɓǂݍ

//#define FLIP_DIRECTBLT_SLEEPLESS 0
#define FLIP_DIRECTBLT	1
#define FLIP_WAITVSYNC	2

#define MAX_BMP			512
#define MAX_TEMPBMP		2048
#define MAX_SPRITE		2048
#define MAX_INST		128
#define MAX(x,y)		(x = (x<y ? x : y)) // xy𒴂yAłȂxxɑ
#define F(X)			(float)(X)	// float^ϊ
#define ABS(x)			( (x)>(0.0) ? (x) : (-(x)) )

#define MMX_EXISTS		(CCPUID::GetID()>=3 ? TRUE : FALSE)

extern void GetLastErrorStr(char* str);

class nsDraw{

private:
	LPDIRECTDRAW        lpDD;            // DirectDraw IuWFNg
	LPDIRECTDRAWSURFACE lpFrontBuffer;   // \obt@
	LPDIRECTDRAWSURFACE lpBackBuffer;    // obt@
	//LPDIRECTDRAWSURFACE lpBitmap;      // p^[
	LPDIRECTDRAWCLIPPER lpDDClipper;
	LPDIRECTDRAWPALETTE lpPalette;       // pbg
	PALETTEENTRY        pePal[256];      // pbg\

	HWND m_hwnd;

	int iFPS,iFlipMode;
	int m_iColorDepth;
	DWORD dwFPSWait,dwFPSWaitTT;

	BOOL bStretch; // BltŊgkT|[gĂ邩

	BOOL m_bFullScr;

	BOOL m_bRoundBlack; // RGB(0,0,0)ȂF𔲂Fɂ邩ǂ

	static unsigned int MaskR,MaskG,MaskB,MaskRGB; // sNZ
	static unsigned int BitR,BitG,BitB;
	static unsigned int ShiftR,ShiftG,ShiftB;

	/*typedef struct
	{
		RGBQUAD Depth;
	    RGBQUAD Amount;
		RGBQUAD Position;
	} RGB16;
	*/

	char szPalFile[MAX_PATH]; // LoadPalette()Ɏgt@CoƂăLbV

	struct bmp{
		LPDIRECTDRAWSURFACE lpSurf;
		char szFileName[MAX_PATH];
		BOOL bCache; // LbVg
		int x,y;
	} BMP[MAX_BMP];

	struct tagTempBmp{
		LPDIRECTDRAWSURFACE lpSurf;
		int x,y;
		int iSpNum; // XvCgԍێBRestorêƂy
	} TEMP_BMP[MAX_TEMPBMP];

	struct tagStretchInstance{
		int iSpNum;
		int iTempBMPNumLow;		// TEMP_BMP̗vfԍŏ
		int iTempBMPNumHigh;	// TEMP_BMP̗vfԍő+1
		double lowval,highval;	// gAk͈
		double res;				// \
	} strInst[MAX_INST];

	struct sp{
		int iSurfNum;
//		LPDIRECTDRAWSURFACE lpSurf;
		int x,y,dx,dy;
	} sprite[MAX_SPRITE];

	CSPI spi[3];

	BOOL StartDirectDraw(HWND hwnd, int iColorDepth, BOOL bFullScr = FALSE, int numBackBuff = 1);
	BOOL DDFailure(HWND hwnd, char* szTxt);
	void EndDirectDraw(void);
	void RestoreDirectDraw(void);
	HRESULT PutBitmap(LPDIRECTDRAWSURFACE lpBitmap, int bx, int by, RECT* rect, double size, BOOL bUseCC, BOOL bCentering);
	HRESULT PutBitmap(LPDIRECTDRAWSURFACE lpBitmap, RECT DestRect, RECT SrcRect, BOOL bUseCC);
	//BOOL LoadBMP ( LPDIRECTDRAWSURFACE surface, char *bmp );
	//BOOL GetRBG16 ( LPDIRECTDRAWSURFACE Surface, RGB16 *rgb16 );

	char* GetError(HRESULT Code);
//	void GetLastErrorStr(char* str);

	// SetDIBitsToDeviceœǂ
	IDirectDrawSurface* DDLoadBitmap(IDirectDraw* pdd,LPCSTR szBitmap,int dx,int dy,int Memory,BOOL bCache);
	BOOL DecodeRLE(const BITMAPINFOHEADER* BI, const BYTE* src, BYTE** dst);

	// LoadImageœǂ
	IDirectDrawSurface* DDLoadBitmap2(IDirectDraw* pdd,LPCSTR szBitmap,int dx,int dy,int Memory,BOOL bCache);
	// SusiePluginœǂ
	IDirectDrawSurface* LoadSPIImage(IDirectDraw* pdd,LPCSTR szBitmap,int dx,int dy,int Memory,BOOL bCache);

	HRESULT DDCopyBitmap(LPDIRECTDRAWSURFACE pdds, HBITMAP hbm, int x,int y,int dx,int dy);
	DWORD   DDColorMatch(LPDIRECTDRAWSURFACE pdds,COLORREF rgb);
	HRESULT DDSetColorKey(LPDIRECTDRAWSURFACE pdds,COLORREF rgb);

	// Surfaceɑ΂ZeroMemory
	BOOL ClearSurface(LPDIRECTDRAWSURFACE pdds);

	// to avoid 32bit mode bug
	void ClearMSB(LPDIRECTDRAWSURFACE lpsurf);

	// jpgƂ16bit[hOōC[摜̂߂ɁA
	// RGB(0,0,0)痣ꂽFRGB(0,0,0)ɏ
	void RoundBlackColor(LPDIRECTDRAWSURFACE lpsurf);

//	void ElapseTime(void); // (C)yaneurao 1998-1999
	BOOL DrawTempBMP(int iBMPNum, int x, int y);

	int GetBpp(void);

public:

	BOOL bReady;

	nsDraw();
	~nsDraw();

	void Flip(void);	//0:DirectBlt&Sleepless 1:DirectBlt 2:WaitVSYNC
	BOOL FlipToDC(HDC hDC); // DCփobNT[tFCX]

	void ClearScreen(void);
//	void GetKeyInfo();

	BOOL DrawText(int x, int y, const char* txt, COLORREF color=RGB(255,255,255), BOOL bShadow = TRUE);
	BOOL Init(HWND hwnd, int iColorDepth = 16, BOOL bFullScr = FALSE, int numBackBuff = 1);
	BOOL LoadPalette(char* szFile);

	BOOL LoadBMP(int iBMPNum, char* szFileName, COLORREF color=RGB(0,0,0), int mem = LOAD_DEFAULT);
	BOOL UnLoadBMP(int iBMPNum);

	void SetMemCache(int iBMPNum, BOOL bUse){ BMP[iBMPNum].bCache = bUse; };

	int MoveTo(int iBMPNum, BOOL bVRAM); // bVRAM==TRUEȂT[tFCXVRAM FALSEȂSysRAM

	BOOL DefSprite(int iSpNum, int iBMPNum, int x, int y, int dx, int dy);
	BOOL DefSprite(int iSpNum, int iBMPNum);

	BOOL DrawSprite(int iSpNum,int x, int y, double size = 1.0, BOOL bUseCC = TRUE, BOOL bCentering = TRUE);
	BOOL DrawSprite(int iSpNum,RECT DestRect, BOOL bUseCC = TRUE);

	BOOL DrawSpriteWipe(int iSpNum, int x, int y, int progress, BOOL bUseCC = TRUE);
	BOOL DrawSpriteWipePrimary(int iSpNum, int x, int y, int progress, BOOL bUseCC = FALSE);
	BOOL PrimaryWipeErase(int progress);

	// obNobt@̎w͈̖͂邳1/2ɂB銄ɂ͂
	// x(dx-x)Ǝ኱
	BOOL DownBrightness(int x=0, int y=0, int dx=0, int dy=0);

	BOOL BrightBlt(int iSpNum, int Px,int Py,float Bright,int X1=0,int Y1=0,int X2=0,int Y2=0);
	BOOL BlendBlt(int iSpNum,int Px,int Py,float Blend,BOOL bUseMMX=TRUE,int X1=0,int Y1=0,int X2=0,int Y2=0);
	BOOL AddBlt(int iSpNum,int Px,int Py,int X1=0,int Y1=0,int X2=0,int Y2=0);

	BOOL FillRect(int x, int y, int dx, int dy, DWORD color=0);
		
	//	HRESULT RestoreDisplayMode(void);
	LPDIRECTDRAW GetLpDD(void){	return( lpDD ); };
	LPDIRECTDRAWSURFACE GetLpBackBuff(void){ return (lpBackBuffer); };

	HDC  GetDC(void);
	void ReleaseDC(HDC hDC);

	void Restore(void);

	int GetBMPX(int iBMPNum);
	int GetBMPY(int iBMPNum);

	int GetSpriteX(int num){ return(sprite[num].dx - sprite[num].x); };
	int GetSpriteY(int num){ return(sprite[num].dy - sprite[num].y); };

	DWORD GetFreeVRAM(void);
	DWORD GetTotalVRAM(void);

	DWORD GetRefreshRate(void);
	int   GetScreenColor(void){return m_iColorDepth;};

	BOOL SyncScreen(void);

//	void SetFPS(int fps);
//	int  GetFPS(void){ return(iFPS); };

	void SetFlipMode(int iMode){ iFlipMode = iMode; };
	int  GetFlipMode(void){ return(iFlipMode); };

	BOOL SetStretchInstance(int iSpNum, double lowval, double highval, double resolution, COLORREF color=RGB(0,0,0), BOOL bUseVRAM = TRUE);
	BOOL StretchBltFast(int iSpNum, int x, int y, double size, BOOL bCentering=TRUE);
	void ReleaseStretchInstanceAll(void);

	void SetBlackColorRounding(BOOL bRound){ m_bRoundBlack = bRound; };

};

#endif