// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "DirectPlay.h"

	// {8A2AB1EE-6178-11d3-9E1E-605E53C10000}
//	DEFINE_GUID(nsPlay_GUID,
//	0x8a2ab1ee, 0x6178, 0x11d3, 0x9e, 0x1e, 0x60, 0x5e, 0x53, 0xc1, 0x0, 0x0);

const GUID nsPlay_GUID = {0x685bc400, 0x9d2c, 0x11cf, { 0xa9, 0xcd, 0x00, 0xaa, 0x00, 0x68, 0x86, 0xe3 } };

//	// {685BC400-9D2C-11cf-A9CD-00AA006886E3}
//	DEFINE_GUID(IPX_GUID,
//	0x685bc400, 0x9d2c, 0x11cf, 0xa9, 0xcd, 0x00, 0xaa, 0x00, 0x68, 0x86, 0xe3);

// {AD6B17C0-64A3-11d3-9E1E-D0AD50C10600}
DEFINE_GUID(game_GUID,
0xad6b17c0, 0x64a3, 0x11d3, 0x9e, 0x1e, 0xd0, 0xad, 0x50, 0xc1, 0x6, 0x0);

extern void WriteLog(const char* Format,...);

nsPlay::nsPlay(){

	strcpy(SessionName,"DDR Club Kit");

	lpDP		= NULL;
	iSendPac	= 0;
	iReceivePac = 0;

	imode  = -1;
	bReady = FALSE;
	bInit  = FALSE;

}

nsPlay::~nsPlay(){

	Close();

	if(lpDP!=NULL)
	{
//		lpDP->Close();
		lpDP->Release();
		lpDP = NULL;
	}

	bInit  = FALSE;

}

/*------------------------------------------------------------------------------*/
/*-                                                                            -*/
/*-  T[rX̌                                              Ŏgp  -*/
/*-                                                                            -*/
/*-    p[^[ȗ                                                        -*/
/*-                                                                            -*/
/*------------------------------------------------------------------------------*/
GUID nsPlay::IPX_GUID;

BOOL FAR PASCAL nsPlay::SearchService(LPGUID Guid,LPTSTR ServiceName,DWORD Version1,
							  DWORD Version2,LPVOID None)
{

//	if(strcmp(ServiceName,"DirectPlay ɑ΂ IPX ڑ")==0 ||
//	   strcmp(ServiceName,"IPX Connection For DirectPlay")==0   )

	char* str1 = ServiceName;
	char* str2 = "IPX";
//	char* str2 = "TCP/IP";

	while(*str1 != '\0')
	{
		if(_strnicmp(str1,str2,strlen(str2))==0)
			IPX_GUID=*Guid;
		str1++;
	}

	return TRUE; // 񋓑s

}

BOOL nsPlay::Init(void)//int No)
{

	if(bInit)
		return TRUE;

	HRESULT dpret;
	LPDIRECTPLAY dp = NULL;

//	GUID ipx_GUID = IPX_GUID;

	dpret = DirectPlayEnumerate(SearchService,(LPVOID)NULL);
	if(dpret!=DP_OK)
	{
		WriteLog("nsPlay::Init() : DirectPlayEnumerate()Ɏs(Reason:%s)",GetError(dpret));
		return FALSE;
	}

	if ((dpret=DirectPlayCreate(&IPX_GUID,&dp,NULL))==DP_OK)
	{
		if (dp)
		{
			dpret = dp->QueryInterface(IID_IDirectPlay2A, (LPVOID*)&lpDP);
			dp->Release();
		}
	}

	if (dp==NULL)
	{
		WriteLog("nsPlay::Init() : DirectPlaypł܂(Reason:%s)",GetError(dpret));
		return FALSE;
	}

	WriteLog("nsPlay::Init() : DirectPlay̏ɐ");
	bInit = TRUE;

	return TRUE;
}

//CONNECT_SERVER or CONNECT_CLIENT
BOOL nsPlay::Connect(int mode){

	if(mode==CONNECT_SERVER)
	{
		if(!CreateGame())
			return FALSE;

		if(!CreatePlayer())
			return FALSE;

		imode = mode;

//		WriteLog("nsPlay::Connect(SERVER) : ڑ");
		return TRUE;
	}
	else //Clientmode
	{
		if(!ListGame())
			return FALSE;

		if(!JoinGame())
			return FALSE;

		if(!CreatePlayer())
			return FALSE;

		imode  = mode;
		bReady = TRUE;

//		WriteLog("nsPlay::Connect(CLIENT) : ڑ");
		return TRUE;
	}

	return FALSE;

}

void nsPlay::Close(void){

//	if(bReady)
//		Send(0,SYS_DISCONNECT,TRUE);

	if(lpDP!=NULL)
		lpDP->Close();

	imode  = -1;
	bReady = FALSE;

}

BOOL nsPlay::CreatePlayer(void)
{
	static DPNAME name;

	memset(&name,0x00,sizeof(DPNAME));
	name.dwSize=sizeof(DPNAME);
	name.lpszShortNameA="nsPlay Player";
	name.lpszLongNameA=NULL;

	HRESULT res;
	res = lpDP->CreatePlayer(&PlayerID,&name,NULL,NULL,0,0);
	if (res!=DP_OK)
	{
		WriteLog("nsPlay::CreatePlayer() : vC[쐬ł܂(Reason:%s)",GetError(res));
		return FALSE;
	}

	return TRUE;
}

BOOL nsPlay::CreateGame(void)
{
	DPSESSIONDESC2 session;

	memset(&session,0x00,sizeof(DPSESSIONDESC2));
	session.dwSize=sizeof(DPSESSIONDESC2);
	session.dwFlags=DPSESSION_MIGRATEHOST|DPSESSION_KEEPALIVE;
	session.guidApplication=nsPlay_GUID;
	session.dwMaxPlayers=2;
	session.lpszSessionNameA=SessionName;

	HRESULT res;
	res = lpDP->Open(&session,DPOPEN_CREATE);
	if (res!=DP_OK)
	{
//		session_GUID = session.guidInstance;
		WriteLog("nsPlay::CreateGame() : Q[쐬ł܂(Reason:%s)",GetError(res));
		return FALSE;
	}

	return TRUE;
}

BOOL nsPlay::JoinGame(void)//int GameNo)
{
	static DPSESSIONDESC2 session;

	memset(&session,0x00,sizeof(DPSESSIONDESC2));
	session.dwSize=sizeof(DPSESSIONDESC2);
	session.guidApplication=nsPlay_GUID;
	session.guidInstance=session_GUID;

	HRESULT res;
	res = lpDP->Open(&session,DPOPEN_JOIN);
	if (res!=DP_OK)
	{
		WriteLog("nsPlay::JoinGame() : ZbVɐڑł܂(Reason:%s)",GetError(res));
		return FALSE;
	}

	return TRUE;
}

// vC[ڑҋ@(T[o)
BOOL nsPlay::WaitPlayer(void)
{
	static DPID SendID,ReceiveID;
	static unsigned long DataSize;
	char Buffer[256];

	Buffer[0]=NULL;
	DataSize=256;

	if (lpDP->Receive(&SendID,&ReceiveID,DPRECEIVE_ALL,Buffer,&DataSize)!=DP_OK)
	{
		return FALSE;
	}

	if (SendID==DPID_SYSMSG)
	{
		if (((LPDPMSG_GENERIC)(Buffer))->dwType==DPSYS_CREATEPLAYERORGROUP)
		{
			bReady = TRUE;
			WriteLog("nsPlay::WaitPlayer() : ڑ");
			return TRUE;
		}
	}

	return FALSE;
}

BOOL nsPlay::Send(double data, int type, BOOL bRetry/*=FALSE*/)
{
	if(!bReady)
		return FALSE;

//	static char Buffer[128];

	DPData dat;
	dat.data = data;
	dat.type = type;

	// Mpɕϊ
//	memcpy(Buffer,&dat,sizeof(dat));

	DWORD dwFlag;

	if(bRetry)
		dwFlag = DPSEND_GUARANTEED;
	else
		dwFlag = 0;

	HRESULT res;
	// bZ[WM
	res = lpDP->Send(PlayerID,DPID_ALLPLAYERS,dwFlag,&dat,sizeof(dat));

	if(res==DP_OK)
	{
		iSendPac++;
		return TRUE;
	}
	else
	{
		WriteLog("nsPlay::Send()Ɏs(Reason:%s)",GetError(res));
		return FALSE;
	}
/*	// MrbgɉZ
	BpsCnt+=(long)(sizeof(Buffer)*8);

	if (MessageAutoRetry)
	{
		// bZ[WXgNõJEg
		if (++SendListNo>LIST_MAX) SendListNo=1;
	}
*/
}

BOOL nsPlay::Receive(double& data,int& type)
{
	if(!bReady)
		return FALSE;

	static DPID SendID,ReceiveID;
	static char Buffer[128];

	// lbg[ÑbZ[WM̏ꍇ
	Buffer[0]=NULL;
	DWORD DataSize = 128;

	// 128oCgĖʂȋC邯ǁAVXebZ[W\łc
	HRESULT res = lpDP->Receive(&SendID, &ReceiveID, DPRECEIVE_ALL, Buffer, &DataSize);
	if (res!=DP_OK)
	{
		if(res!=DPERR_NOMESSAGES)
			WriteLog("nsPlay::Receive()Ɏs(Reason:%s)",GetError(res));

		return FALSE;
	}

	if (SendID==DPID_SYSMSG)
	{
		if(((DPMSG_GENERIC*)(Buffer))->dwType == DPSYS_DESTROYPLAYERORGROUP)
		{
			// ؒfM
			Close();
		}
		return FALSE;
	}

	data = ((DPData*)Buffer)->data;
	type = ((DPData*)Buffer)->type;

//	if(type==SYS_DISCONNECT)
//	{
//		// ؒfM
//		Close();
//	}

	iReceivePac++;
	return TRUE;

}

// ListGamepCallBack
GUID nsPlay::session_GUID;

BOOL FAR PASCAL nsPlay::SearchGame(LPCDPSESSIONDESC2 Session,LPDWORD TimeOut,DWORD Flag,LPVOID Context)
{

	if (Flag&DPESC_TIMEDOUT) return FALSE;

	session_GUID = Session->guidInstance;

	return TRUE;
}

/*------------------------------------------------------------------------------*/
/*-                                                                            -*/
/*-  ғQ[̈ꗗ                                          Ŏgp  -*/
/*-                                                                            -*/
/*-    ߂l : TRUE  = I                                               -*/
/*-           : FALSE = G[                                             -*/
/*-                                                                            -*/
/*------------------------------------------------------------------------------*/

BOOL nsPlay::ListGame(void)
{
	static DPSESSIONDESC2 session;

	memset(&session,0x00,sizeof(DPSESSIONDESC2));
	session.dwSize=sizeof(DPSESSIONDESC2);
	session.guidApplication=nsPlay_GUID;

	HRESULT res = lpDP->EnumSessions(&session,0, SearchGame, NULL, DPENUMSESSIONS_AVAILABLE);
	if (res!=DP_OK)
	{
		WriteLog("nsPlay::ListGame() : EnumSessions()Ɏs(Reason:%s)",GetError(res));
		return FALSE;
	}

	return TRUE;
}

/*
DWORD nsPlay::CheckDelay(void){
	
	if(!bReady)
		return 99999;

	Send(





}
*/

// ̃bZ[W܂ő҂B
// ̊Ԃ̊֌WȂbZ[Wׂ͂ĖȂ̂ŒӁB
BOOL nsPlay::WaitMessage(int type,int timeout/*=10000*/){

	int typeR;
	double data;

	DWORD limit = timeGetTime()+timeout;

	do
	{
		if(Receive(data,typeR))
		{
			if(typeR==type)
				return TRUE;
		}
	}while(limit>timeGetTime());

	return FALSE;

}

char* nsPlay::GetError(HRESULT res){

	static char buf[128];

	switch(res)
	{
	case CLASS_E_NOAGGREGATION		: return("CLASS_E_NOAGGREGATION");
	case DP_OK						: return("DP_OK");
	case DPERR_ACCESSDENIED			: return("DPERR_ACCESSDENIED");
	case DPERR_ACTIVEPLAYERS		: return("DPERR_ACTIVEPLAYERS");
	case DPERR_ALREADYINITIALIZED	: return("DPERR_ALREADYINITIALIZED");
	case DPERR_APPNOTSTARTED		: return("DPERR_APPNOTSTARTED");
	case DPERR_AUTHENTICATIONFAILED	: return("DPERR_AUTHENTICATIONFAILED");
	case DPERR_BUFFERTOOLARGE		: return("DPERR_BUFFERTOOLARGE");
	case DPERR_BUSY					: return("DPERR_BUSY");
	case DPERR_BUFFERTOOSMALL		: return("DPERR_BUFFERTOOSMALL");
	case DPERR_CANTADDPLAYER		: return("DPERR_CANTADDPLAYER");
	case DPERR_CANTCREATEGROUP		: return("DPERR_CANTCREATEGROUP");
	case DPERR_CANTCREATEPLAYER		: return("DPERR_CANTCREATEPLAYER");
	case DPERR_CANTCREATEPROCESS	: return("DPERR_CANTCREATEPROCESS");
	case DPERR_CANTCREATESESSION	: return("DPERR_CANTCREATESESSION");
	case DPERR_CANTLOADCAPI			: return("DPERR_CANTLOADCAPI");
	case DPERR_CANTLOADSECURITYPACKAGE	: return("DPERR_CANTLOADSECURITYPACKAGE");
	case DPERR_CANTLOADSSPI			: return("DPERR_CANTLOADSSPI");
	case DPERR_CAPSNOTAVAILABLEYET	: return("DPERR_CAPSNOTAVAILABLEYET");
	case DPERR_CONNECTING			: return("DPERR_CONNECTING");
	case DPERR_ENCRYPTIONFAILED		: return("DPERR_ENCRYPTIONFAILED");
	case DPERR_EXCEPTION			: return("DPERR_EXCEPTION");
	case DPERR_GENERIC				: return("DPERR_GENERIC");
//	case DPERR_INVALIDCREDENTIALS	: return("DPERR_INVALIDCREDENTIALS");
	case DPERR_INVALIDFLAGS			: return("DPERR_INVALIDFLAGS");
	case DPERR_INVALIDGROUP			: return("DPERR_INVALIDGROUP");
	case DPERR_INVALIDINTERFACE		: return("DPERR_INVALIDINTERFACE");
	case DPERR_INVALIDOBJECT		: return("DPERR_INVALIDOBJECT");
	case DPERR_INVALIDPARAMS		: return("DPERR_INVALIDPARAMS");
	case DPERR_INVALIDPASSWORD		: return("DPERR_INVALIDPASSWORD");
	case DPERR_INVALIDPLAYER		: return("DPERR_INVALIDPLAYER");
	case DPERR_LOGONDENIED			: return("DPERR_LOGONDENIED");
	case DPERR_NOCAPS				: return("DPERR_NOCAPS");
	case DPERR_NOCONNECTION			: return("DPERR_NOCONNECTION");
	case DPERR_NOINTERFACE			: return("DPERR_NOINTERFACE");
	case DPERR_NOMESSAGES			: return("DPERR_NOMESSAGES");
	case DPERR_NONAMESERVERFOUND	: return("DPERR_NONAMESERVERFOUND");
	case DPERR_NONEWPLAYERS			: return("DPERR_NONEWPLAYERS");
	case DPERR_NOPLAYERS			: return("DPERR_NOPLAYERS");
	case DPERR_NOSESSIONS			: return("DPERR_NOSESSIONS");
	case DPERR_NOTLOBBIED			: return("DPERR_NOTLOBBIED");
	case DPERR_NOTLOGGEDIN			: return("DPERR_NOTLOGGEDIN");
	case DPERR_OUTOFMEMORY			: return("DPERR_OUTOFMEMORY");
	case DPERR_PLAYERLOST			: return("DPERR_PLAYERLOST");
	case DPERR_SENDTOOBIG			: return("DPERR_SENDTOOBIG");
	case DPERR_SESSIONLOST			: return("DPERR_SESSIONLOST");
	case DPERR_SIGNFAILED			: return("DPERR_SIGNFAILED");
	case DPERR_TIMEOUT				: return("DPERR_TIMEOUT");
	case DPERR_UNAVAILABLE			: return("DPERR_UNAVAILABLE");
	case DPERR_UNINITIALIZED		: return("DPERR_UNINITIALIZED");
	case DPERR_UNKNOWNAPPLICATION	: return("DPERR_UNKNOWNAPPLICATION");
	case DPERR_UNSUPPORTED			: return("DPERR_UNSUPPORTED");
	case DPERR_USERCANCEL			: return("DPERR_USERCANCEL");

	default:
		sprintf(buf, "Unknown(0x%08x)", res);
		return buf;
	}
}
