//////////////////////////////
//	[ sound.h ]				//
//	DirectSound̐		//
//	1996.9.7 Y.Yutaka		//
//	-1997.11.2				//
//////////////////////////////

// Copyright Y.Yutaka 1996 - 1997.
// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef _SOUND_H
#define _SOUND_H

#include <windows.h>
#include <mmsystem.h>

#define DIRECTSOUND_VERSION 0x0300
//	DirectX7DSBUFFERDESC\̂̃TCY傫ȂĂ̂ł̑΍

// ŐṼwb_gƈꕔŏł炵
// A}CN\tg̃R[hSourceForgeɂ͍ڂȂ
#include <dsound.h>
#pragma comment(lib, "dsound.lib")

#include <stdio.h>
#include <string.h>

#include "AudioStream.h"

#define MAX_WAV 1024

class CWaveControl
{

private:

	IDirectSound *lpDS;					//DirectSoundObject
	IDirectSoundBuffer *lpDSPriBuff;	//ꎟTEhobt@

	int SoundFlag;			//TEhg邩ǂ

	BOOL m_IsSystemMem;		// vC}obt@̓n[hA\tg

	typedef struct
	{
		short state;						// wavet@C݂邩ǂ
		IDirectSoundBuffer *lpDSBuff;		// 񎟃TEhobt@

		char szFile[MAX_PATH];				// Wavet@C
		DWORD length;
		DWORD AvgBytesPerSec;					//	bԂ̃f[^oCgiĐʒuZopj
		DWORD freq;							// ̎g

		// for Streaming buffer
		BOOL bStream;
	} WAVERES;

	WAVERES WavResources[MAX_WAV];

	AudioStream m_AudioStream;
	
	char* GetError(HRESULT res);

	// foCX񋓃R[obN
	static BOOL CALLBACK DSEnumCallback(LPGUID lpGuid, LPCSTR lpcstrDescription, LPCSTR lpcstrModule, LPVOID lpContext);

public:
	CWaveControl();
	~CWaveControl();
	//Wavet@Cǂݍ
	BOOL LoadWaveFile(int num, const char* fname, BOOL bStream=FALSE);
	BOOL ReleaseWave(int num);

	//TEh
	BOOL Init(HWND hwnd, int kHz=22, int bits=8, int Channels=1);
	void Term(void);

	BOOL Play(int num, BOOL bLoop=FALSE);			//TEhĐ
	void Stop(int num);			//TEh~
	void StopAll(void);

	void Pause(int num);
	void PauseAll(void);

	void Restart(int num);
	void RestartAll(void);
	
	void SetVolume(int num,int vol);
	int  GetVolume(int num);

	BOOL IsReady(int num);
	BOOL IsPlaying(int num);

	BOOL SetFreq(int num, double percent); // g̕ύXBPʂ͌̒ĺ
	DWORD GetFreq(int num); // g擾BHzŕԂ

	// WAV̒擾BPʃ~bB擾s0xFFFFFFFF
	DWORD GetLength(int num);

	// Đʒu擾BPʃ~bB擾s0xFFFFFFFF
	DWORD GetCurrentPos(int num);
};

#endif
